package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SpectrumTaskBuilder extends SpectrumTaskFluentImpl<SpectrumTaskBuilder> implements VisitableBuilder<SpectrumTask,SpectrumTaskBuilder>{
  public SpectrumTaskBuilder() {
    this(false);
  }
  public SpectrumTaskBuilder(Boolean validationEnabled) {
    this(new SpectrumTask(), validationEnabled);
  }
  public SpectrumTaskBuilder(SpectrumTaskFluent<?> fluent) {
    this(fluent, false);
  }
  public SpectrumTaskBuilder(SpectrumTaskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SpectrumTask(), validationEnabled);
  }
  public SpectrumTaskBuilder(SpectrumTaskFluent<?> fluent,SpectrumTask instance) {
    this(fluent, instance, false);
  }
  public SpectrumTaskBuilder(SpectrumTaskFluent<?> fluent,SpectrumTask instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBaseImage(instance.getBaseImage()); 
    fluent.withContextDir(instance.getContextDir()); 
    fluent.withImage(instance.getImage()); 
    fluent.withName(instance.getName()); 
    fluent.withRegistry(instance.getRegistry()); 
    this.validationEnabled = validationEnabled; 
  }
  public SpectrumTaskBuilder(SpectrumTask instance) {
    this(instance,false);
  }
  public SpectrumTaskBuilder(SpectrumTask instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBaseImage(instance.getBaseImage()); 
    this.withContextDir(instance.getContextDir()); 
    this.withImage(instance.getImage()); 
    this.withName(instance.getName()); 
    this.withRegistry(instance.getRegistry()); 
    this.validationEnabled = validationEnabled; 
  }
  SpectrumTaskFluent<?> fluent;
  Boolean validationEnabled;
  public SpectrumTask build() {
    SpectrumTask buildable = new SpectrumTask(fluent.getBaseImage(),fluent.getContextDir(),fluent.getImage(),fluent.getName(),fluent.getRegistry());
    return buildable;
  }
  
}