package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CamelArtifactDependencyBuilder extends CamelArtifactDependencyFluentImpl<CamelArtifactDependencyBuilder> implements VisitableBuilder<CamelArtifactDependency,CamelArtifactDependencyBuilder>{
  public CamelArtifactDependencyBuilder() {
    this(false);
  }
  public CamelArtifactDependencyBuilder(Boolean validationEnabled) {
    this(new CamelArtifactDependency(), validationEnabled);
  }
  public CamelArtifactDependencyBuilder(CamelArtifactDependencyFluent<?> fluent) {
    this(fluent, false);
  }
  public CamelArtifactDependencyBuilder(CamelArtifactDependencyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CamelArtifactDependency(), validationEnabled);
  }
  public CamelArtifactDependencyBuilder(CamelArtifactDependencyFluent<?> fluent,CamelArtifactDependency instance) {
    this(fluent, instance, false);
  }
  public CamelArtifactDependencyBuilder(CamelArtifactDependencyFluent<?> fluent,CamelArtifactDependency instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withArtifactId(instance.getArtifactId()); 
    fluent.withExclusions(instance.getExclusions()); 
    fluent.withGroupId(instance.getGroupId()); 
    fluent.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  public CamelArtifactDependencyBuilder(CamelArtifactDependency instance) {
    this(instance,false);
  }
  public CamelArtifactDependencyBuilder(CamelArtifactDependency instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withArtifactId(instance.getArtifactId()); 
    this.withExclusions(instance.getExclusions()); 
    this.withGroupId(instance.getGroupId()); 
    this.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  CamelArtifactDependencyFluent<?> fluent;
  Boolean validationEnabled;
  public CamelArtifactDependency build() {
    CamelArtifactDependency buildable = new CamelArtifactDependency(fluent.getArtifactId(),fluent.getExclusions(),fluent.getGroupId(),fluent.getVersion());
    return buildable;
  }
  
}