package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.util.Collection;
import java.util.Map;

 /**
  * Generated
  */
public interface MavenBuildSpecFluent<A extends MavenBuildSpecFluent<A>> extends Fluent<A>{
  public SecretKeySelector getCaSecret();
  public A withCaSecret(SecretKeySelector caSecret);
  public Boolean hasCaSecret();
  public A withNewCaSecret(String key,String name,Boolean optional);
  public A addToCaSecrets(Integer index,SecretKeySelector item);
  public A setToCaSecrets(Integer index,SecretKeySelector item);
  public A addToCaSecrets(io.fabric8.kubernetes.api.model.SecretKeySelector... items);
  public A addAllToCaSecrets(Collection<SecretKeySelector> items);
  public A removeFromCaSecrets(io.fabric8.kubernetes.api.model.SecretKeySelector... items);
  public A removeAllFromCaSecrets(Collection<SecretKeySelector> items);
  public List<SecretKeySelector> getCaSecrets();
  public SecretKeySelector getCaSecret(Integer index);
  public SecretKeySelector getFirstCaSecret();
  public SecretKeySelector getLastCaSecret();
  public SecretKeySelector getMatchingCaSecret(Predicate<SecretKeySelector> predicate);
  public Boolean hasMatchingCaSecret(Predicate<SecretKeySelector> predicate);
  public A withCaSecrets(List<SecretKeySelector> caSecrets);
  public A withCaSecrets(io.fabric8.kubernetes.api.model.SecretKeySelector... caSecrets);
  public Boolean hasCaSecrets();
  public A addNewCaSecret(String key,String name,Boolean optional);
  public A addToCliOptions(Integer index,String item);
  public A setToCliOptions(Integer index,String item);
  public A addToCliOptions(java.lang.String... items);
  public A addAllToCliOptions(Collection<String> items);
  public A removeFromCliOptions(java.lang.String... items);
  public A removeAllFromCliOptions(Collection<String> items);
  public List<String> getCliOptions();
  public String getCliOption(Integer index);
  public String getFirstCliOption();
  public String getLastCliOption();
  public String getMatchingCliOption(Predicate<String> predicate);
  public Boolean hasMatchingCliOption(Predicate<String> predicate);
  public A withCliOptions(List<String> cliOptions);
  public A withCliOptions(java.lang.String... cliOptions);
  public Boolean hasCliOptions();
  public A addToExtension(Integer index,MavenArtifact item);
  public A setToExtension(Integer index,MavenArtifact item);
  public A addToExtension(io.fabric8.camelk.v1.MavenArtifact... items);
  public A addAllToExtension(Collection<MavenArtifact> items);
  public A removeFromExtension(io.fabric8.camelk.v1.MavenArtifact... items);
  public A removeAllFromExtension(Collection<MavenArtifact> items);
  public A removeMatchingFromExtension(Predicate<MavenArtifactBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildExtension instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MavenArtifact> getExtension();
  public List<MavenArtifact> buildExtension();
  public MavenArtifact buildExtension(Integer index);
  public MavenArtifact buildFirstExtension();
  public MavenArtifact buildLastExtension();
  public MavenArtifact buildMatchingExtension(Predicate<MavenArtifactBuilder> predicate);
  public Boolean hasMatchingExtension(Predicate<MavenArtifactBuilder> predicate);
  public A withExtension(List<MavenArtifact> extension);
  public A withExtension(io.fabric8.camelk.v1.MavenArtifact... extension);
  public Boolean hasExtension();
  public A addNewExtension(String artifactId,String groupId,String version);
  public MavenBuildSpecFluent.ExtensionNested<A> addNewExtension();
  public MavenBuildSpecFluent.ExtensionNested<A> addNewExtensionLike(MavenArtifact item);
  public MavenBuildSpecFluent.ExtensionNested<A> setNewExtensionLike(Integer index,MavenArtifact item);
  public MavenBuildSpecFluent.ExtensionNested<A> editExtension(Integer index);
  public MavenBuildSpecFluent.ExtensionNested<A> editFirstExtension();
  public MavenBuildSpecFluent.ExtensionNested<A> editLastExtension();
  public MavenBuildSpecFluent.ExtensionNested<A> editMatchingExtension(Predicate<MavenArtifactBuilder> predicate);
  public String getLocalRepository();
  public A withLocalRepository(String localRepository);
  public Boolean hasLocalRepository();
  public A addToProperties(String key,String value);
  public A addToProperties(Map<String,String> map);
  public A removeFromProperties(String key);
  public A removeFromProperties(Map<String,String> map);
  public Map<String,String> getProperties();
  public <K,V>A withProperties(Map<String,String> properties);
  public Boolean hasProperties();
  public A addToRepositories(Integer index,Repository item);
  public A setToRepositories(Integer index,Repository item);
  public A addToRepositories(io.fabric8.camelk.v1.Repository... items);
  public A addAllToRepositories(Collection<Repository> items);
  public A removeFromRepositories(io.fabric8.camelk.v1.Repository... items);
  public A removeAllFromRepositories(Collection<Repository> items);
  public A removeMatchingFromRepositories(Predicate<RepositoryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildRepositories instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Repository> getRepositories();
  public List<Repository> buildRepositories();
  public Repository buildRepository(Integer index);
  public Repository buildFirstRepository();
  public Repository buildLastRepository();
  public Repository buildMatchingRepository(Predicate<RepositoryBuilder> predicate);
  public Boolean hasMatchingRepository(Predicate<RepositoryBuilder> predicate);
  public A withRepositories(List<Repository> repositories);
  public A withRepositories(io.fabric8.camelk.v1.Repository... repositories);
  public Boolean hasRepositories();
  public MavenBuildSpecFluent.RepositoriesNested<A> addNewRepository();
  public MavenBuildSpecFluent.RepositoriesNested<A> addNewRepositoryLike(Repository item);
  public MavenBuildSpecFluent.RepositoriesNested<A> setNewRepositoryLike(Integer index,Repository item);
  public MavenBuildSpecFluent.RepositoriesNested<A> editRepository(Integer index);
  public MavenBuildSpecFluent.RepositoriesNested<A> editFirstRepository();
  public MavenBuildSpecFluent.RepositoriesNested<A> editLastRepository();
  public MavenBuildSpecFluent.RepositoriesNested<A> editMatchingRepository(Predicate<RepositoryBuilder> predicate);
  public A addToServers(Integer index,Server item);
  public A setToServers(Integer index,Server item);
  public A addToServers(io.fabric8.camelk.v1.Server... items);
  public A addAllToServers(Collection<Server> items);
  public A removeFromServers(io.fabric8.camelk.v1.Server... items);
  public A removeAllFromServers(Collection<Server> items);
  public A removeMatchingFromServers(Predicate<ServerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildServers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Server> getServers();
  public List<Server> buildServers();
  public Server buildServer(Integer index);
  public Server buildFirstServer();
  public Server buildLastServer();
  public Server buildMatchingServer(Predicate<ServerBuilder> predicate);
  public Boolean hasMatchingServer(Predicate<ServerBuilder> predicate);
  public A withServers(List<Server> servers);
  public A withServers(io.fabric8.camelk.v1.Server... servers);
  public Boolean hasServers();
  public MavenBuildSpecFluent.ServersNested<A> addNewServer();
  public MavenBuildSpecFluent.ServersNested<A> addNewServerLike(Server item);
  public MavenBuildSpecFluent.ServersNested<A> setNewServerLike(Integer index,Server item);
  public MavenBuildSpecFluent.ServersNested<A> editServer(Integer index);
  public MavenBuildSpecFluent.ServersNested<A> editFirstServer();
  public MavenBuildSpecFluent.ServersNested<A> editLastServer();
  public MavenBuildSpecFluent.ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSettings instead.
   * @return The buildable object.
   */
  @Deprecated
  public ValueSource getSettings();
  public ValueSource buildSettings();
  public A withSettings(ValueSource settings);
  public Boolean hasSettings();
  public MavenBuildSpecFluent.SettingsNested<A> withNewSettings();
  public MavenBuildSpecFluent.SettingsNested<A> withNewSettingsLike(ValueSource item);
  public MavenBuildSpecFluent.SettingsNested<A> editSettings();
  public MavenBuildSpecFluent.SettingsNested<A> editOrNewSettings();
  public MavenBuildSpecFluent.SettingsNested<A> editOrNewSettingsLike(ValueSource item);
  public interface ExtensionNested<N> extends Nested<N>,MavenArtifactFluent<MavenBuildSpecFluent.ExtensionNested<N>>{
    public N and();
    public N endExtension();
    
  }
  public interface RepositoriesNested<N> extends Nested<N>,RepositoryFluent<MavenBuildSpecFluent.RepositoriesNested<N>>{
    public N and();
    public N endRepository();
    
  }
  public interface ServersNested<N> extends Nested<N>,ServerFluent<MavenBuildSpecFluent.ServersNested<N>>{
    public N and();
    public N endServer();
    
  }
  public interface SettingsNested<N> extends Nested<N>,ValueSourceFluent<MavenBuildSpecFluent.SettingsNested<N>>{
    public N and();
    public N endSettings();
    
  }
  
}