package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationPlatformKameletSpecBuilder extends IntegrationPlatformKameletSpecFluentImpl<IntegrationPlatformKameletSpecBuilder> implements VisitableBuilder<IntegrationPlatformKameletSpec,IntegrationPlatformKameletSpecBuilder>{
  public IntegrationPlatformKameletSpecBuilder() {
    this(false);
  }
  public IntegrationPlatformKameletSpecBuilder(Boolean validationEnabled) {
    this(new IntegrationPlatformKameletSpec(), validationEnabled);
  }
  public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IntegrationPlatformKameletSpec(), validationEnabled);
  }
  public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpecFluent<?> fluent,IntegrationPlatformKameletSpec instance) {
    this(fluent, instance, false);
  }
  public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpecFluent<?> fluent,IntegrationPlatformKameletSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRepositories(instance.getRepositories()); 
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpec instance) {
    this(instance,false);
  }
  public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRepositories(instance.getRepositories()); 
    this.validationEnabled = validationEnabled; 
  }
  IntegrationPlatformKameletSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IntegrationPlatformKameletSpec build() {
    IntegrationPlatformKameletSpec buildable = new IntegrationPlatformKameletSpec(fluent.getRepositories());
    return buildable;
  }
  
}