package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MavenBuildSpecFluentImpl<A extends MavenBuildSpecFluent<A>> extends BaseFluent<A> implements MavenBuildSpecFluent<A>{
  public MavenBuildSpecFluentImpl() {
  }
  public MavenBuildSpecFluentImpl(MavenBuildSpec instance) {
    this.withCaSecret(instance.getCaSecret()); 
    this.withCaSecrets(instance.getCaSecrets()); 
    this.withCliOptions(instance.getCliOptions()); 
    this.withExtension(instance.getExtension()); 
    this.withLocalRepository(instance.getLocalRepository()); 
    this.withProperties(instance.getProperties()); 
    this.withRepositories(instance.getRepositories()); 
    this.withServers(instance.getServers()); 
    this.withSettings(instance.getSettings()); 
  }
  private SecretKeySelector caSecret;
  private List<SecretKeySelector> caSecrets = new ArrayList<SecretKeySelector>();
  private List<String> cliOptions = new ArrayList<String>();
  private ArrayList<MavenArtifactBuilder> extension = new ArrayList<MavenArtifactBuilder>();
  private String localRepository;
  private Map<String,String> properties;
  private ArrayList<RepositoryBuilder> repositories = new ArrayList<RepositoryBuilder>();
  private ArrayList<ServerBuilder> servers = new ArrayList<ServerBuilder>();
  private ValueSourceBuilder settings;
  public SecretKeySelector getCaSecret() {
    return this.caSecret;
  }
  public A withCaSecret(SecretKeySelector caSecret) {
    this.caSecret=caSecret; return (A) this;
  }
  public Boolean hasCaSecret() {
    return this.caSecret != null;
  }
  public A withNewCaSecret(String key,String name,Boolean optional) {
    return (A)withCaSecret(new SecretKeySelector(key, name, optional));
  }
  public A addToCaSecrets(Integer index,SecretKeySelector item) {
    if (this.caSecrets == null) {this.caSecrets = new ArrayList<SecretKeySelector>();}
    this.caSecrets.add(index, item);
    return (A)this;
  }
  public A setToCaSecrets(Integer index,SecretKeySelector item) {
    if (this.caSecrets == null) {this.caSecrets = new ArrayList<SecretKeySelector>();}
    this.caSecrets.set(index, item); return (A)this;
  }
  public A addToCaSecrets(io.fabric8.kubernetes.api.model.SecretKeySelector... items) {
    if (this.caSecrets == null) {this.caSecrets = new ArrayList<SecretKeySelector>();}
    for (SecretKeySelector item : items) {this.caSecrets.add(item);} return (A)this;
  }
  public A addAllToCaSecrets(Collection<SecretKeySelector> items) {
    if (this.caSecrets == null) {this.caSecrets = new ArrayList<SecretKeySelector>();}
    for (SecretKeySelector item : items) {this.caSecrets.add(item);} return (A)this;
  }
  public A removeFromCaSecrets(io.fabric8.kubernetes.api.model.SecretKeySelector... items) {
    for (SecretKeySelector item : items) {if (this.caSecrets!= null){ this.caSecrets.remove(item);}} return (A)this;
  }
  public A removeAllFromCaSecrets(Collection<SecretKeySelector> items) {
    for (SecretKeySelector item : items) {if (this.caSecrets!= null){ this.caSecrets.remove(item);}} return (A)this;
  }
  public List<SecretKeySelector> getCaSecrets() {
    return this.caSecrets;
  }
  public SecretKeySelector getCaSecret(Integer index) {
    return this.caSecrets.get(index);
  }
  public SecretKeySelector getFirstCaSecret() {
    return this.caSecrets.get(0);
  }
  public SecretKeySelector getLastCaSecret() {
    return this.caSecrets.get(caSecrets.size() - 1);
  }
  public SecretKeySelector getMatchingCaSecret(Predicate<SecretKeySelector> predicate) {
    for (SecretKeySelector item: caSecrets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCaSecret(Predicate<SecretKeySelector> predicate) {
    for (SecretKeySelector item: caSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCaSecrets(List<SecretKeySelector> caSecrets) {
    if (caSecrets != null) {this.caSecrets = new ArrayList(); for (SecretKeySelector item : caSecrets){this.addToCaSecrets(item);}} else { this.caSecrets = null;} return (A) this;
  }
  public A withCaSecrets(io.fabric8.kubernetes.api.model.SecretKeySelector... caSecrets) {
    if (this.caSecrets != null) {this.caSecrets.clear();}
    if (caSecrets != null) {for (SecretKeySelector item :caSecrets){ this.addToCaSecrets(item);}} return (A) this;
  }
  public Boolean hasCaSecrets() {
    return caSecrets != null && !caSecrets.isEmpty();
  }
  public A addNewCaSecret(String key,String name,Boolean optional) {
    return (A)addToCaSecrets(new SecretKeySelector(key, name, optional));
  }
  public A addToCliOptions(Integer index,String item) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    this.cliOptions.add(index, item);
    return (A)this;
  }
  public A setToCliOptions(Integer index,String item) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    this.cliOptions.set(index, item); return (A)this;
  }
  public A addToCliOptions(java.lang.String... items) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    for (String item : items) {this.cliOptions.add(item);} return (A)this;
  }
  public A addAllToCliOptions(Collection<String> items) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    for (String item : items) {this.cliOptions.add(item);} return (A)this;
  }
  public A removeFromCliOptions(java.lang.String... items) {
    for (String item : items) {if (this.cliOptions!= null){ this.cliOptions.remove(item);}} return (A)this;
  }
  public A removeAllFromCliOptions(Collection<String> items) {
    for (String item : items) {if (this.cliOptions!= null){ this.cliOptions.remove(item);}} return (A)this;
  }
  public List<String> getCliOptions() {
    return this.cliOptions;
  }
  public String getCliOption(Integer index) {
    return this.cliOptions.get(index);
  }
  public String getFirstCliOption() {
    return this.cliOptions.get(0);
  }
  public String getLastCliOption() {
    return this.cliOptions.get(cliOptions.size() - 1);
  }
  public String getMatchingCliOption(Predicate<String> predicate) {
    for (String item: cliOptions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCliOption(Predicate<String> predicate) {
    for (String item: cliOptions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCliOptions(List<String> cliOptions) {
    if (cliOptions != null) {this.cliOptions = new ArrayList(); for (String item : cliOptions){this.addToCliOptions(item);}} else { this.cliOptions = null;} return (A) this;
  }
  public A withCliOptions(java.lang.String... cliOptions) {
    if (this.cliOptions != null) {this.cliOptions.clear();}
    if (cliOptions != null) {for (String item :cliOptions){ this.addToCliOptions(item);}} return (A) this;
  }
  public Boolean hasCliOptions() {
    return cliOptions != null && !cliOptions.isEmpty();
  }
  public A addToExtension(Integer index,MavenArtifact item) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").add(index >= 0 ? index : _visitables.get("extension").size(), builder);this.extension.add(index >= 0 ? index : extension.size(), builder); return (A)this;
  }
  public A setToExtension(Integer index,MavenArtifact item) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
    if (index < 0 || index >= _visitables.get("extension").size()) { _visitables.get("extension").add(builder); } else { _visitables.get("extension").set(index, builder);}
    if (index < 0 || index >= extension.size()) { extension.add(builder); } else { extension.set(index, builder);}
     return (A)this;
  }
  public A addToExtension(io.fabric8.camelk.v1.MavenArtifact... items) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").add(builder);this.extension.add(builder);} return (A)this;
  }
  public A addAllToExtension(Collection<MavenArtifact> items) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").add(builder);this.extension.add(builder);} return (A)this;
  }
  public A removeFromExtension(io.fabric8.camelk.v1.MavenArtifact... items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").remove(builder);if (this.extension != null) {this.extension.remove(builder);}} return (A)this;
  }
  public A removeAllFromExtension(Collection<MavenArtifact> items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").remove(builder);if (this.extension != null) {this.extension.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExtension(Predicate<MavenArtifactBuilder> predicate) {
    if (extension == null) return (A) this;
    final Iterator<MavenArtifactBuilder> each = extension.iterator();
    final List visitables = _visitables.get("extension");
    while (each.hasNext()) {
      MavenArtifactBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExtension instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MavenArtifact> getExtension() {
    return extension != null ? build(extension) : null;
  }
  public List<MavenArtifact> buildExtension() {
    return extension != null ? build(extension) : null;
  }
  public MavenArtifact buildExtension(Integer index) {
    return this.extension.get(index).build();
  }
  public MavenArtifact buildFirstExtension() {
    return this.extension.get(0).build();
  }
  public MavenArtifact buildLastExtension() {
    return this.extension.get(extension.size() - 1).build();
  }
  public MavenArtifact buildMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: extension) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: extension) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtension(List<MavenArtifact> extension) {
    if (this.extension != null) { _visitables.get("extension").removeAll(this.extension);}
    if (extension != null) {this.extension = new ArrayList(); for (MavenArtifact item : extension){this.addToExtension(item);}} else { this.extension = null;} return (A) this;
  }
  public A withExtension(io.fabric8.camelk.v1.MavenArtifact... extension) {
    if (this.extension != null) {this.extension.clear();}
    if (extension != null) {for (MavenArtifact item :extension){ this.addToExtension(item);}} return (A) this;
  }
  public Boolean hasExtension() {
    return extension != null && !extension.isEmpty();
  }
  public A addNewExtension(String artifactId,String groupId,String version) {
    return (A)addToExtension(new MavenArtifact(artifactId, groupId, version));
  }
  public MavenBuildSpecFluent.ExtensionNested<A> addNewExtension() {
    return new MavenBuildSpecFluentImpl.ExtensionNestedImpl();
  }
  public MavenBuildSpecFluent.ExtensionNested<A> addNewExtensionLike(MavenArtifact item) {
    return new MavenBuildSpecFluentImpl.ExtensionNestedImpl(-1, item);
  }
  public MavenBuildSpecFluent.ExtensionNested<A> setNewExtensionLike(Integer index,MavenArtifact item) {
    return new MavenBuildSpecFluentImpl.ExtensionNestedImpl(index, item);
  }
  public MavenBuildSpecFluent.ExtensionNested<A> editExtension(Integer index) {
    if (extension.size() <= index) throw new RuntimeException("Can't edit extension. Index exceeds size.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public MavenBuildSpecFluent.ExtensionNested<A> editFirstExtension() {
    if (extension.size() == 0) throw new RuntimeException("Can't edit first extension. The list is empty.");
    return setNewExtensionLike(0, buildExtension(0));
  }
  public MavenBuildSpecFluent.ExtensionNested<A> editLastExtension() {
    int index = extension.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extension. The list is empty.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public MavenBuildSpecFluent.ExtensionNested<A> editMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extension.size();i++) { 
    if (predicate.test(extension.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extension. No match found.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public String getLocalRepository() {
    return this.localRepository;
  }
  public A withLocalRepository(String localRepository) {
    this.localRepository=localRepository; return (A) this;
  }
  public Boolean hasLocalRepository() {
    return this.localRepository != null;
  }
  public A addToProperties(String key,String value) {
    if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap(); }
    if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
  }
  public A addToProperties(Map<String,String> map) {
    if(this.properties == null && map != null) { this.properties = new LinkedHashMap(); }
    if(map != null) { this.properties.putAll(map);} return (A)this;
  }
  public A removeFromProperties(String key) {
    if(this.properties == null) { return (A) this; }
    if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
  }
  public A removeFromProperties(Map<String,String> map) {
    if(this.properties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
  }
  public Map<String,String> getProperties() {
    return this.properties;
  }
  public <K,V>A withProperties(Map<String,String> properties) {
    if (properties == null) { this.properties =  null;} else {this.properties = new LinkedHashMap(properties);} return (A) this;
  }
  public Boolean hasProperties() {
    return this.properties != null;
  }
  public A addToRepositories(Integer index,Repository item) {
    if (this.repositories == null) {this.repositories = new ArrayList<RepositoryBuilder>();}
    RepositoryBuilder builder = new RepositoryBuilder(item);_visitables.get("repositories").add(index >= 0 ? index : _visitables.get("repositories").size(), builder);this.repositories.add(index >= 0 ? index : repositories.size(), builder); return (A)this;
  }
  public A setToRepositories(Integer index,Repository item) {
    if (this.repositories == null) {this.repositories = new ArrayList<RepositoryBuilder>();}
    RepositoryBuilder builder = new RepositoryBuilder(item);
    if (index < 0 || index >= _visitables.get("repositories").size()) { _visitables.get("repositories").add(builder); } else { _visitables.get("repositories").set(index, builder);}
    if (index < 0 || index >= repositories.size()) { repositories.add(builder); } else { repositories.set(index, builder);}
     return (A)this;
  }
  public A addToRepositories(io.fabric8.camelk.v1.Repository... items) {
    if (this.repositories == null) {this.repositories = new ArrayList<RepositoryBuilder>();}
    for (Repository item : items) {RepositoryBuilder builder = new RepositoryBuilder(item);_visitables.get("repositories").add(builder);this.repositories.add(builder);} return (A)this;
  }
  public A addAllToRepositories(Collection<Repository> items) {
    if (this.repositories == null) {this.repositories = new ArrayList<RepositoryBuilder>();}
    for (Repository item : items) {RepositoryBuilder builder = new RepositoryBuilder(item);_visitables.get("repositories").add(builder);this.repositories.add(builder);} return (A)this;
  }
  public A removeFromRepositories(io.fabric8.camelk.v1.Repository... items) {
    for (Repository item : items) {RepositoryBuilder builder = new RepositoryBuilder(item);_visitables.get("repositories").remove(builder);if (this.repositories != null) {this.repositories.remove(builder);}} return (A)this;
  }
  public A removeAllFromRepositories(Collection<Repository> items) {
    for (Repository item : items) {RepositoryBuilder builder = new RepositoryBuilder(item);_visitables.get("repositories").remove(builder);if (this.repositories != null) {this.repositories.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRepositories(Predicate<RepositoryBuilder> predicate) {
    if (repositories == null) return (A) this;
    final Iterator<RepositoryBuilder> each = repositories.iterator();
    final List visitables = _visitables.get("repositories");
    while (each.hasNext()) {
      RepositoryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRepositories instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Repository> getRepositories() {
    return repositories != null ? build(repositories) : null;
  }
  public List<Repository> buildRepositories() {
    return repositories != null ? build(repositories) : null;
  }
  public Repository buildRepository(Integer index) {
    return this.repositories.get(index).build();
  }
  public Repository buildFirstRepository() {
    return this.repositories.get(0).build();
  }
  public Repository buildLastRepository() {
    return this.repositories.get(repositories.size() - 1).build();
  }
  public Repository buildMatchingRepository(Predicate<RepositoryBuilder> predicate) {
    for (RepositoryBuilder item: repositories) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRepository(Predicate<RepositoryBuilder> predicate) {
    for (RepositoryBuilder item: repositories) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRepositories(List<Repository> repositories) {
    if (this.repositories != null) { _visitables.get("repositories").removeAll(this.repositories);}
    if (repositories != null) {this.repositories = new ArrayList(); for (Repository item : repositories){this.addToRepositories(item);}} else { this.repositories = null;} return (A) this;
  }
  public A withRepositories(io.fabric8.camelk.v1.Repository... repositories) {
    if (this.repositories != null) {this.repositories.clear();}
    if (repositories != null) {for (Repository item :repositories){ this.addToRepositories(item);}} return (A) this;
  }
  public Boolean hasRepositories() {
    return repositories != null && !repositories.isEmpty();
  }
  public MavenBuildSpecFluent.RepositoriesNested<A> addNewRepository() {
    return new MavenBuildSpecFluentImpl.RepositoriesNestedImpl();
  }
  public MavenBuildSpecFluent.RepositoriesNested<A> addNewRepositoryLike(Repository item) {
    return new MavenBuildSpecFluentImpl.RepositoriesNestedImpl(-1, item);
  }
  public MavenBuildSpecFluent.RepositoriesNested<A> setNewRepositoryLike(Integer index,Repository item) {
    return new MavenBuildSpecFluentImpl.RepositoriesNestedImpl(index, item);
  }
  public MavenBuildSpecFluent.RepositoriesNested<A> editRepository(Integer index) {
    if (repositories.size() <= index) throw new RuntimeException("Can't edit repositories. Index exceeds size.");
    return setNewRepositoryLike(index, buildRepository(index));
  }
  public MavenBuildSpecFluent.RepositoriesNested<A> editFirstRepository() {
    if (repositories.size() == 0) throw new RuntimeException("Can't edit first repositories. The list is empty.");
    return setNewRepositoryLike(0, buildRepository(0));
  }
  public MavenBuildSpecFluent.RepositoriesNested<A> editLastRepository() {
    int index = repositories.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last repositories. The list is empty.");
    return setNewRepositoryLike(index, buildRepository(index));
  }
  public MavenBuildSpecFluent.RepositoriesNested<A> editMatchingRepository(Predicate<RepositoryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<repositories.size();i++) { 
    if (predicate.test(repositories.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching repositories. No match found.");
    return setNewRepositoryLike(index, buildRepository(index));
  }
  public A addToServers(Integer index,Server item) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(index >= 0 ? index : _visitables.get("servers").size(), builder);this.servers.add(index >= 0 ? index : servers.size(), builder); return (A)this;
  }
  public A setToServers(Integer index,Server item) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    ServerBuilder builder = new ServerBuilder(item);
    if (index < 0 || index >= _visitables.get("servers").size()) { _visitables.get("servers").add(builder); } else { _visitables.get("servers").set(index, builder);}
    if (index < 0 || index >= servers.size()) { servers.add(builder); } else { servers.set(index, builder);}
     return (A)this;
  }
  public A addToServers(io.fabric8.camelk.v1.Server... items) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  public A addAllToServers(Collection<Server> items) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  public A removeFromServers(io.fabric8.camelk.v1.Server... items) {
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
  }
  public A removeAllFromServers(Collection<Server> items) {
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServers(Predicate<ServerBuilder> predicate) {
    if (servers == null) return (A) this;
    final Iterator<ServerBuilder> each = servers.iterator();
    final List visitables = _visitables.get("servers");
    while (each.hasNext()) {
      ServerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Server> getServers() {
    return servers != null ? build(servers) : null;
  }
  public List<Server> buildServers() {
    return servers != null ? build(servers) : null;
  }
  public Server buildServer(Integer index) {
    return this.servers.get(index).build();
  }
  public Server buildFirstServer() {
    return this.servers.get(0).build();
  }
  public Server buildLastServer() {
    return this.servers.get(servers.size() - 1).build();
  }
  public Server buildMatchingServer(Predicate<ServerBuilder> predicate) {
    for (ServerBuilder item: servers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingServer(Predicate<ServerBuilder> predicate) {
    for (ServerBuilder item: servers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServers(List<Server> servers) {
    if (this.servers != null) { _visitables.get("servers").removeAll(this.servers);}
    if (servers != null) {this.servers = new ArrayList(); for (Server item : servers){this.addToServers(item);}} else { this.servers = null;} return (A) this;
  }
  public A withServers(io.fabric8.camelk.v1.Server... servers) {
    if (this.servers != null) {this.servers.clear();}
    if (servers != null) {for (Server item :servers){ this.addToServers(item);}} return (A) this;
  }
  public Boolean hasServers() {
    return servers != null && !servers.isEmpty();
  }
  public MavenBuildSpecFluent.ServersNested<A> addNewServer() {
    return new MavenBuildSpecFluentImpl.ServersNestedImpl();
  }
  public MavenBuildSpecFluent.ServersNested<A> addNewServerLike(Server item) {
    return new MavenBuildSpecFluentImpl.ServersNestedImpl(-1, item);
  }
  public MavenBuildSpecFluent.ServersNested<A> setNewServerLike(Integer index,Server item) {
    return new MavenBuildSpecFluentImpl.ServersNestedImpl(index, item);
  }
  public MavenBuildSpecFluent.ServersNested<A> editServer(Integer index) {
    if (servers.size() <= index) throw new RuntimeException("Can't edit servers. Index exceeds size.");
    return setNewServerLike(index, buildServer(index));
  }
  public MavenBuildSpecFluent.ServersNested<A> editFirstServer() {
    if (servers.size() == 0) throw new RuntimeException("Can't edit first servers. The list is empty.");
    return setNewServerLike(0, buildServer(0));
  }
  public MavenBuildSpecFluent.ServersNested<A> editLastServer() {
    int index = servers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last servers. The list is empty.");
    return setNewServerLike(index, buildServer(index));
  }
  public MavenBuildSpecFluent.ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<servers.size();i++) { 
    if (predicate.test(servers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching servers. No match found.");
    return setNewServerLike(index, buildServer(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSettings instead.
   * @return The buildable object.
   */
  @Deprecated
  public ValueSource getSettings() {
    return this.settings!=null ?this.settings.build():null;
  }
  public ValueSource buildSettings() {
    return this.settings!=null ?this.settings.build():null;
  }
  public A withSettings(ValueSource settings) {
    _visitables.get("settings").remove(this.settings);
    if (settings!=null){ this.settings= new ValueSourceBuilder(settings); _visitables.get("settings").add(this.settings);} else { this.settings = null; _visitables.get("settings").remove(this.settings); } return (A) this;
  }
  public Boolean hasSettings() {
    return this.settings != null;
  }
  public MavenBuildSpecFluent.SettingsNested<A> withNewSettings() {
    return new MavenBuildSpecFluentImpl.SettingsNestedImpl();
  }
  public MavenBuildSpecFluent.SettingsNested<A> withNewSettingsLike(ValueSource item) {
    return new MavenBuildSpecFluentImpl.SettingsNestedImpl(item);
  }
  public MavenBuildSpecFluent.SettingsNested<A> editSettings() {
    return withNewSettingsLike(getSettings());
  }
  public MavenBuildSpecFluent.SettingsNested<A> editOrNewSettings() {
    return withNewSettingsLike(getSettings() != null ? getSettings(): new ValueSourceBuilder().build());
  }
  public MavenBuildSpecFluent.SettingsNested<A> editOrNewSettingsLike(ValueSource item) {
    return withNewSettingsLike(getSettings() != null ? getSettings(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MavenBuildSpecFluentImpl that = (MavenBuildSpecFluentImpl) o;
    if (caSecret != null ? !caSecret.equals(that.caSecret) :that.caSecret != null) return false;
    if (caSecrets != null ? !caSecrets.equals(that.caSecrets) :that.caSecrets != null) return false;
    if (cliOptions != null ? !cliOptions.equals(that.cliOptions) :that.cliOptions != null) return false;
    if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
    if (localRepository != null ? !localRepository.equals(that.localRepository) :that.localRepository != null) return false;
    if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
    if (repositories != null ? !repositories.equals(that.repositories) :that.repositories != null) return false;
    if (servers != null ? !servers.equals(that.servers) :that.servers != null) return false;
    if (settings != null ? !settings.equals(that.settings) :that.settings != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(caSecret,  caSecrets,  cliOptions,  extension,  localRepository,  properties,  repositories,  servers,  settings,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caSecret != null) { sb.append("caSecret:"); sb.append(caSecret + ","); }
    if (caSecrets != null && !caSecrets.isEmpty()) { sb.append("caSecrets:"); sb.append(caSecrets + ","); }
    if (cliOptions != null && !cliOptions.isEmpty()) { sb.append("cliOptions:"); sb.append(cliOptions + ","); }
    if (extension != null && !extension.isEmpty()) { sb.append("extension:"); sb.append(extension + ","); }
    if (localRepository != null) { sb.append("localRepository:"); sb.append(localRepository + ","); }
    if (properties != null && !properties.isEmpty()) { sb.append("properties:"); sb.append(properties + ","); }
    if (repositories != null && !repositories.isEmpty()) { sb.append("repositories:"); sb.append(repositories + ","); }
    if (servers != null && !servers.isEmpty()) { sb.append("servers:"); sb.append(servers + ","); }
    if (settings != null) { sb.append("settings:"); sb.append(settings); }
    sb.append("}");
    return sb.toString();
  }
  class ExtensionNestedImpl<N> extends MavenArtifactFluentImpl<MavenBuildSpecFluent.ExtensionNested<N>> implements MavenBuildSpecFluent.ExtensionNested<N>,Nested<N>{
    ExtensionNestedImpl(Integer index,MavenArtifact item) {
      this.index = index;
      this.builder = new MavenArtifactBuilder(this, item);
    }
    ExtensionNestedImpl() {
      this.index = -1;
      this.builder = new MavenArtifactBuilder(this);
    }
    MavenArtifactBuilder builder;
    Integer index;
    public N and() {
      return (N) MavenBuildSpecFluentImpl.this.setToExtension(index,builder.build());
    }
    public N endExtension() {
      return and();
    }
    
  }
  class RepositoriesNestedImpl<N> extends RepositoryFluentImpl<MavenBuildSpecFluent.RepositoriesNested<N>> implements MavenBuildSpecFluent.RepositoriesNested<N>,Nested<N>{
    RepositoriesNestedImpl(Integer index,Repository item) {
      this.index = index;
      this.builder = new RepositoryBuilder(this, item);
    }
    RepositoriesNestedImpl() {
      this.index = -1;
      this.builder = new RepositoryBuilder(this);
    }
    RepositoryBuilder builder;
    Integer index;
    public N and() {
      return (N) MavenBuildSpecFluentImpl.this.setToRepositories(index,builder.build());
    }
    public N endRepository() {
      return and();
    }
    
  }
  class ServersNestedImpl<N> extends ServerFluentImpl<MavenBuildSpecFluent.ServersNested<N>> implements MavenBuildSpecFluent.ServersNested<N>,Nested<N>{
    ServersNestedImpl(Integer index,Server item) {
      this.index = index;
      this.builder = new ServerBuilder(this, item);
    }
    ServersNestedImpl() {
      this.index = -1;
      this.builder = new ServerBuilder(this);
    }
    ServerBuilder builder;
    Integer index;
    public N and() {
      return (N) MavenBuildSpecFluentImpl.this.setToServers(index,builder.build());
    }
    public N endServer() {
      return and();
    }
    
  }
  class SettingsNestedImpl<N> extends ValueSourceFluentImpl<MavenBuildSpecFluent.SettingsNested<N>> implements MavenBuildSpecFluent.SettingsNested<N>,Nested<N>{
    SettingsNestedImpl(ValueSource item) {
      this.builder = new ValueSourceBuilder(this, item);
    }
    SettingsNestedImpl() {
      this.builder = new ValueSourceBuilder(this);
    }
    ValueSourceBuilder builder;
    public N and() {
      return (N) MavenBuildSpecFluentImpl.this.withSettings(builder.build());
    }
    public N endSettings() {
      return and();
    }
    
  }
  
}