package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuilderTaskFluentImpl<A extends BuilderTaskFluent<A>> extends BaseFluent<A> implements BuilderTaskFluent<A>{
  public BuilderTaskFluentImpl() {
  }
  public BuilderTaskFluentImpl(BuilderTask instance) {
    this.withBaseImage(instance.getBaseImage()); 
    this.withBuildDir(instance.getBuildDir()); 
    this.withDependencies(instance.getDependencies()); 
    this.withMaven(instance.getMaven()); 
    this.withName(instance.getName()); 
    this.withResources(instance.getResources()); 
    this.withRuntime(instance.getRuntime()); 
    this.withSources(instance.getSources()); 
    this.withSteps(instance.getSteps()); 
  }
  private String baseImage;
  private String buildDir;
  private List<String> dependencies = new ArrayList<String>();
  private MavenBuildSpecBuilder maven;
  private String name;
  private ArrayList<ResourceSpecBuilder> resources = new ArrayList<ResourceSpecBuilder>();
  private RuntimeSpecBuilder runtime;
  private ArrayList<SourceSpecBuilder> sources = new ArrayList<SourceSpecBuilder>();
  private List<String> steps = new ArrayList<String>();
  public String getBaseImage() {
    return this.baseImage;
  }
  public A withBaseImage(String baseImage) {
    this.baseImage=baseImage; return (A) this;
  }
  public Boolean hasBaseImage() {
    return this.baseImage != null;
  }
  public String getBuildDir() {
    return this.buildDir;
  }
  public A withBuildDir(String buildDir) {
    this.buildDir=buildDir; return (A) this;
  }
  public Boolean hasBuildDir() {
    return this.buildDir != null;
  }
  public A addToDependencies(Integer index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.add(index, item);
    return (A)this;
  }
  public A setToDependencies(Integer index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.set(index, item); return (A)this;
  }
  public A addToDependencies(java.lang.String... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A addAllToDependencies(Collection<String> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A removeFromDependencies(java.lang.String... items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<String> items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public List<String> getDependencies() {
    return this.dependencies;
  }
  public String getDependency(Integer index) {
    return this.dependencies.get(index);
  }
  public String getFirstDependency() {
    return this.dependencies.get(0);
  }
  public String getLastDependency() {
    return this.dependencies.get(dependencies.size() - 1);
  }
  public String getMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(List<String> dependencies) {
    if (dependencies != null) {this.dependencies = new ArrayList(); for (String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(java.lang.String... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (String item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildMaven instead.
   * @return The buildable object.
   */
  @Deprecated
  public MavenBuildSpec getMaven() {
    return this.maven!=null ?this.maven.build():null;
  }
  public MavenBuildSpec buildMaven() {
    return this.maven!=null ?this.maven.build():null;
  }
  public A withMaven(MavenBuildSpec maven) {
    _visitables.get("maven").remove(this.maven);
    if (maven!=null){ this.maven= new MavenBuildSpecBuilder(maven); _visitables.get("maven").add(this.maven);} else { this.maven = null; _visitables.get("maven").remove(this.maven); } return (A) this;
  }
  public Boolean hasMaven() {
    return this.maven != null;
  }
  public BuilderTaskFluent.MavenNested<A> withNewMaven() {
    return new BuilderTaskFluentImpl.MavenNestedImpl();
  }
  public BuilderTaskFluent.MavenNested<A> withNewMavenLike(MavenBuildSpec item) {
    return new BuilderTaskFluentImpl.MavenNestedImpl(item);
  }
  public BuilderTaskFluent.MavenNested<A> editMaven() {
    return withNewMavenLike(getMaven());
  }
  public BuilderTaskFluent.MavenNested<A> editOrNewMaven() {
    return withNewMavenLike(getMaven() != null ? getMaven(): new MavenBuildSpecBuilder().build());
  }
  public BuilderTaskFluent.MavenNested<A> editOrNewMavenLike(MavenBuildSpec item) {
    return withNewMavenLike(getMaven() != null ? getMaven(): item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToResources(Integer index,ResourceSpec item) {
    if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
    ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
  }
  public A setToResources(Integer index,ResourceSpec item) {
    if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
    ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
    if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
     return (A)this;
  }
  public A addToResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A addAllToResources(Collection<ResourceSpec> items) {
    if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A removeFromResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeAllFromResources(Collection<ResourceSpec> items) {
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResources(Predicate<ResourceSpecBuilder> predicate) {
    if (resources == null) return (A) this;
    final Iterator<ResourceSpecBuilder> each = resources.iterator();
    final List visitables = _visitables.get("resources");
    while (each.hasNext()) {
      ResourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceSpec> getResources() {
    return resources != null ? build(resources) : null;
  }
  public List<ResourceSpec> buildResources() {
    return resources != null ? build(resources) : null;
  }
  public ResourceSpec buildResource(Integer index) {
    return this.resources.get(index).build();
  }
  public ResourceSpec buildFirstResource() {
    return this.resources.get(0).build();
  }
  public ResourceSpec buildLastResource() {
    return this.resources.get(resources.size() - 1).build();
  }
  public ResourceSpec buildMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
    for (ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
    for (ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(List<ResourceSpec> resources) {
    if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
    if (resources != null) {this.resources = new ArrayList(); for (ResourceSpec item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(io.fabric8.camelk.v1.ResourceSpec... resources) {
    if (this.resources != null) {this.resources.clear();}
    if (resources != null) {for (ResourceSpec item :resources){ this.addToResources(item);}} return (A) this;
  }
  public Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public BuilderTaskFluent.ResourcesNested<A> addNewResource() {
    return new BuilderTaskFluentImpl.ResourcesNestedImpl();
  }
  public BuilderTaskFluent.ResourcesNested<A> addNewResourceLike(ResourceSpec item) {
    return new BuilderTaskFluentImpl.ResourcesNestedImpl(-1, item);
  }
  public BuilderTaskFluent.ResourcesNested<A> setNewResourceLike(Integer index,ResourceSpec item) {
    return new BuilderTaskFluentImpl.ResourcesNestedImpl(index, item);
  }
  public BuilderTaskFluent.ResourcesNested<A> editResource(Integer index) {
    if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
    return setNewResourceLike(index, buildResource(index));
  }
  public BuilderTaskFluent.ResourcesNested<A> editFirstResource() {
    if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
    return setNewResourceLike(0, buildResource(0));
  }
  public BuilderTaskFluent.ResourcesNested<A> editLastResource() {
    int index = resources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
    return setNewResourceLike(index, buildResource(index));
  }
  public BuilderTaskFluent.ResourcesNested<A> editMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resources.size();i++) { 
    if (predicate.test(resources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
    return setNewResourceLike(index, buildResource(index));
  }
  
  /**
   * This method has been deprecated, please use method buildRuntime instead.
   * @return The buildable object.
   */
  @Deprecated
  public RuntimeSpec getRuntime() {
    return this.runtime!=null ?this.runtime.build():null;
  }
  public RuntimeSpec buildRuntime() {
    return this.runtime!=null ?this.runtime.build():null;
  }
  public A withRuntime(RuntimeSpec runtime) {
    _visitables.get("runtime").remove(this.runtime);
    if (runtime!=null){ this.runtime= new RuntimeSpecBuilder(runtime); _visitables.get("runtime").add(this.runtime);} else { this.runtime = null; _visitables.get("runtime").remove(this.runtime); } return (A) this;
  }
  public Boolean hasRuntime() {
    return this.runtime != null;
  }
  public BuilderTaskFluent.RuntimeNested<A> withNewRuntime() {
    return new BuilderTaskFluentImpl.RuntimeNestedImpl();
  }
  public BuilderTaskFluent.RuntimeNested<A> withNewRuntimeLike(RuntimeSpec item) {
    return new BuilderTaskFluentImpl.RuntimeNestedImpl(item);
  }
  public BuilderTaskFluent.RuntimeNested<A> editRuntime() {
    return withNewRuntimeLike(getRuntime());
  }
  public BuilderTaskFluent.RuntimeNested<A> editOrNewRuntime() {
    return withNewRuntimeLike(getRuntime() != null ? getRuntime(): new RuntimeSpecBuilder().build());
  }
  public BuilderTaskFluent.RuntimeNested<A> editOrNewRuntimeLike(RuntimeSpec item) {
    return withNewRuntimeLike(getRuntime() != null ? getRuntime(): item);
  }
  public A addToSources(Integer index,SourceSpec item) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
    SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").add(index >= 0 ? index : _visitables.get("sources").size(), builder);this.sources.add(index >= 0 ? index : sources.size(), builder); return (A)this;
  }
  public A setToSources(Integer index,SourceSpec item) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
    SourceSpecBuilder builder = new SourceSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("sources").size()) { _visitables.get("sources").add(builder); } else { _visitables.get("sources").set(index, builder);}
    if (index < 0 || index >= sources.size()) { sources.add(builder); } else { sources.set(index, builder);}
     return (A)this;
  }
  public A addToSources(io.fabric8.camelk.v1.SourceSpec... items) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A addAllToSources(Collection<SourceSpec> items) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A removeFromSources(io.fabric8.camelk.v1.SourceSpec... items) {
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeAllFromSources(Collection<SourceSpec> items) {
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSources(Predicate<SourceSpecBuilder> predicate) {
    if (sources == null) return (A) this;
    final Iterator<SourceSpecBuilder> each = sources.iterator();
    final List visitables = _visitables.get("sources");
    while (each.hasNext()) {
      SourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SourceSpec> getSources() {
    return sources != null ? build(sources) : null;
  }
  public List<SourceSpec> buildSources() {
    return sources != null ? build(sources) : null;
  }
  public SourceSpec buildSource(Integer index) {
    return this.sources.get(index).build();
  }
  public SourceSpec buildFirstSource() {
    return this.sources.get(0).build();
  }
  public SourceSpec buildLastSource() {
    return this.sources.get(sources.size() - 1).build();
  }
  public SourceSpec buildMatchingSource(Predicate<SourceSpecBuilder> predicate) {
    for (SourceSpecBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSource(Predicate<SourceSpecBuilder> predicate) {
    for (SourceSpecBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSources(List<SourceSpec> sources) {
    if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
    if (sources != null) {this.sources = new ArrayList(); for (SourceSpec item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
  }
  public A withSources(io.fabric8.camelk.v1.SourceSpec... sources) {
    if (this.sources != null) {this.sources.clear();}
    if (sources != null) {for (SourceSpec item :sources){ this.addToSources(item);}} return (A) this;
  }
  public Boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public BuilderTaskFluent.SourcesNested<A> addNewSource() {
    return new BuilderTaskFluentImpl.SourcesNestedImpl();
  }
  public BuilderTaskFluent.SourcesNested<A> addNewSourceLike(SourceSpec item) {
    return new BuilderTaskFluentImpl.SourcesNestedImpl(-1, item);
  }
  public BuilderTaskFluent.SourcesNested<A> setNewSourceLike(Integer index,SourceSpec item) {
    return new BuilderTaskFluentImpl.SourcesNestedImpl(index, item);
  }
  public BuilderTaskFluent.SourcesNested<A> editSource(Integer index) {
    if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
    return setNewSourceLike(index, buildSource(index));
  }
  public BuilderTaskFluent.SourcesNested<A> editFirstSource() {
    if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
    return setNewSourceLike(0, buildSource(0));
  }
  public BuilderTaskFluent.SourcesNested<A> editLastSource() {
    int index = sources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
    return setNewSourceLike(index, buildSource(index));
  }
  public BuilderTaskFluent.SourcesNested<A> editMatchingSource(Predicate<SourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sources.size();i++) { 
    if (predicate.test(sources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
    return setNewSourceLike(index, buildSource(index));
  }
  public A addToSteps(Integer index,String item) {
    if (this.steps == null) {this.steps = new ArrayList<String>();}
    this.steps.add(index, item);
    return (A)this;
  }
  public A setToSteps(Integer index,String item) {
    if (this.steps == null) {this.steps = new ArrayList<String>();}
    this.steps.set(index, item); return (A)this;
  }
  public A addToSteps(java.lang.String... items) {
    if (this.steps == null) {this.steps = new ArrayList<String>();}
    for (String item : items) {this.steps.add(item);} return (A)this;
  }
  public A addAllToSteps(Collection<String> items) {
    if (this.steps == null) {this.steps = new ArrayList<String>();}
    for (String item : items) {this.steps.add(item);} return (A)this;
  }
  public A removeFromSteps(java.lang.String... items) {
    for (String item : items) {if (this.steps!= null){ this.steps.remove(item);}} return (A)this;
  }
  public A removeAllFromSteps(Collection<String> items) {
    for (String item : items) {if (this.steps!= null){ this.steps.remove(item);}} return (A)this;
  }
  public List<String> getSteps() {
    return this.steps;
  }
  public String getStep(Integer index) {
    return this.steps.get(index);
  }
  public String getFirstStep() {
    return this.steps.get(0);
  }
  public String getLastStep() {
    return this.steps.get(steps.size() - 1);
  }
  public String getMatchingStep(Predicate<String> predicate) {
    for (String item: steps) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingStep(Predicate<String> predicate) {
    for (String item: steps) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSteps(List<String> steps) {
    if (steps != null) {this.steps = new ArrayList(); for (String item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
  }
  public A withSteps(java.lang.String... steps) {
    if (this.steps != null) {this.steps.clear();}
    if (steps != null) {for (String item :steps){ this.addToSteps(item);}} return (A) this;
  }
  public Boolean hasSteps() {
    return steps != null && !steps.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BuilderTaskFluentImpl that = (BuilderTaskFluentImpl) o;
    if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
    if (buildDir != null ? !buildDir.equals(that.buildDir) :that.buildDir != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (maven != null ? !maven.equals(that.maven) :that.maven != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (runtime != null ? !runtime.equals(that.runtime) :that.runtime != null) return false;
    if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
    if (steps != null ? !steps.equals(that.steps) :that.steps != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(baseImage,  buildDir,  dependencies,  maven,  name,  resources,  runtime,  sources,  steps,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseImage != null) { sb.append("baseImage:"); sb.append(baseImage + ","); }
    if (buildDir != null) { sb.append("buildDir:"); sb.append(buildDir + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (maven != null) { sb.append("maven:"); sb.append(maven + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (runtime != null) { sb.append("runtime:"); sb.append(runtime + ","); }
    if (sources != null && !sources.isEmpty()) { sb.append("sources:"); sb.append(sources + ","); }
    if (steps != null && !steps.isEmpty()) { sb.append("steps:"); sb.append(steps); }
    sb.append("}");
    return sb.toString();
  }
  class MavenNestedImpl<N> extends MavenBuildSpecFluentImpl<BuilderTaskFluent.MavenNested<N>> implements BuilderTaskFluent.MavenNested<N>,Nested<N>{
    MavenNestedImpl(MavenBuildSpec item) {
      this.builder = new MavenBuildSpecBuilder(this, item);
    }
    MavenNestedImpl() {
      this.builder = new MavenBuildSpecBuilder(this);
    }
    MavenBuildSpecBuilder builder;
    public N and() {
      return (N) BuilderTaskFluentImpl.this.withMaven(builder.build());
    }
    public N endMaven() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceSpecFluentImpl<BuilderTaskFluent.ResourcesNested<N>> implements BuilderTaskFluent.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(Integer index,ResourceSpec item) {
      this.index = index;
      this.builder = new ResourceSpecBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.index = -1;
      this.builder = new ResourceSpecBuilder(this);
    }
    ResourceSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) BuilderTaskFluentImpl.this.setToResources(index,builder.build());
    }
    public N endResource() {
      return and();
    }
    
  }
  class RuntimeNestedImpl<N> extends RuntimeSpecFluentImpl<BuilderTaskFluent.RuntimeNested<N>> implements BuilderTaskFluent.RuntimeNested<N>,Nested<N>{
    RuntimeNestedImpl(RuntimeSpec item) {
      this.builder = new RuntimeSpecBuilder(this, item);
    }
    RuntimeNestedImpl() {
      this.builder = new RuntimeSpecBuilder(this);
    }
    RuntimeSpecBuilder builder;
    public N and() {
      return (N) BuilderTaskFluentImpl.this.withRuntime(builder.build());
    }
    public N endRuntime() {
      return and();
    }
    
  }
  class SourcesNestedImpl<N> extends SourceSpecFluentImpl<BuilderTaskFluent.SourcesNested<N>> implements BuilderTaskFluent.SourcesNested<N>,Nested<N>{
    SourcesNestedImpl(Integer index,SourceSpec item) {
      this.index = index;
      this.builder = new SourceSpecBuilder(this, item);
    }
    SourcesNestedImpl() {
      this.index = -1;
      this.builder = new SourceSpecBuilder(this);
    }
    SourceSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) BuilderTaskFluentImpl.this.setToSources(index,builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  
}