package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValueSourceBuilder extends ValueSourceFluentImpl<ValueSourceBuilder> implements VisitableBuilder<ValueSource,ValueSourceBuilder>{
  public ValueSourceBuilder() {
    this(false);
  }
  public ValueSourceBuilder(Boolean validationEnabled) {
    this(new ValueSource(), validationEnabled);
  }
  public ValueSourceBuilder(ValueSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ValueSourceBuilder(ValueSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValueSource(), validationEnabled);
  }
  public ValueSourceBuilder(ValueSourceFluent<?> fluent,ValueSource instance) {
    this(fluent, instance, false);
  }
  public ValueSourceBuilder(ValueSourceFluent<?> fluent,ValueSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
    fluent.withSecretKeyRef(instance.getSecretKeyRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public ValueSourceBuilder(ValueSource instance) {
    this(instance,false);
  }
  public ValueSourceBuilder(ValueSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
    this.withSecretKeyRef(instance.getSecretKeyRef()); 
    this.validationEnabled = validationEnabled; 
  }
  ValueSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ValueSource build() {
    ValueSource buildable = new ValueSource(fluent.getConfigMapKeyRef(),fluent.getSecretKeyRef());
    return buildable;
  }
  
}