package io.fabric8.camelk.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SourceSpecFluentImpl<A extends SourceSpecFluent<A>> extends BaseFluent<A> implements SourceSpecFluent<A>{
  public SourceSpecFluentImpl() {
  }
  public SourceSpecFluentImpl(SourceSpec instance) {
    this.withCompression(instance.getCompression()); 
    this.withContent(instance.getContent()); 
    this.withContentKey(instance.getContentKey()); 
    this.withContentRef(instance.getContentRef()); 
    this.withContentType(instance.getContentType()); 
    this.withInterceptors(instance.getInterceptors()); 
    this.withLanguage(instance.getLanguage()); 
    this.withLoader(instance.getLoader()); 
    this.withName(instance.getName()); 
    this.withPath(instance.getPath()); 
    this.withPropertyNames(instance.getPropertyNames()); 
    this.withRawContent(instance.getRawContent()); 
    this.withType(instance.getType()); 
  }
  private Boolean compression;
  private String content;
  private String contentKey;
  private String contentRef;
  private String contentType;
  private List<String> interceptors = new ArrayList<String>();
  private String language;
  private String loader;
  private String name;
  private String path;
  private List<String> propertyNames = new ArrayList<String>();
  private String rawContent;
  private String type;
  public Boolean getCompression() {
    return this.compression;
  }
  public A withCompression(Boolean compression) {
    this.compression=compression; return (A) this;
  }
  public Boolean hasCompression() {
    return this.compression != null;
  }
  public String getContent() {
    return this.content;
  }
  public A withContent(String content) {
    this.content=content; return (A) this;
  }
  public Boolean hasContent() {
    return this.content != null;
  }
  public String getContentKey() {
    return this.contentKey;
  }
  public A withContentKey(String contentKey) {
    this.contentKey=contentKey; return (A) this;
  }
  public Boolean hasContentKey() {
    return this.contentKey != null;
  }
  public String getContentRef() {
    return this.contentRef;
  }
  public A withContentRef(String contentRef) {
    this.contentRef=contentRef; return (A) this;
  }
  public Boolean hasContentRef() {
    return this.contentRef != null;
  }
  public String getContentType() {
    return this.contentType;
  }
  public A withContentType(String contentType) {
    this.contentType=contentType; return (A) this;
  }
  public Boolean hasContentType() {
    return this.contentType != null;
  }
  public A addToInterceptors(Integer index,String item) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<String>();}
    this.interceptors.add(index, item);
    return (A)this;
  }
  public A setToInterceptors(Integer index,String item) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<String>();}
    this.interceptors.set(index, item); return (A)this;
  }
  public A addToInterceptors(java.lang.String... items) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<String>();}
    for (String item : items) {this.interceptors.add(item);} return (A)this;
  }
  public A addAllToInterceptors(Collection<String> items) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<String>();}
    for (String item : items) {this.interceptors.add(item);} return (A)this;
  }
  public A removeFromInterceptors(java.lang.String... items) {
    for (String item : items) {if (this.interceptors!= null){ this.interceptors.remove(item);}} return (A)this;
  }
  public A removeAllFromInterceptors(Collection<String> items) {
    for (String item : items) {if (this.interceptors!= null){ this.interceptors.remove(item);}} return (A)this;
  }
  public List<String> getInterceptors() {
    return this.interceptors;
  }
  public String getInterceptor(Integer index) {
    return this.interceptors.get(index);
  }
  public String getFirstInterceptor() {
    return this.interceptors.get(0);
  }
  public String getLastInterceptor() {
    return this.interceptors.get(interceptors.size() - 1);
  }
  public String getMatchingInterceptor(Predicate<String> predicate) {
    for (String item: interceptors) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingInterceptor(Predicate<String> predicate) {
    for (String item: interceptors) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInterceptors(List<String> interceptors) {
    if (interceptors != null) {this.interceptors = new ArrayList(); for (String item : interceptors){this.addToInterceptors(item);}} else { this.interceptors = null;} return (A) this;
  }
  public A withInterceptors(java.lang.String... interceptors) {
    if (this.interceptors != null) {this.interceptors.clear();}
    if (interceptors != null) {for (String item :interceptors){ this.addToInterceptors(item);}} return (A) this;
  }
  public Boolean hasInterceptors() {
    return interceptors != null && !interceptors.isEmpty();
  }
  public String getLanguage() {
    return this.language;
  }
  public A withLanguage(String language) {
    this.language=language; return (A) this;
  }
  public Boolean hasLanguage() {
    return this.language != null;
  }
  public String getLoader() {
    return this.loader;
  }
  public A withLoader(String loader) {
    this.loader=loader; return (A) this;
  }
  public Boolean hasLoader() {
    return this.loader != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public A addToPropertyNames(Integer index,String item) {
    if (this.propertyNames == null) {this.propertyNames = new ArrayList<String>();}
    this.propertyNames.add(index, item);
    return (A)this;
  }
  public A setToPropertyNames(Integer index,String item) {
    if (this.propertyNames == null) {this.propertyNames = new ArrayList<String>();}
    this.propertyNames.set(index, item); return (A)this;
  }
  public A addToPropertyNames(java.lang.String... items) {
    if (this.propertyNames == null) {this.propertyNames = new ArrayList<String>();}
    for (String item : items) {this.propertyNames.add(item);} return (A)this;
  }
  public A addAllToPropertyNames(Collection<String> items) {
    if (this.propertyNames == null) {this.propertyNames = new ArrayList<String>();}
    for (String item : items) {this.propertyNames.add(item);} return (A)this;
  }
  public A removeFromPropertyNames(java.lang.String... items) {
    for (String item : items) {if (this.propertyNames!= null){ this.propertyNames.remove(item);}} return (A)this;
  }
  public A removeAllFromPropertyNames(Collection<String> items) {
    for (String item : items) {if (this.propertyNames!= null){ this.propertyNames.remove(item);}} return (A)this;
  }
  public List<String> getPropertyNames() {
    return this.propertyNames;
  }
  public String getPropertyName(Integer index) {
    return this.propertyNames.get(index);
  }
  public String getFirstPropertyName() {
    return this.propertyNames.get(0);
  }
  public String getLastPropertyName() {
    return this.propertyNames.get(propertyNames.size() - 1);
  }
  public String getMatchingPropertyName(Predicate<String> predicate) {
    for (String item: propertyNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPropertyName(Predicate<String> predicate) {
    for (String item: propertyNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPropertyNames(List<String> propertyNames) {
    if (propertyNames != null) {this.propertyNames = new ArrayList(); for (String item : propertyNames){this.addToPropertyNames(item);}} else { this.propertyNames = null;} return (A) this;
  }
  public A withPropertyNames(java.lang.String... propertyNames) {
    if (this.propertyNames != null) {this.propertyNames.clear();}
    if (propertyNames != null) {for (String item :propertyNames){ this.addToPropertyNames(item);}} return (A) this;
  }
  public Boolean hasPropertyNames() {
    return propertyNames != null && !propertyNames.isEmpty();
  }
  public String getRawContent() {
    return this.rawContent;
  }
  public A withRawContent(String rawContent) {
    this.rawContent=rawContent; return (A) this;
  }
  public Boolean hasRawContent() {
    return this.rawContent != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SourceSpecFluentImpl that = (SourceSpecFluentImpl) o;
    if (compression != null ? !compression.equals(that.compression) :that.compression != null) return false;
    if (content != null ? !content.equals(that.content) :that.content != null) return false;
    if (contentKey != null ? !contentKey.equals(that.contentKey) :that.contentKey != null) return false;
    if (contentRef != null ? !contentRef.equals(that.contentRef) :that.contentRef != null) return false;
    if (contentType != null ? !contentType.equals(that.contentType) :that.contentType != null) return false;
    if (interceptors != null ? !interceptors.equals(that.interceptors) :that.interceptors != null) return false;
    if (language != null ? !language.equals(that.language) :that.language != null) return false;
    if (loader != null ? !loader.equals(that.loader) :that.loader != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (propertyNames != null ? !propertyNames.equals(that.propertyNames) :that.propertyNames != null) return false;
    if (rawContent != null ? !rawContent.equals(that.rawContent) :that.rawContent != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(compression,  content,  contentKey,  contentRef,  contentType,  interceptors,  language,  loader,  name,  path,  propertyNames,  rawContent,  type,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (compression != null) { sb.append("compression:"); sb.append(compression + ","); }
    if (content != null) { sb.append("content:"); sb.append(content + ","); }
    if (contentKey != null) { sb.append("contentKey:"); sb.append(contentKey + ","); }
    if (contentRef != null) { sb.append("contentRef:"); sb.append(contentRef + ","); }
    if (contentType != null) { sb.append("contentType:"); sb.append(contentType + ","); }
    if (interceptors != null && !interceptors.isEmpty()) { sb.append("interceptors:"); sb.append(interceptors + ","); }
    if (language != null) { sb.append("language:"); sb.append(language + ","); }
    if (loader != null) { sb.append("loader:"); sb.append(loader + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (propertyNames != null && !propertyNames.isEmpty()) { sb.append("propertyNames:"); sb.append(propertyNames + ","); }
    if (rawContent != null) { sb.append("rawContent:"); sb.append(rawContent + ","); }
    if (type != null) { sb.append("type:"); sb.append(type); }
    sb.append("}");
    return sb.toString();
  }
  public A withCompression() {
    return withCompression(true);
  }
  
}