package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuntimeSpecBuilder extends RuntimeSpecFluentImpl<RuntimeSpecBuilder> implements VisitableBuilder<RuntimeSpec,RuntimeSpecBuilder>{
  public RuntimeSpecBuilder() {
    this(false);
  }
  public RuntimeSpecBuilder(Boolean validationEnabled) {
    this(new RuntimeSpec(), validationEnabled);
  }
  public RuntimeSpecBuilder(RuntimeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RuntimeSpecBuilder(RuntimeSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RuntimeSpec(), validationEnabled);
  }
  public RuntimeSpecBuilder(RuntimeSpecFluent<?> fluent,RuntimeSpec instance) {
    this(fluent, instance, false);
  }
  public RuntimeSpecBuilder(RuntimeSpecFluent<?> fluent,RuntimeSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApplicationClass(instance.getApplicationClass()); 
    fluent.withCapabilities(instance.getCapabilities()); 
    fluent.withDependencies(instance.getDependencies()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withProvider(instance.getProvider()); 
    fluent.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  public RuntimeSpecBuilder(RuntimeSpec instance) {
    this(instance,false);
  }
  public RuntimeSpecBuilder(RuntimeSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApplicationClass(instance.getApplicationClass()); 
    this.withCapabilities(instance.getCapabilities()); 
    this.withDependencies(instance.getDependencies()); 
    this.withMetadata(instance.getMetadata()); 
    this.withProvider(instance.getProvider()); 
    this.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  RuntimeSpecFluent<?> fluent;
  Boolean validationEnabled;
  public RuntimeSpec build() {
    RuntimeSpec buildable = new RuntimeSpec(fluent.getApplicationClass(),fluent.getCapabilities(),fluent.getDependencies(),fluent.getMetadata(),fluent.getProvider(),fluent.getVersion());
    return buildable;
  }
  
}