package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MavenSpecBuilder extends MavenSpecFluentImpl<MavenSpecBuilder> implements VisitableBuilder<MavenSpec,MavenSpecBuilder>{
  public MavenSpecBuilder() {
    this(false);
  }
  public MavenSpecBuilder(Boolean validationEnabled) {
    this(new MavenSpec(), validationEnabled);
  }
  public MavenSpecBuilder(MavenSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MavenSpecBuilder(MavenSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MavenSpec(), validationEnabled);
  }
  public MavenSpecBuilder(MavenSpecFluent<?> fluent,MavenSpec instance) {
    this(fluent, instance, false);
  }
  public MavenSpecBuilder(MavenSpecFluent<?> fluent,MavenSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCaSecret(instance.getCaSecret()); 
    fluent.withCaSecrets(instance.getCaSecrets()); 
    fluent.withCliOptions(instance.getCliOptions()); 
    fluent.withExtension(instance.getExtension()); 
    fluent.withLocalRepository(instance.getLocalRepository()); 
    fluent.withProperties(instance.getProperties()); 
    fluent.withSettings(instance.getSettings()); 
    this.validationEnabled = validationEnabled; 
  }
  public MavenSpecBuilder(MavenSpec instance) {
    this(instance,false);
  }
  public MavenSpecBuilder(MavenSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCaSecret(instance.getCaSecret()); 
    this.withCaSecrets(instance.getCaSecrets()); 
    this.withCliOptions(instance.getCliOptions()); 
    this.withExtension(instance.getExtension()); 
    this.withLocalRepository(instance.getLocalRepository()); 
    this.withProperties(instance.getProperties()); 
    this.withSettings(instance.getSettings()); 
    this.validationEnabled = validationEnabled; 
  }
  MavenSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MavenSpec build() {
    MavenSpec buildable = new MavenSpec(fluent.getCaSecret(),fluent.getCaSecrets(),fluent.getCliOptions(),fluent.getExtension(),fluent.getLocalRepository(),fluent.getProperties(),fluent.getSettings());
    return buildable;
  }
  
}