package io.fabric8.camelk.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IntegrationKitFluentImpl<A extends IntegrationKitFluent<A>> extends BaseFluent<A> implements IntegrationKitFluent<A>{
  public IntegrationKitFluentImpl() {
  }
  public IntegrationKitFluentImpl(IntegrationKit instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private IntegrationKitSpecBuilder spec;
  private IntegrationKitStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public IntegrationKitFluent.MetadataNested<A> withNewMetadata() {
    return new IntegrationKitFluentImpl.MetadataNestedImpl();
  }
  public IntegrationKitFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new IntegrationKitFluentImpl.MetadataNestedImpl(item);
  }
  public IntegrationKitFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public IntegrationKitFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public IntegrationKitFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntegrationKitSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public IntegrationKitSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(IntegrationKitSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new IntegrationKitSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public IntegrationKitFluent.SpecNested<A> withNewSpec() {
    return new IntegrationKitFluentImpl.SpecNestedImpl();
  }
  public IntegrationKitFluent.SpecNested<A> withNewSpecLike(IntegrationKitSpec item) {
    return new IntegrationKitFluentImpl.SpecNestedImpl(item);
  }
  public IntegrationKitFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public IntegrationKitFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new IntegrationKitSpecBuilder().build());
  }
  public IntegrationKitFluent.SpecNested<A> editOrNewSpecLike(IntegrationKitSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntegrationKitStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public IntegrationKitStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(IntegrationKitStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new IntegrationKitStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public IntegrationKitFluent.StatusNested<A> withNewStatus() {
    return new IntegrationKitFluentImpl.StatusNestedImpl();
  }
  public IntegrationKitFluent.StatusNested<A> withNewStatusLike(IntegrationKitStatus item) {
    return new IntegrationKitFluentImpl.StatusNestedImpl(item);
  }
  public IntegrationKitFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public IntegrationKitFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new IntegrationKitStatusBuilder().build());
  }
  public IntegrationKitFluent.StatusNested<A> editOrNewStatusLike(IntegrationKitStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IntegrationKitFluentImpl that = (IntegrationKitFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<IntegrationKitFluent.MetadataNested<N>> implements IntegrationKitFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) IntegrationKitFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends IntegrationKitSpecFluentImpl<IntegrationKitFluent.SpecNested<N>> implements IntegrationKitFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(IntegrationKitSpec item) {
      this.builder = new IntegrationKitSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new IntegrationKitSpecBuilder(this);
    }
    IntegrationKitSpecBuilder builder;
    public N and() {
      return (N) IntegrationKitFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends IntegrationKitStatusFluentImpl<IntegrationKitFluent.StatusNested<N>> implements IntegrationKitFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(IntegrationKitStatus item) {
      this.builder = new IntegrationKitStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new IntegrationKitStatusBuilder(this);
    }
    IntegrationKitStatusBuilder builder;
    public N and() {
      return (N) IntegrationKitFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}