package io.fabric8.camelk.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ValueSourceFluentImpl<A extends ValueSourceFluent<A>> extends BaseFluent<A> implements ValueSourceFluent<A>{
  public ValueSourceFluentImpl() {
  }
  public ValueSourceFluentImpl(ValueSource instance) {
    this.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
    this.withSecretKeyRef(instance.getSecretKeyRef()); 
  }
  private ConfigMapKeySelector configMapKeyRef;
  private SecretKeySelector secretKeyRef;
  public ConfigMapKeySelector getConfigMapKeyRef() {
    return this.configMapKeyRef;
  }
  public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef) {
    this.configMapKeyRef=configMapKeyRef; return (A) this;
  }
  public Boolean hasConfigMapKeyRef() {
    return this.configMapKeyRef != null;
  }
  public A withNewConfigMapKeyRef(String key,String name,Boolean optional) {
    return (A)withConfigMapKeyRef(new ConfigMapKeySelector(key, name, optional));
  }
  public SecretKeySelector getSecretKeyRef() {
    return this.secretKeyRef;
  }
  public A withSecretKeyRef(SecretKeySelector secretKeyRef) {
    this.secretKeyRef=secretKeyRef; return (A) this;
  }
  public Boolean hasSecretKeyRef() {
    return this.secretKeyRef != null;
  }
  public A withNewSecretKeyRef(String key,String name,Boolean optional) {
    return (A)withSecretKeyRef(new SecretKeySelector(key, name, optional));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValueSourceFluentImpl that = (ValueSourceFluentImpl) o;
    if (configMapKeyRef != null ? !configMapKeyRef.equals(that.configMapKeyRef) :that.configMapKeyRef != null) return false;
    if (secretKeyRef != null ? !secretKeyRef.equals(that.secretKeyRef) :that.secretKeyRef != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configMapKeyRef,  secretKeyRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMapKeyRef != null) { sb.append("configMapKeyRef:"); sb.append(configMapKeyRef + ","); }
    if (secretKeyRef != null) { sb.append("secretKeyRef:"); sb.append(secretKeyRef); }
    sb.append("}");
    return sb.toString();
  }
  
}