package io.fabric8.camelk.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RepositoryFluentImpl<A extends RepositoryFluent<A>> extends BaseFluent<A> implements RepositoryFluent<A>{
  public RepositoryFluentImpl() {
  }
  public RepositoryFluentImpl(Repository instance) {
    this.withId(instance.getId()); 
    this.withName(instance.getName()); 
    this.withReleases(instance.getReleases()); 
    this.withSnapshots(instance.getSnapshots()); 
    this.withUrl(instance.getUrl()); 
  }
  private String id;
  private String name;
  private RepositoryPolicyBuilder releases;
  private RepositoryPolicyBuilder snapshots;
  private String url;
  public String getId() {
    return this.id;
  }
  public A withId(String id) {
    this.id=id; return (A) this;
  }
  public Boolean hasId() {
    return this.id != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildReleases instead.
   * @return The buildable object.
   */
  @Deprecated
  public RepositoryPolicy getReleases() {
    return this.releases!=null ?this.releases.build():null;
  }
  public RepositoryPolicy buildReleases() {
    return this.releases!=null ?this.releases.build():null;
  }
  public A withReleases(RepositoryPolicy releases) {
    _visitables.get("releases").remove(this.releases);
    if (releases!=null){ this.releases= new RepositoryPolicyBuilder(releases); _visitables.get("releases").add(this.releases);} else { this.releases = null; _visitables.get("releases").remove(this.releases); } return (A) this;
  }
  public Boolean hasReleases() {
    return this.releases != null;
  }
  public A withNewReleases(String checksumPolicy,Boolean enabled,String updatePolicy) {
    return (A)withReleases(new RepositoryPolicy(checksumPolicy, enabled, updatePolicy));
  }
  public RepositoryFluent.ReleasesNested<A> withNewReleases() {
    return new RepositoryFluentImpl.ReleasesNestedImpl();
  }
  public RepositoryFluent.ReleasesNested<A> withNewReleasesLike(RepositoryPolicy item) {
    return new RepositoryFluentImpl.ReleasesNestedImpl(item);
  }
  public RepositoryFluent.ReleasesNested<A> editReleases() {
    return withNewReleasesLike(getReleases());
  }
  public RepositoryFluent.ReleasesNested<A> editOrNewReleases() {
    return withNewReleasesLike(getReleases() != null ? getReleases(): new RepositoryPolicyBuilder().build());
  }
  public RepositoryFluent.ReleasesNested<A> editOrNewReleasesLike(RepositoryPolicy item) {
    return withNewReleasesLike(getReleases() != null ? getReleases(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSnapshots instead.
   * @return The buildable object.
   */
  @Deprecated
  public RepositoryPolicy getSnapshots() {
    return this.snapshots!=null ?this.snapshots.build():null;
  }
  public RepositoryPolicy buildSnapshots() {
    return this.snapshots!=null ?this.snapshots.build():null;
  }
  public A withSnapshots(RepositoryPolicy snapshots) {
    _visitables.get("snapshots").remove(this.snapshots);
    if (snapshots!=null){ this.snapshots= new RepositoryPolicyBuilder(snapshots); _visitables.get("snapshots").add(this.snapshots);} else { this.snapshots = null; _visitables.get("snapshots").remove(this.snapshots); } return (A) this;
  }
  public Boolean hasSnapshots() {
    return this.snapshots != null;
  }
  public A withNewSnapshots(String checksumPolicy,Boolean enabled,String updatePolicy) {
    return (A)withSnapshots(new RepositoryPolicy(checksumPolicy, enabled, updatePolicy));
  }
  public RepositoryFluent.SnapshotsNested<A> withNewSnapshots() {
    return new RepositoryFluentImpl.SnapshotsNestedImpl();
  }
  public RepositoryFluent.SnapshotsNested<A> withNewSnapshotsLike(RepositoryPolicy item) {
    return new RepositoryFluentImpl.SnapshotsNestedImpl(item);
  }
  public RepositoryFluent.SnapshotsNested<A> editSnapshots() {
    return withNewSnapshotsLike(getSnapshots());
  }
  public RepositoryFluent.SnapshotsNested<A> editOrNewSnapshots() {
    return withNewSnapshotsLike(getSnapshots() != null ? getSnapshots(): new RepositoryPolicyBuilder().build());
  }
  public RepositoryFluent.SnapshotsNested<A> editOrNewSnapshotsLike(RepositoryPolicy item) {
    return withNewSnapshotsLike(getSnapshots() != null ? getSnapshots(): item);
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RepositoryFluentImpl that = (RepositoryFluentImpl) o;
    if (id != null ? !id.equals(that.id) :that.id != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (releases != null ? !releases.equals(that.releases) :that.releases != null) return false;
    if (snapshots != null ? !snapshots.equals(that.snapshots) :that.snapshots != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(id,  name,  releases,  snapshots,  url,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (releases != null) { sb.append("releases:"); sb.append(releases + ","); }
    if (snapshots != null) { sb.append("snapshots:"); sb.append(snapshots + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  class ReleasesNestedImpl<N> extends RepositoryPolicyFluentImpl<RepositoryFluent.ReleasesNested<N>> implements RepositoryFluent.ReleasesNested<N>,Nested<N>{
    ReleasesNestedImpl(RepositoryPolicy item) {
      this.builder = new RepositoryPolicyBuilder(this, item);
    }
    ReleasesNestedImpl() {
      this.builder = new RepositoryPolicyBuilder(this);
    }
    RepositoryPolicyBuilder builder;
    public N and() {
      return (N) RepositoryFluentImpl.this.withReleases(builder.build());
    }
    public N endReleases() {
      return and();
    }
    
  }
  class SnapshotsNestedImpl<N> extends RepositoryPolicyFluentImpl<RepositoryFluent.SnapshotsNested<N>> implements RepositoryFluent.SnapshotsNested<N>,Nested<N>{
    SnapshotsNestedImpl(RepositoryPolicy item) {
      this.builder = new RepositoryPolicyBuilder(this, item);
    }
    SnapshotsNestedImpl() {
      this.builder = new RepositoryPolicyBuilder(this);
    }
    RepositoryPolicyBuilder builder;
    public N and() {
      return (N) RepositoryFluentImpl.this.withSnapshots(builder.build());
    }
    public N endSnapshots() {
      return and();
    }
    
  }
  
}