package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.Volume;
import java.lang.Long;
import java.util.Collection;
import java.util.Map;

 /**
  * Generated
  */
public interface PodSpecFluent<A extends PodSpecFluent<A>> extends Fluent<A>{
  public Long getActiveDeadlineSeconds();
  public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
  public Boolean hasActiveDeadlineSeconds();
  public A addToContainers(Integer index,Container item);
  public A setToContainers(Integer index,Container item);
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToContainers(Collection<Container> items);
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromContainers(Collection<Container> items);
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getContainers();
  public List<Container> buildContainers();
  public Container buildContainer(Integer index);
  public Container buildFirstContainer();
  public Container buildLastContainer();
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate);
  public A withContainers(List<Container> containers);
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers);
  public Boolean hasContainers();
  public PodSpecFluent.ContainersNested<A> addNewContainer();
  public PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item);
  public PodSpecFluent.ContainersNested<A> setNewContainerLike(Integer index,Container item);
  public PodSpecFluent.ContainersNested<A> editContainer(Integer index);
  public PodSpecFluent.ContainersNested<A> editFirstContainer();
  public PodSpecFluent.ContainersNested<A> editLastContainer();
  public PodSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate);
  public String getDnsPolicy();
  public A withDnsPolicy(String dnsPolicy);
  public Boolean hasDnsPolicy();
  public A addToEphemeralContainers(Integer index,EphemeralContainer item);
  public A setToEphemeralContainers(Integer index,EphemeralContainer item);
  public A addToEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items);
  public A addAllToEphemeralContainers(Collection<EphemeralContainer> items);
  public A removeFromEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items);
  public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items);
  public List<EphemeralContainer> getEphemeralContainers();
  public EphemeralContainer getEphemeralContainer(Integer index);
  public EphemeralContainer getFirstEphemeralContainer();
  public EphemeralContainer getLastEphemeralContainer();
  public EphemeralContainer getMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate);
  public Boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate);
  public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers);
  public A withEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... ephemeralContainers);
  public Boolean hasEphemeralContainers();
  public A addToInitContainers(Integer index,Container item);
  public A setToInitContainers(Integer index,Container item);
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToInitContainers(Collection<Container> items);
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromInitContainers(Collection<Container> items);
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getInitContainers();
  public List<Container> buildInitContainers();
  public Container buildInitContainer(Integer index);
  public Container buildFirstInitContainer();
  public Container buildLastInitContainer();
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public A withInitContainers(List<Container> initContainers);
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers);
  public Boolean hasInitContainers();
  public PodSpecFluent.InitContainersNested<A> addNewInitContainer();
  public PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item);
  public PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(Integer index,Container item);
  public PodSpecFluent.InitContainersNested<A> editInitContainer(Integer index);
  public PodSpecFluent.InitContainersNested<A> editFirstInitContainer();
  public PodSpecFluent.InitContainersNested<A> editLastInitContainer();
  public PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public A addToNodeSelector(String key,String value);
  public A addToNodeSelector(Map<String,String> map);
  public A removeFromNodeSelector(String key);
  public A removeFromNodeSelector(Map<String,String> map);
  public Map<String,String> getNodeSelector();
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector);
  public Boolean hasNodeSelector();
  public String getRestartPolicy();
  public A withRestartPolicy(String restartPolicy);
  public Boolean hasRestartPolicy();
  public Long getTerminationGracePeriodSeconds();
  public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds);
  public Boolean hasTerminationGracePeriodSeconds();
  public A addToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item);
  public A setToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item);
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public List<TopologySpreadConstraint> getTopologySpreadConstraints();
  public TopologySpreadConstraint getTopologySpreadConstraint(Integer index);
  public TopologySpreadConstraint getFirstTopologySpreadConstraint();
  public TopologySpreadConstraint getLastTopologySpreadConstraint();
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate);
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate);
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints);
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints);
  public Boolean hasTopologySpreadConstraints();
  public A addToVolumes(Integer index,Volume item);
  public A setToVolumes(Integer index,Volume item);
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A addAllToVolumes(Collection<Volume> items);
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A removeAllFromVolumes(Collection<Volume> items);
  public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Volume> getVolumes();
  public List<Volume> buildVolumes();
  public Volume buildVolume(Integer index);
  public Volume buildFirstVolume();
  public Volume buildLastVolume();
  public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate);
  public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate);
  public A withVolumes(List<Volume> volumes);
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes);
  public Boolean hasVolumes();
  public PodSpecFluent.VolumesNested<A> addNewVolume();
  public PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item);
  public PodSpecFluent.VolumesNested<A> setNewVolumeLike(Integer index,Volume item);
  public PodSpecFluent.VolumesNested<A> editVolume(Integer index);
  public PodSpecFluent.VolumesNested<A> editFirstVolume();
  public PodSpecFluent.VolumesNested<A> editLastVolume();
  public PodSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate);
  public interface ContainersNested<N> extends Nested<N>,ContainerFluent<PodSpecFluent.ContainersNested<N>>{
    public N and();
    public N endContainer();
    
  }
  public interface InitContainersNested<N> extends Nested<N>,ContainerFluent<PodSpecFluent.InitContainersNested<N>>{
    public N and();
    public N endInitContainer();
    
  }
  public interface VolumesNested<N> extends Nested<N>,VolumeFluent<PodSpecFluent.VolumesNested<N>>{
    public N and();
    public N endVolume();
    
  }
  
}