package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IntegrationStatusFluentImpl<A extends IntegrationStatusFluent<A>> extends BaseFluent<A> implements IntegrationStatusFluent<A>{
  public IntegrationStatusFluentImpl() {
  }
  public IntegrationStatusFluentImpl(IntegrationStatus instance) {
    this.withCapabilities(instance.getCapabilities()); 
    this.withConditions(instance.getConditions()); 
    this.withConfiguration(instance.getConfiguration()); 
    this.withDependencies(instance.getDependencies()); 
    this.withDigest(instance.getDigest()); 
    this.withGeneratedResources(instance.getGeneratedResources()); 
    this.withGeneratedSources(instance.getGeneratedSources()); 
    this.withImage(instance.getImage()); 
    this.withIntegrationKit(instance.getIntegrationKit()); 
    this.withLastInitTimestamp(instance.getLastInitTimestamp()); 
    this.withPhase(instance.getPhase()); 
    this.withPlatform(instance.getPlatform()); 
    this.withProfile(instance.getProfile()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRuntimeProvider(instance.getRuntimeProvider()); 
    this.withRuntimeVersion(instance.getRuntimeVersion()); 
    this.withSelector(instance.getSelector()); 
    this.withVersion(instance.getVersion()); 
  }
  private List<String> capabilities = new ArrayList<String>();
  private ArrayList<IntegrationConditionBuilder> conditions = new ArrayList<IntegrationConditionBuilder>();
  private ArrayList<ConfigurationSpecBuilder> configuration = new ArrayList<ConfigurationSpecBuilder>();
  private List<String> dependencies = new ArrayList<String>();
  private String digest;
  private ArrayList<ResourceSpecBuilder> generatedResources = new ArrayList<ResourceSpecBuilder>();
  private ArrayList<SourceSpecBuilder> generatedSources = new ArrayList<SourceSpecBuilder>();
  private String image;
  private ObjectReferenceBuilder integrationKit;
  private String lastInitTimestamp;
  private String phase;
  private String platform;
  private String profile;
  private Integer replicas;
  private String runtimeProvider;
  private String runtimeVersion;
  private String selector;
  private String version;
  public A addToCapabilities(Integer index,String item) {
    if (this.capabilities == null) {this.capabilities = new ArrayList<String>();}
    this.capabilities.add(index, item);
    return (A)this;
  }
  public A setToCapabilities(Integer index,String item) {
    if (this.capabilities == null) {this.capabilities = new ArrayList<String>();}
    this.capabilities.set(index, item); return (A)this;
  }
  public A addToCapabilities(java.lang.String... items) {
    if (this.capabilities == null) {this.capabilities = new ArrayList<String>();}
    for (String item : items) {this.capabilities.add(item);} return (A)this;
  }
  public A addAllToCapabilities(Collection<String> items) {
    if (this.capabilities == null) {this.capabilities = new ArrayList<String>();}
    for (String item : items) {this.capabilities.add(item);} return (A)this;
  }
  public A removeFromCapabilities(java.lang.String... items) {
    for (String item : items) {if (this.capabilities!= null){ this.capabilities.remove(item);}} return (A)this;
  }
  public A removeAllFromCapabilities(Collection<String> items) {
    for (String item : items) {if (this.capabilities!= null){ this.capabilities.remove(item);}} return (A)this;
  }
  public List<String> getCapabilities() {
    return this.capabilities;
  }
  public String getCapability(Integer index) {
    return this.capabilities.get(index);
  }
  public String getFirstCapability() {
    return this.capabilities.get(0);
  }
  public String getLastCapability() {
    return this.capabilities.get(capabilities.size() - 1);
  }
  public String getMatchingCapability(Predicate<String> predicate) {
    for (String item: capabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCapability(Predicate<String> predicate) {
    for (String item: capabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCapabilities(List<String> capabilities) {
    if (capabilities != null) {this.capabilities = new ArrayList(); for (String item : capabilities){this.addToCapabilities(item);}} else { this.capabilities = null;} return (A) this;
  }
  public A withCapabilities(java.lang.String... capabilities) {
    if (this.capabilities != null) {this.capabilities.clear();}
    if (capabilities != null) {for (String item :capabilities){ this.addToCapabilities(item);}} return (A) this;
  }
  public Boolean hasCapabilities() {
    return capabilities != null && !capabilities.isEmpty();
  }
  public A addToConditions(Integer index,IntegrationCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationConditionBuilder>();}
    IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,IntegrationCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationConditionBuilder>();}
    IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.camelk.v1.IntegrationCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationConditionBuilder>();}
    for (IntegrationCondition item : items) {IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<IntegrationCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationConditionBuilder>();}
    for (IntegrationCondition item : items) {IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.camelk.v1.IntegrationCondition... items) {
    for (IntegrationCondition item : items) {IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<IntegrationCondition> items) {
    for (IntegrationCondition item : items) {IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<IntegrationConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<IntegrationConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      IntegrationConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IntegrationCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<IntegrationCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public IntegrationCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public IntegrationCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public IntegrationCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public IntegrationCondition buildMatchingCondition(Predicate<IntegrationConditionBuilder> predicate) {
    for (IntegrationConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<IntegrationConditionBuilder> predicate) {
    for (IntegrationConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<IntegrationCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (IntegrationCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.camelk.v1.IntegrationCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (IntegrationCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public IntegrationStatusFluent.ConditionsNested<A> addNewCondition() {
    return new IntegrationStatusFluentImpl.ConditionsNestedImpl();
  }
  public IntegrationStatusFluent.ConditionsNested<A> addNewConditionLike(IntegrationCondition item) {
    return new IntegrationStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public IntegrationStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,IntegrationCondition item) {
    return new IntegrationStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public IntegrationStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public IntegrationStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public IntegrationStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public IntegrationStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IntegrationConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToConfiguration(Integer index,ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(index >= 0 ? index : _visitables.get("configuration").size(), builder);this.configuration.add(index >= 0 ? index : configuration.size(), builder); return (A)this;
  }
  public A setToConfiguration(Integer index,ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("configuration").size()) { _visitables.get("configuration").add(builder); } else { _visitables.get("configuration").set(index, builder);}
    if (index < 0 || index >= configuration.size()) { configuration.add(builder); } else { configuration.set(index, builder);}
     return (A)this;
  }
  public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    if (configuration == null) return (A) this;
    final Iterator<ConfigurationSpecBuilder> each = configuration.iterator();
    final List visitables = _visitables.get("configuration");
    while (each.hasNext()) {
      ConfigurationSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConfigurationSpec> getConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public List<ConfigurationSpec> buildConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public ConfigurationSpec buildConfiguration(Integer index) {
    return this.configuration.get(index).build();
  }
  public ConfigurationSpec buildFirstConfiguration() {
    return this.configuration.get(0).build();
  }
  public ConfigurationSpec buildLastConfiguration() {
    return this.configuration.get(configuration.size() - 1).build();
  }
  public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfiguration(List<ConfigurationSpec> configuration) {
    if (this.configuration != null) { _visitables.get("configuration").removeAll(this.configuration);}
    if (configuration != null) {this.configuration = new ArrayList(); for (ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
  }
  public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration) {
    if (this.configuration != null) {this.configuration.clear();}
    if (configuration != null) {for (ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
  }
  public Boolean hasConfiguration() {
    return configuration != null && !configuration.isEmpty();
  }
  public A addNewConfiguration(String resourceKey,String resourceMountPoint,String resourceType,String type,String value) {
    return (A)addToConfiguration(new ConfigurationSpec(resourceKey, resourceMountPoint, resourceType, type, value));
  }
  public IntegrationStatusFluent.ConfigurationNested<A> addNewConfiguration() {
    return new IntegrationStatusFluentImpl.ConfigurationNestedImpl();
  }
  public IntegrationStatusFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
    return new IntegrationStatusFluentImpl.ConfigurationNestedImpl(-1, item);
  }
  public IntegrationStatusFluent.ConfigurationNested<A> setNewConfigurationLike(Integer index,ConfigurationSpec item) {
    return new IntegrationStatusFluentImpl.ConfigurationNestedImpl(index, item);
  }
  public IntegrationStatusFluent.ConfigurationNested<A> editConfiguration(Integer index) {
    if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public IntegrationStatusFluent.ConfigurationNested<A> editFirstConfiguration() {
    if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
    return setNewConfigurationLike(0, buildConfiguration(0));
  }
  public IntegrationStatusFluent.ConfigurationNested<A> editLastConfiguration() {
    int index = configuration.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public IntegrationStatusFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configuration.size();i++) { 
    if (predicate.test(configuration.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public A addToDependencies(Integer index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.add(index, item);
    return (A)this;
  }
  public A setToDependencies(Integer index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.set(index, item); return (A)this;
  }
  public A addToDependencies(java.lang.String... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A addAllToDependencies(Collection<String> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A removeFromDependencies(java.lang.String... items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<String> items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public List<String> getDependencies() {
    return this.dependencies;
  }
  public String getDependency(Integer index) {
    return this.dependencies.get(index);
  }
  public String getFirstDependency() {
    return this.dependencies.get(0);
  }
  public String getLastDependency() {
    return this.dependencies.get(dependencies.size() - 1);
  }
  public String getMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(List<String> dependencies) {
    if (dependencies != null) {this.dependencies = new ArrayList(); for (String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(java.lang.String... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (String item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public String getDigest() {
    return this.digest;
  }
  public A withDigest(String digest) {
    this.digest=digest; return (A) this;
  }
  public Boolean hasDigest() {
    return this.digest != null;
  }
  public A addToGeneratedResources(Integer index,ResourceSpec item) {
    if (this.generatedResources == null) {this.generatedResources = new ArrayList<ResourceSpecBuilder>();}
    ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("generatedResources").add(index >= 0 ? index : _visitables.get("generatedResources").size(), builder);this.generatedResources.add(index >= 0 ? index : generatedResources.size(), builder); return (A)this;
  }
  public A setToGeneratedResources(Integer index,ResourceSpec item) {
    if (this.generatedResources == null) {this.generatedResources = new ArrayList<ResourceSpecBuilder>();}
    ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("generatedResources").size()) { _visitables.get("generatedResources").add(builder); } else { _visitables.get("generatedResources").set(index, builder);}
    if (index < 0 || index >= generatedResources.size()) { generatedResources.add(builder); } else { generatedResources.set(index, builder);}
     return (A)this;
  }
  public A addToGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    if (this.generatedResources == null) {this.generatedResources = new ArrayList<ResourceSpecBuilder>();}
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("generatedResources").add(builder);this.generatedResources.add(builder);} return (A)this;
  }
  public A addAllToGeneratedResources(Collection<ResourceSpec> items) {
    if (this.generatedResources == null) {this.generatedResources = new ArrayList<ResourceSpecBuilder>();}
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("generatedResources").add(builder);this.generatedResources.add(builder);} return (A)this;
  }
  public A removeFromGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("generatedResources").remove(builder);if (this.generatedResources != null) {this.generatedResources.remove(builder);}} return (A)this;
  }
  public A removeAllFromGeneratedResources(Collection<ResourceSpec> items) {
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("generatedResources").remove(builder);if (this.generatedResources != null) {this.generatedResources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGeneratedResources(Predicate<ResourceSpecBuilder> predicate) {
    if (generatedResources == null) return (A) this;
    final Iterator<ResourceSpecBuilder> each = generatedResources.iterator();
    final List visitables = _visitables.get("generatedResources");
    while (each.hasNext()) {
      ResourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildGeneratedResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceSpec> getGeneratedResources() {
    return generatedResources != null ? build(generatedResources) : null;
  }
  public List<ResourceSpec> buildGeneratedResources() {
    return generatedResources != null ? build(generatedResources) : null;
  }
  public ResourceSpec buildGeneratedResource(Integer index) {
    return this.generatedResources.get(index).build();
  }
  public ResourceSpec buildFirstGeneratedResource() {
    return this.generatedResources.get(0).build();
  }
  public ResourceSpec buildLastGeneratedResource() {
    return this.generatedResources.get(generatedResources.size() - 1).build();
  }
  public ResourceSpec buildMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate) {
    for (ResourceSpecBuilder item: generatedResources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate) {
    for (ResourceSpecBuilder item: generatedResources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGeneratedResources(List<ResourceSpec> generatedResources) {
    if (this.generatedResources != null) { _visitables.get("generatedResources").removeAll(this.generatedResources);}
    if (generatedResources != null) {this.generatedResources = new ArrayList(); for (ResourceSpec item : generatedResources){this.addToGeneratedResources(item);}} else { this.generatedResources = null;} return (A) this;
  }
  public A withGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... generatedResources) {
    if (this.generatedResources != null) {this.generatedResources.clear();}
    if (generatedResources != null) {for (ResourceSpec item :generatedResources){ this.addToGeneratedResources(item);}} return (A) this;
  }
  public Boolean hasGeneratedResources() {
    return generatedResources != null && !generatedResources.isEmpty();
  }
  public IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResource() {
    return new IntegrationStatusFluentImpl.GeneratedResourcesNestedImpl();
  }
  public IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResourceLike(ResourceSpec item) {
    return new IntegrationStatusFluentImpl.GeneratedResourcesNestedImpl(-1, item);
  }
  public IntegrationStatusFluent.GeneratedResourcesNested<A> setNewGeneratedResourceLike(Integer index,ResourceSpec item) {
    return new IntegrationStatusFluentImpl.GeneratedResourcesNestedImpl(index, item);
  }
  public IntegrationStatusFluent.GeneratedResourcesNested<A> editGeneratedResource(Integer index) {
    if (generatedResources.size() <= index) throw new RuntimeException("Can't edit generatedResources. Index exceeds size.");
    return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
  }
  public IntegrationStatusFluent.GeneratedResourcesNested<A> editFirstGeneratedResource() {
    if (generatedResources.size() == 0) throw new RuntimeException("Can't edit first generatedResources. The list is empty.");
    return setNewGeneratedResourceLike(0, buildGeneratedResource(0));
  }
  public IntegrationStatusFluent.GeneratedResourcesNested<A> editLastGeneratedResource() {
    int index = generatedResources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last generatedResources. The list is empty.");
    return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
  }
  public IntegrationStatusFluent.GeneratedResourcesNested<A> editMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<generatedResources.size();i++) { 
    if (predicate.test(generatedResources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching generatedResources. No match found.");
    return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
  }
  public A addToGeneratedSources(Integer index,SourceSpec item) {
    if (this.generatedSources == null) {this.generatedSources = new ArrayList<SourceSpecBuilder>();}
    SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("generatedSources").add(index >= 0 ? index : _visitables.get("generatedSources").size(), builder);this.generatedSources.add(index >= 0 ? index : generatedSources.size(), builder); return (A)this;
  }
  public A setToGeneratedSources(Integer index,SourceSpec item) {
    if (this.generatedSources == null) {this.generatedSources = new ArrayList<SourceSpecBuilder>();}
    SourceSpecBuilder builder = new SourceSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("generatedSources").size()) { _visitables.get("generatedSources").add(builder); } else { _visitables.get("generatedSources").set(index, builder);}
    if (index < 0 || index >= generatedSources.size()) { generatedSources.add(builder); } else { generatedSources.set(index, builder);}
     return (A)this;
  }
  public A addToGeneratedSources(io.fabric8.camelk.v1.SourceSpec... items) {
    if (this.generatedSources == null) {this.generatedSources = new ArrayList<SourceSpecBuilder>();}
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("generatedSources").add(builder);this.generatedSources.add(builder);} return (A)this;
  }
  public A addAllToGeneratedSources(Collection<SourceSpec> items) {
    if (this.generatedSources == null) {this.generatedSources = new ArrayList<SourceSpecBuilder>();}
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("generatedSources").add(builder);this.generatedSources.add(builder);} return (A)this;
  }
  public A removeFromGeneratedSources(io.fabric8.camelk.v1.SourceSpec... items) {
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("generatedSources").remove(builder);if (this.generatedSources != null) {this.generatedSources.remove(builder);}} return (A)this;
  }
  public A removeAllFromGeneratedSources(Collection<SourceSpec> items) {
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("generatedSources").remove(builder);if (this.generatedSources != null) {this.generatedSources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGeneratedSources(Predicate<SourceSpecBuilder> predicate) {
    if (generatedSources == null) return (A) this;
    final Iterator<SourceSpecBuilder> each = generatedSources.iterator();
    final List visitables = _visitables.get("generatedSources");
    while (each.hasNext()) {
      SourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildGeneratedSources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SourceSpec> getGeneratedSources() {
    return generatedSources != null ? build(generatedSources) : null;
  }
  public List<SourceSpec> buildGeneratedSources() {
    return generatedSources != null ? build(generatedSources) : null;
  }
  public SourceSpec buildGeneratedSource(Integer index) {
    return this.generatedSources.get(index).build();
  }
  public SourceSpec buildFirstGeneratedSource() {
    return this.generatedSources.get(0).build();
  }
  public SourceSpec buildLastGeneratedSource() {
    return this.generatedSources.get(generatedSources.size() - 1).build();
  }
  public SourceSpec buildMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate) {
    for (SourceSpecBuilder item: generatedSources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate) {
    for (SourceSpecBuilder item: generatedSources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGeneratedSources(List<SourceSpec> generatedSources) {
    if (this.generatedSources != null) { _visitables.get("generatedSources").removeAll(this.generatedSources);}
    if (generatedSources != null) {this.generatedSources = new ArrayList(); for (SourceSpec item : generatedSources){this.addToGeneratedSources(item);}} else { this.generatedSources = null;} return (A) this;
  }
  public A withGeneratedSources(io.fabric8.camelk.v1.SourceSpec... generatedSources) {
    if (this.generatedSources != null) {this.generatedSources.clear();}
    if (generatedSources != null) {for (SourceSpec item :generatedSources){ this.addToGeneratedSources(item);}} return (A) this;
  }
  public Boolean hasGeneratedSources() {
    return generatedSources != null && !generatedSources.isEmpty();
  }
  public IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSource() {
    return new IntegrationStatusFluentImpl.GeneratedSourcesNestedImpl();
  }
  public IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSourceLike(SourceSpec item) {
    return new IntegrationStatusFluentImpl.GeneratedSourcesNestedImpl(-1, item);
  }
  public IntegrationStatusFluent.GeneratedSourcesNested<A> setNewGeneratedSourceLike(Integer index,SourceSpec item) {
    return new IntegrationStatusFluentImpl.GeneratedSourcesNestedImpl(index, item);
  }
  public IntegrationStatusFluent.GeneratedSourcesNested<A> editGeneratedSource(Integer index) {
    if (generatedSources.size() <= index) throw new RuntimeException("Can't edit generatedSources. Index exceeds size.");
    return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
  }
  public IntegrationStatusFluent.GeneratedSourcesNested<A> editFirstGeneratedSource() {
    if (generatedSources.size() == 0) throw new RuntimeException("Can't edit first generatedSources. The list is empty.");
    return setNewGeneratedSourceLike(0, buildGeneratedSource(0));
  }
  public IntegrationStatusFluent.GeneratedSourcesNested<A> editLastGeneratedSource() {
    int index = generatedSources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last generatedSources. The list is empty.");
    return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
  }
  public IntegrationStatusFluent.GeneratedSourcesNested<A> editMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<generatedSources.size();i++) { 
    if (predicate.test(generatedSources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching generatedSources. No match found.");
    return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIntegrationKit instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIntegrationKit() {
    return this.integrationKit!=null ?this.integrationKit.build():null;
  }
  public ObjectReference buildIntegrationKit() {
    return this.integrationKit!=null ?this.integrationKit.build():null;
  }
  public A withIntegrationKit(ObjectReference integrationKit) {
    _visitables.get("integrationKit").remove(this.integrationKit);
    if (integrationKit!=null){ this.integrationKit= new ObjectReferenceBuilder(integrationKit); _visitables.get("integrationKit").add(this.integrationKit);} else { this.integrationKit = null; _visitables.get("integrationKit").remove(this.integrationKit); } return (A) this;
  }
  public Boolean hasIntegrationKit() {
    return this.integrationKit != null;
  }
  public IntegrationStatusFluent.IntegrationKitNested<A> withNewIntegrationKit() {
    return new IntegrationStatusFluentImpl.IntegrationKitNestedImpl();
  }
  public IntegrationStatusFluent.IntegrationKitNested<A> withNewIntegrationKitLike(ObjectReference item) {
    return new IntegrationStatusFluentImpl.IntegrationKitNestedImpl(item);
  }
  public IntegrationStatusFluent.IntegrationKitNested<A> editIntegrationKit() {
    return withNewIntegrationKitLike(getIntegrationKit());
  }
  public IntegrationStatusFluent.IntegrationKitNested<A> editOrNewIntegrationKit() {
    return withNewIntegrationKitLike(getIntegrationKit() != null ? getIntegrationKit(): new ObjectReferenceBuilder().build());
  }
  public IntegrationStatusFluent.IntegrationKitNested<A> editOrNewIntegrationKitLike(ObjectReference item) {
    return withNewIntegrationKitLike(getIntegrationKit() != null ? getIntegrationKit(): item);
  }
  public String getLastInitTimestamp() {
    return this.lastInitTimestamp;
  }
  public A withLastInitTimestamp(String lastInitTimestamp) {
    this.lastInitTimestamp=lastInitTimestamp; return (A) this;
  }
  public Boolean hasLastInitTimestamp() {
    return this.lastInitTimestamp != null;
  }
  public String getPhase() {
    return this.phase;
  }
  public A withPhase(String phase) {
    this.phase=phase; return (A) this;
  }
  public Boolean hasPhase() {
    return this.phase != null;
  }
  public String getPlatform() {
    return this.platform;
  }
  public A withPlatform(String platform) {
    this.platform=platform; return (A) this;
  }
  public Boolean hasPlatform() {
    return this.platform != null;
  }
  public String getProfile() {
    return this.profile;
  }
  public A withProfile(String profile) {
    this.profile=profile; return (A) this;
  }
  public Boolean hasProfile() {
    return this.profile != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public String getRuntimeProvider() {
    return this.runtimeProvider;
  }
  public A withRuntimeProvider(String runtimeProvider) {
    this.runtimeProvider=runtimeProvider; return (A) this;
  }
  public Boolean hasRuntimeProvider() {
    return this.runtimeProvider != null;
  }
  public String getRuntimeVersion() {
    return this.runtimeVersion;
  }
  public A withRuntimeVersion(String runtimeVersion) {
    this.runtimeVersion=runtimeVersion; return (A) this;
  }
  public Boolean hasRuntimeVersion() {
    return this.runtimeVersion != null;
  }
  public String getSelector() {
    return this.selector;
  }
  public A withSelector(String selector) {
    this.selector=selector; return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IntegrationStatusFluentImpl that = (IntegrationStatusFluentImpl) o;
    if (capabilities != null ? !capabilities.equals(that.capabilities) :that.capabilities != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (digest != null ? !digest.equals(that.digest) :that.digest != null) return false;
    if (generatedResources != null ? !generatedResources.equals(that.generatedResources) :that.generatedResources != null) return false;
    if (generatedSources != null ? !generatedSources.equals(that.generatedSources) :that.generatedSources != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (integrationKit != null ? !integrationKit.equals(that.integrationKit) :that.integrationKit != null) return false;
    if (lastInitTimestamp != null ? !lastInitTimestamp.equals(that.lastInitTimestamp) :that.lastInitTimestamp != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
    if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (runtimeProvider != null ? !runtimeProvider.equals(that.runtimeProvider) :that.runtimeProvider != null) return false;
    if (runtimeVersion != null ? !runtimeVersion.equals(that.runtimeVersion) :that.runtimeVersion != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(capabilities,  conditions,  configuration,  dependencies,  digest,  generatedResources,  generatedSources,  image,  integrationKit,  lastInitTimestamp,  phase,  platform,  profile,  replicas,  runtimeProvider,  runtimeVersion,  selector,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (capabilities != null && !capabilities.isEmpty()) { sb.append("capabilities:"); sb.append(capabilities + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (configuration != null && !configuration.isEmpty()) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (digest != null) { sb.append("digest:"); sb.append(digest + ","); }
    if (generatedResources != null && !generatedResources.isEmpty()) { sb.append("generatedResources:"); sb.append(generatedResources + ","); }
    if (generatedSources != null && !generatedSources.isEmpty()) { sb.append("generatedSources:"); sb.append(generatedSources + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (integrationKit != null) { sb.append("integrationKit:"); sb.append(integrationKit + ","); }
    if (lastInitTimestamp != null) { sb.append("lastInitTimestamp:"); sb.append(lastInitTimestamp + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (runtimeProvider != null) { sb.append("runtimeProvider:"); sb.append(runtimeProvider + ","); }
    if (runtimeVersion != null) { sb.append("runtimeVersion:"); sb.append(runtimeVersion + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends IntegrationConditionFluentImpl<IntegrationStatusFluent.ConditionsNested<N>> implements IntegrationStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,IntegrationCondition item) {
      this.index = index;
      this.builder = new IntegrationConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new IntegrationConditionBuilder(this);
    }
    IntegrationConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) IntegrationStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ConfigurationNestedImpl<N> extends ConfigurationSpecFluentImpl<IntegrationStatusFluent.ConfigurationNested<N>> implements IntegrationStatusFluent.ConfigurationNested<N>,Nested<N>{
    ConfigurationNestedImpl(Integer index,ConfigurationSpec item) {
      this.index = index;
      this.builder = new ConfigurationSpecBuilder(this, item);
    }
    ConfigurationNestedImpl() {
      this.index = -1;
      this.builder = new ConfigurationSpecBuilder(this);
    }
    ConfigurationSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) IntegrationStatusFluentImpl.this.setToConfiguration(index,builder.build());
    }
    public N endConfiguration() {
      return and();
    }
    
  }
  class GeneratedResourcesNestedImpl<N> extends ResourceSpecFluentImpl<IntegrationStatusFluent.GeneratedResourcesNested<N>> implements IntegrationStatusFluent.GeneratedResourcesNested<N>,Nested<N>{
    GeneratedResourcesNestedImpl(Integer index,ResourceSpec item) {
      this.index = index;
      this.builder = new ResourceSpecBuilder(this, item);
    }
    GeneratedResourcesNestedImpl() {
      this.index = -1;
      this.builder = new ResourceSpecBuilder(this);
    }
    ResourceSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) IntegrationStatusFluentImpl.this.setToGeneratedResources(index,builder.build());
    }
    public N endGeneratedResource() {
      return and();
    }
    
  }
  class GeneratedSourcesNestedImpl<N> extends SourceSpecFluentImpl<IntegrationStatusFluent.GeneratedSourcesNested<N>> implements IntegrationStatusFluent.GeneratedSourcesNested<N>,Nested<N>{
    GeneratedSourcesNestedImpl(Integer index,SourceSpec item) {
      this.index = index;
      this.builder = new SourceSpecBuilder(this, item);
    }
    GeneratedSourcesNestedImpl() {
      this.index = -1;
      this.builder = new SourceSpecBuilder(this);
    }
    SourceSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) IntegrationStatusFluentImpl.this.setToGeneratedSources(index,builder.build());
    }
    public N endGeneratedSource() {
      return and();
    }
    
  }
  class IntegrationKitNestedImpl<N> extends ObjectReferenceFluentImpl<IntegrationStatusFluent.IntegrationKitNested<N>> implements IntegrationStatusFluent.IntegrationKitNested<N>,Nested<N>{
    IntegrationKitNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    IntegrationKitNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) IntegrationStatusFluentImpl.this.withIntegrationKit(builder.build());
    }
    public N endIntegrationKit() {
      return and();
    }
    
  }
  
}