package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IntegrationKitSpecFluentImpl<A extends IntegrationKitSpecFluent<A>> extends BaseFluent<A> implements IntegrationKitSpecFluent<A>{
  public IntegrationKitSpecFluentImpl() {
  }
  public IntegrationKitSpecFluentImpl(IntegrationKitSpec instance) {
    this.withConfiguration(instance.getConfiguration()); 
    this.withDependencies(instance.getDependencies()); 
    this.withImage(instance.getImage()); 
    this.withProfile(instance.getProfile()); 
    this.withRepositories(instance.getRepositories()); 
    this.withTraits(instance.getTraits()); 
  }
  private ArrayList<ConfigurationSpecBuilder> configuration = new ArrayList<ConfigurationSpecBuilder>();
  private List<String> dependencies = new ArrayList<String>();
  private String image;
  private String profile;
  private List<String> repositories = new ArrayList<String>();
  private Map<String,TraitSpec> traits;
  public A addToConfiguration(Integer index,ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(index >= 0 ? index : _visitables.get("configuration").size(), builder);this.configuration.add(index >= 0 ? index : configuration.size(), builder); return (A)this;
  }
  public A setToConfiguration(Integer index,ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("configuration").size()) { _visitables.get("configuration").add(builder); } else { _visitables.get("configuration").set(index, builder);}
    if (index < 0 || index >= configuration.size()) { configuration.add(builder); } else { configuration.set(index, builder);}
     return (A)this;
  }
  public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    if (configuration == null) return (A) this;
    final Iterator<ConfigurationSpecBuilder> each = configuration.iterator();
    final List visitables = _visitables.get("configuration");
    while (each.hasNext()) {
      ConfigurationSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConfigurationSpec> getConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public List<ConfigurationSpec> buildConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public ConfigurationSpec buildConfiguration(Integer index) {
    return this.configuration.get(index).build();
  }
  public ConfigurationSpec buildFirstConfiguration() {
    return this.configuration.get(0).build();
  }
  public ConfigurationSpec buildLastConfiguration() {
    return this.configuration.get(configuration.size() - 1).build();
  }
  public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfiguration(List<ConfigurationSpec> configuration) {
    if (this.configuration != null) { _visitables.get("configuration").removeAll(this.configuration);}
    if (configuration != null) {this.configuration = new ArrayList(); for (ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
  }
  public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration) {
    if (this.configuration != null) {this.configuration.clear();}
    if (configuration != null) {for (ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
  }
  public Boolean hasConfiguration() {
    return configuration != null && !configuration.isEmpty();
  }
  public A addNewConfiguration(String resourceKey,String resourceMountPoint,String resourceType,String type,String value) {
    return (A)addToConfiguration(new ConfigurationSpec(resourceKey, resourceMountPoint, resourceType, type, value));
  }
  public IntegrationKitSpecFluent.ConfigurationNested<A> addNewConfiguration() {
    return new IntegrationKitSpecFluentImpl.ConfigurationNestedImpl();
  }
  public IntegrationKitSpecFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
    return new IntegrationKitSpecFluentImpl.ConfigurationNestedImpl(-1, item);
  }
  public IntegrationKitSpecFluent.ConfigurationNested<A> setNewConfigurationLike(Integer index,ConfigurationSpec item) {
    return new IntegrationKitSpecFluentImpl.ConfigurationNestedImpl(index, item);
  }
  public IntegrationKitSpecFluent.ConfigurationNested<A> editConfiguration(Integer index) {
    if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public IntegrationKitSpecFluent.ConfigurationNested<A> editFirstConfiguration() {
    if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
    return setNewConfigurationLike(0, buildConfiguration(0));
  }
  public IntegrationKitSpecFluent.ConfigurationNested<A> editLastConfiguration() {
    int index = configuration.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public IntegrationKitSpecFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configuration.size();i++) { 
    if (predicate.test(configuration.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public A addToDependencies(Integer index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.add(index, item);
    return (A)this;
  }
  public A setToDependencies(Integer index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.set(index, item); return (A)this;
  }
  public A addToDependencies(java.lang.String... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A addAllToDependencies(Collection<String> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A removeFromDependencies(java.lang.String... items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<String> items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public List<String> getDependencies() {
    return this.dependencies;
  }
  public String getDependency(Integer index) {
    return this.dependencies.get(index);
  }
  public String getFirstDependency() {
    return this.dependencies.get(0);
  }
  public String getLastDependency() {
    return this.dependencies.get(dependencies.size() - 1);
  }
  public String getMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(List<String> dependencies) {
    if (dependencies != null) {this.dependencies = new ArrayList(); for (String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(java.lang.String... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (String item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public String getProfile() {
    return this.profile;
  }
  public A withProfile(String profile) {
    this.profile=profile; return (A) this;
  }
  public Boolean hasProfile() {
    return this.profile != null;
  }
  public A addToRepositories(Integer index,String item) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    this.repositories.add(index, item);
    return (A)this;
  }
  public A setToRepositories(Integer index,String item) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    this.repositories.set(index, item); return (A)this;
  }
  public A addToRepositories(java.lang.String... items) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    for (String item : items) {this.repositories.add(item);} return (A)this;
  }
  public A addAllToRepositories(Collection<String> items) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    for (String item : items) {this.repositories.add(item);} return (A)this;
  }
  public A removeFromRepositories(java.lang.String... items) {
    for (String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
  }
  public A removeAllFromRepositories(Collection<String> items) {
    for (String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
  }
  public List<String> getRepositories() {
    return this.repositories;
  }
  public String getRepository(Integer index) {
    return this.repositories.get(index);
  }
  public String getFirstRepository() {
    return this.repositories.get(0);
  }
  public String getLastRepository() {
    return this.repositories.get(repositories.size() - 1);
  }
  public String getMatchingRepository(Predicate<String> predicate) {
    for (String item: repositories) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRepository(Predicate<String> predicate) {
    for (String item: repositories) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRepositories(List<String> repositories) {
    if (repositories != null) {this.repositories = new ArrayList(); for (String item : repositories){this.addToRepositories(item);}} else { this.repositories = null;} return (A) this;
  }
  public A withRepositories(java.lang.String... repositories) {
    if (this.repositories != null) {this.repositories.clear();}
    if (repositories != null) {for (String item :repositories){ this.addToRepositories(item);}} return (A) this;
  }
  public Boolean hasRepositories() {
    return repositories != null && !repositories.isEmpty();
  }
  public A addToTraits(String key,TraitSpec value) {
    if(this.traits == null && key != null && value != null) { this.traits = new LinkedHashMap(); }
    if(key != null && value != null) {this.traits.put(key, value);} return (A)this;
  }
  public A addToTraits(Map<String,TraitSpec> map) {
    if(this.traits == null && map != null) { this.traits = new LinkedHashMap(); }
    if(map != null) { this.traits.putAll(map);} return (A)this;
  }
  public A removeFromTraits(String key) {
    if(this.traits == null) { return (A) this; }
    if(key != null && this.traits != null) {this.traits.remove(key);} return (A)this;
  }
  public A removeFromTraits(Map<String,TraitSpec> map) {
    if(this.traits == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.traits != null){this.traits.remove(key);}}} return (A)this;
  }
  public Map<String,TraitSpec> getTraits() {
    return this.traits;
  }
  public <K,V>A withTraits(Map<String,TraitSpec> traits) {
    if (traits == null) { this.traits =  null;} else {this.traits = new LinkedHashMap(traits);} return (A) this;
  }
  public Boolean hasTraits() {
    return this.traits != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IntegrationKitSpecFluentImpl that = (IntegrationKitSpecFluentImpl) o;
    if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
    if (repositories != null ? !repositories.equals(that.repositories) :that.repositories != null) return false;
    if (traits != null ? !traits.equals(that.traits) :that.traits != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configuration,  dependencies,  image,  profile,  repositories,  traits,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configuration != null && !configuration.isEmpty()) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (repositories != null && !repositories.isEmpty()) { sb.append("repositories:"); sb.append(repositories + ","); }
    if (traits != null && !traits.isEmpty()) { sb.append("traits:"); sb.append(traits); }
    sb.append("}");
    return sb.toString();
  }
  class ConfigurationNestedImpl<N> extends ConfigurationSpecFluentImpl<IntegrationKitSpecFluent.ConfigurationNested<N>> implements IntegrationKitSpecFluent.ConfigurationNested<N>,Nested<N>{
    ConfigurationNestedImpl(Integer index,ConfigurationSpec item) {
      this.index = index;
      this.builder = new ConfigurationSpecBuilder(this, item);
    }
    ConfigurationNestedImpl() {
      this.index = -1;
      this.builder = new ConfigurationSpecBuilder(this);
    }
    ConfigurationSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) IntegrationKitSpecFluentImpl.this.setToConfiguration(index,builder.build());
    }
    public N endConfiguration() {
      return and();
    }
    
  }
  
}