package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CamelArtifactExclusionBuilder extends CamelArtifactExclusionFluentImpl<CamelArtifactExclusionBuilder> implements VisitableBuilder<CamelArtifactExclusion,CamelArtifactExclusionBuilder>{
  public CamelArtifactExclusionBuilder() {
    this(false);
  }
  public CamelArtifactExclusionBuilder(Boolean validationEnabled) {
    this(new CamelArtifactExclusion(), validationEnabled);
  }
  public CamelArtifactExclusionBuilder(CamelArtifactExclusionFluent<?> fluent) {
    this(fluent, false);
  }
  public CamelArtifactExclusionBuilder(CamelArtifactExclusionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CamelArtifactExclusion(), validationEnabled);
  }
  public CamelArtifactExclusionBuilder(CamelArtifactExclusionFluent<?> fluent,CamelArtifactExclusion instance) {
    this(fluent, instance, false);
  }
  public CamelArtifactExclusionBuilder(CamelArtifactExclusionFluent<?> fluent,CamelArtifactExclusion instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withArtifactId(instance.getArtifactId()); 
    fluent.withGroupId(instance.getGroupId()); 
    this.validationEnabled = validationEnabled; 
  }
  public CamelArtifactExclusionBuilder(CamelArtifactExclusion instance) {
    this(instance,false);
  }
  public CamelArtifactExclusionBuilder(CamelArtifactExclusion instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withArtifactId(instance.getArtifactId()); 
    this.withGroupId(instance.getGroupId()); 
    this.validationEnabled = validationEnabled; 
  }
  CamelArtifactExclusionFluent<?> fluent;
  Boolean validationEnabled;
  public CamelArtifactExclusion build() {
    CamelArtifactExclusion buildable = new CamelArtifactExclusion(fluent.getArtifactId(),fluent.getGroupId());
    return buildable;
  }
  
}