package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CamelArtifactBuilder extends CamelArtifactFluentImpl<CamelArtifactBuilder> implements VisitableBuilder<CamelArtifact,CamelArtifactBuilder>{
  public CamelArtifactBuilder() {
    this(false);
  }
  public CamelArtifactBuilder(Boolean validationEnabled) {
    this(new CamelArtifact(), validationEnabled);
  }
  public CamelArtifactBuilder(CamelArtifactFluent<?> fluent) {
    this(fluent, false);
  }
  public CamelArtifactBuilder(CamelArtifactFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CamelArtifact(), validationEnabled);
  }
  public CamelArtifactBuilder(CamelArtifactFluent<?> fluent,CamelArtifact instance) {
    this(fluent, instance, false);
  }
  public CamelArtifactBuilder(CamelArtifactFluent<?> fluent,CamelArtifact instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withArtifactId(instance.getArtifactId()); 
    fluent.withDataformats(instance.getDataformats()); 
    fluent.withDependencies(instance.getDependencies()); 
    fluent.withExclusions(instance.getExclusions()); 
    fluent.withGroupId(instance.getGroupId()); 
    fluent.withJavaTypes(instance.getJavaTypes()); 
    fluent.withLanguages(instance.getLanguages()); 
    fluent.withSchemes(instance.getSchemes()); 
    fluent.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  public CamelArtifactBuilder(CamelArtifact instance) {
    this(instance,false);
  }
  public CamelArtifactBuilder(CamelArtifact instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withArtifactId(instance.getArtifactId()); 
    this.withDataformats(instance.getDataformats()); 
    this.withDependencies(instance.getDependencies()); 
    this.withExclusions(instance.getExclusions()); 
    this.withGroupId(instance.getGroupId()); 
    this.withJavaTypes(instance.getJavaTypes()); 
    this.withLanguages(instance.getLanguages()); 
    this.withSchemes(instance.getSchemes()); 
    this.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  CamelArtifactFluent<?> fluent;
  Boolean validationEnabled;
  public CamelArtifact build() {
    CamelArtifact buildable = new CamelArtifact(fluent.getArtifactId(),fluent.getDataformats(),fluent.getDependencies(),fluent.getExclusions(),fluent.getGroupId(),fluent.getJavaTypes(),fluent.getLanguages(),fluent.getSchemes(),fluent.getVersion());
    return buildable;
  }
  
}