package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildSpecBuilder extends BuildSpecFluentImpl<BuildSpecBuilder> implements VisitableBuilder<BuildSpec,BuildSpecBuilder>{
  public BuildSpecBuilder() {
    this(false);
  }
  public BuildSpecBuilder(Boolean validationEnabled) {
    this(new BuildSpec(), validationEnabled);
  }
  public BuildSpecBuilder(BuildSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildSpecBuilder(BuildSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildSpec(), validationEnabled);
  }
  public BuildSpecBuilder(BuildSpecFluent<?> fluent,BuildSpec instance) {
    this(fluent, instance, false);
  }
  public BuildSpecBuilder(BuildSpecFluent<?> fluent,BuildSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withStrategy(instance.getStrategy()); 
    fluent.withTasks(instance.getTasks()); 
    fluent.withTimeout(instance.getTimeout()); 
    this.validationEnabled = validationEnabled; 
  }
  public BuildSpecBuilder(BuildSpec instance) {
    this(instance,false);
  }
  public BuildSpecBuilder(BuildSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withStrategy(instance.getStrategy()); 
    this.withTasks(instance.getTasks()); 
    this.withTimeout(instance.getTimeout()); 
    this.validationEnabled = validationEnabled; 
  }
  BuildSpecFluent<?> fluent;
  Boolean validationEnabled;
  public BuildSpec build() {
    BuildSpec buildable = new BuildSpec(fluent.getStrategy(),fluent.getTasks(),fluent.getTimeout());
    return buildable;
  }
  
}