package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MavenSpecFluentImpl<A extends MavenSpecFluent<A>> extends BaseFluent<A> implements MavenSpecFluent<A>{
  public MavenSpecFluentImpl() {
  }
  public MavenSpecFluentImpl(MavenSpec instance) {
    this.withCaSecret(instance.getCaSecret()); 
    this.withCliOptions(instance.getCliOptions()); 
    this.withExtension(instance.getExtension()); 
    this.withLocalRepository(instance.getLocalRepository()); 
    this.withProperties(instance.getProperties()); 
    this.withSettings(instance.getSettings()); 
    this.withTimeout(instance.getTimeout()); 
  }
  private SecretKeySelector caSecret;
  private List<String> cliOptions = new ArrayList<String>();
  private ArrayList<MavenArtifactBuilder> extension = new ArrayList<MavenArtifactBuilder>();
  private String localRepository;
  private Map<String,String> properties;
  private ValueSourceBuilder settings;
  private Duration timeout;
  public SecretKeySelector getCaSecret() {
    return this.caSecret;
  }
  public A withCaSecret(SecretKeySelector caSecret) {
    this.caSecret=caSecret; return (A) this;
  }
  public Boolean hasCaSecret() {
    return this.caSecret != null;
  }
  public A withNewCaSecret(String key,String name,Boolean optional) {
    return (A)withCaSecret(new SecretKeySelector(key, name, optional));
  }
  public A addToCliOptions(Integer index,String item) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    this.cliOptions.add(index, item);
    return (A)this;
  }
  public A setToCliOptions(Integer index,String item) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    this.cliOptions.set(index, item); return (A)this;
  }
  public A addToCliOptions(java.lang.String... items) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    for (String item : items) {this.cliOptions.add(item);} return (A)this;
  }
  public A addAllToCliOptions(Collection<String> items) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    for (String item : items) {this.cliOptions.add(item);} return (A)this;
  }
  public A removeFromCliOptions(java.lang.String... items) {
    for (String item : items) {if (this.cliOptions!= null){ this.cliOptions.remove(item);}} return (A)this;
  }
  public A removeAllFromCliOptions(Collection<String> items) {
    for (String item : items) {if (this.cliOptions!= null){ this.cliOptions.remove(item);}} return (A)this;
  }
  public List<String> getCliOptions() {
    return this.cliOptions;
  }
  public String getCliOption(Integer index) {
    return this.cliOptions.get(index);
  }
  public String getFirstCliOption() {
    return this.cliOptions.get(0);
  }
  public String getLastCliOption() {
    return this.cliOptions.get(cliOptions.size() - 1);
  }
  public String getMatchingCliOption(Predicate<String> predicate) {
    for (String item: cliOptions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCliOption(Predicate<String> predicate) {
    for (String item: cliOptions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCliOptions(List<String> cliOptions) {
    if (cliOptions != null) {this.cliOptions = new ArrayList(); for (String item : cliOptions){this.addToCliOptions(item);}} else { this.cliOptions = null;} return (A) this;
  }
  public A withCliOptions(java.lang.String... cliOptions) {
    if (this.cliOptions != null) {this.cliOptions.clear();}
    if (cliOptions != null) {for (String item :cliOptions){ this.addToCliOptions(item);}} return (A) this;
  }
  public Boolean hasCliOptions() {
    return cliOptions != null && !cliOptions.isEmpty();
  }
  public A addToExtension(Integer index,MavenArtifact item) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").add(index >= 0 ? index : _visitables.get("extension").size(), builder);this.extension.add(index >= 0 ? index : extension.size(), builder); return (A)this;
  }
  public A setToExtension(Integer index,MavenArtifact item) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
    if (index < 0 || index >= _visitables.get("extension").size()) { _visitables.get("extension").add(builder); } else { _visitables.get("extension").set(index, builder);}
    if (index < 0 || index >= extension.size()) { extension.add(builder); } else { extension.set(index, builder);}
     return (A)this;
  }
  public A addToExtension(io.fabric8.camelk.v1.MavenArtifact... items) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").add(builder);this.extension.add(builder);} return (A)this;
  }
  public A addAllToExtension(Collection<MavenArtifact> items) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").add(builder);this.extension.add(builder);} return (A)this;
  }
  public A removeFromExtension(io.fabric8.camelk.v1.MavenArtifact... items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").remove(builder);if (this.extension != null) {this.extension.remove(builder);}} return (A)this;
  }
  public A removeAllFromExtension(Collection<MavenArtifact> items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").remove(builder);if (this.extension != null) {this.extension.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExtension(Predicate<MavenArtifactBuilder> predicate) {
    if (extension == null) return (A) this;
    final Iterator<MavenArtifactBuilder> each = extension.iterator();
    final List visitables = _visitables.get("extension");
    while (each.hasNext()) {
      MavenArtifactBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExtension instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MavenArtifact> getExtension() {
    return extension != null ? build(extension) : null;
  }
  public List<MavenArtifact> buildExtension() {
    return extension != null ? build(extension) : null;
  }
  public MavenArtifact buildExtension(Integer index) {
    return this.extension.get(index).build();
  }
  public MavenArtifact buildFirstExtension() {
    return this.extension.get(0).build();
  }
  public MavenArtifact buildLastExtension() {
    return this.extension.get(extension.size() - 1).build();
  }
  public MavenArtifact buildMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: extension) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: extension) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtension(List<MavenArtifact> extension) {
    if (this.extension != null) { _visitables.get("extension").removeAll(this.extension);}
    if (extension != null) {this.extension = new ArrayList(); for (MavenArtifact item : extension){this.addToExtension(item);}} else { this.extension = null;} return (A) this;
  }
  public A withExtension(io.fabric8.camelk.v1.MavenArtifact... extension) {
    if (this.extension != null) {this.extension.clear();}
    if (extension != null) {for (MavenArtifact item :extension){ this.addToExtension(item);}} return (A) this;
  }
  public Boolean hasExtension() {
    return extension != null && !extension.isEmpty();
  }
  public A addNewExtension(String artifactId,String groupId,String version) {
    return (A)addToExtension(new MavenArtifact(artifactId, groupId, version));
  }
  public MavenSpecFluent.ExtensionNested<A> addNewExtension() {
    return new MavenSpecFluentImpl.ExtensionNestedImpl();
  }
  public MavenSpecFluent.ExtensionNested<A> addNewExtensionLike(MavenArtifact item) {
    return new MavenSpecFluentImpl.ExtensionNestedImpl(-1, item);
  }
  public MavenSpecFluent.ExtensionNested<A> setNewExtensionLike(Integer index,MavenArtifact item) {
    return new MavenSpecFluentImpl.ExtensionNestedImpl(index, item);
  }
  public MavenSpecFluent.ExtensionNested<A> editExtension(Integer index) {
    if (extension.size() <= index) throw new RuntimeException("Can't edit extension. Index exceeds size.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public MavenSpecFluent.ExtensionNested<A> editFirstExtension() {
    if (extension.size() == 0) throw new RuntimeException("Can't edit first extension. The list is empty.");
    return setNewExtensionLike(0, buildExtension(0));
  }
  public MavenSpecFluent.ExtensionNested<A> editLastExtension() {
    int index = extension.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extension. The list is empty.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public MavenSpecFluent.ExtensionNested<A> editMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extension.size();i++) { 
    if (predicate.test(extension.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extension. No match found.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public String getLocalRepository() {
    return this.localRepository;
  }
  public A withLocalRepository(String localRepository) {
    this.localRepository=localRepository; return (A) this;
  }
  public Boolean hasLocalRepository() {
    return this.localRepository != null;
  }
  public A addToProperties(String key,String value) {
    if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap(); }
    if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
  }
  public A addToProperties(Map<String,String> map) {
    if(this.properties == null && map != null) { this.properties = new LinkedHashMap(); }
    if(map != null) { this.properties.putAll(map);} return (A)this;
  }
  public A removeFromProperties(String key) {
    if(this.properties == null) { return (A) this; }
    if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
  }
  public A removeFromProperties(Map<String,String> map) {
    if(this.properties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
  }
  public Map<String,String> getProperties() {
    return this.properties;
  }
  public <K,V>A withProperties(Map<String,String> properties) {
    if (properties == null) { this.properties =  null;} else {this.properties = new LinkedHashMap(properties);} return (A) this;
  }
  public Boolean hasProperties() {
    return this.properties != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSettings instead.
   * @return The buildable object.
   */
  @Deprecated
  public ValueSource getSettings() {
    return this.settings!=null ?this.settings.build():null;
  }
  public ValueSource buildSettings() {
    return this.settings!=null ?this.settings.build():null;
  }
  public A withSettings(ValueSource settings) {
    _visitables.get("settings").remove(this.settings);
    if (settings!=null){ this.settings= new ValueSourceBuilder(settings); _visitables.get("settings").add(this.settings);} else { this.settings = null; _visitables.get("settings").remove(this.settings); } return (A) this;
  }
  public Boolean hasSettings() {
    return this.settings != null;
  }
  public MavenSpecFluent.SettingsNested<A> withNewSettings() {
    return new MavenSpecFluentImpl.SettingsNestedImpl();
  }
  public MavenSpecFluent.SettingsNested<A> withNewSettingsLike(ValueSource item) {
    return new MavenSpecFluentImpl.SettingsNestedImpl(item);
  }
  public MavenSpecFluent.SettingsNested<A> editSettings() {
    return withNewSettingsLike(getSettings());
  }
  public MavenSpecFluent.SettingsNested<A> editOrNewSettings() {
    return withNewSettingsLike(getSettings() != null ? getSettings(): new ValueSourceBuilder().build());
  }
  public MavenSpecFluent.SettingsNested<A> editOrNewSettingsLike(ValueSource item) {
    return withNewSettingsLike(getSettings() != null ? getSettings(): item);
  }
  public Duration getTimeout() {
    return this.timeout;
  }
  public A withTimeout(Duration timeout) {
    this.timeout=timeout; return (A) this;
  }
  public Boolean hasTimeout() {
    return this.timeout != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MavenSpecFluentImpl that = (MavenSpecFluentImpl) o;
    if (caSecret != null ? !caSecret.equals(that.caSecret) :that.caSecret != null) return false;
    if (cliOptions != null ? !cliOptions.equals(that.cliOptions) :that.cliOptions != null) return false;
    if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
    if (localRepository != null ? !localRepository.equals(that.localRepository) :that.localRepository != null) return false;
    if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
    if (settings != null ? !settings.equals(that.settings) :that.settings != null) return false;
    if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(caSecret,  cliOptions,  extension,  localRepository,  properties,  settings,  timeout,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caSecret != null) { sb.append("caSecret:"); sb.append(caSecret + ","); }
    if (cliOptions != null && !cliOptions.isEmpty()) { sb.append("cliOptions:"); sb.append(cliOptions + ","); }
    if (extension != null && !extension.isEmpty()) { sb.append("extension:"); sb.append(extension + ","); }
    if (localRepository != null) { sb.append("localRepository:"); sb.append(localRepository + ","); }
    if (properties != null && !properties.isEmpty()) { sb.append("properties:"); sb.append(properties + ","); }
    if (settings != null) { sb.append("settings:"); sb.append(settings + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout); }
    sb.append("}");
    return sb.toString();
  }
  class ExtensionNestedImpl<N> extends MavenArtifactFluentImpl<MavenSpecFluent.ExtensionNested<N>> implements MavenSpecFluent.ExtensionNested<N>,Nested<N>{
    ExtensionNestedImpl(Integer index,MavenArtifact item) {
      this.index = index;
      this.builder = new MavenArtifactBuilder(this, item);
    }
    ExtensionNestedImpl() {
      this.index = -1;
      this.builder = new MavenArtifactBuilder(this);
    }
    MavenArtifactBuilder builder;
    Integer index;
    public N and() {
      return (N) MavenSpecFluentImpl.this.setToExtension(index,builder.build());
    }
    public N endExtension() {
      return and();
    }
    
  }
  class SettingsNestedImpl<N> extends ValueSourceFluentImpl<MavenSpecFluent.SettingsNested<N>> implements MavenSpecFluent.SettingsNested<N>,Nested<N>{
    SettingsNestedImpl(ValueSource item) {
      this.builder = new ValueSourceBuilder(this, item);
    }
    SettingsNestedImpl() {
      this.builder = new ValueSourceBuilder(this);
    }
    ValueSourceBuilder builder;
    public N and() {
      return (N) MavenSpecFluentImpl.this.withSettings(builder.build());
    }
    public N endSettings() {
      return and();
    }
    
  }
  
}