package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface MavenSpecFluent<A extends MavenSpecFluent<A>> extends Fluent<A>{
  public SecretKeySelector getCaSecret();
  public A withCaSecret(SecretKeySelector caSecret);
  public Boolean hasCaSecret();
  public A withNewCaSecret(String key,String name,Boolean optional);
  public A addToCliOptions(Integer index,String item);
  public A setToCliOptions(Integer index,String item);
  public A addToCliOptions(java.lang.String... items);
  public A addAllToCliOptions(Collection<String> items);
  public A removeFromCliOptions(java.lang.String... items);
  public A removeAllFromCliOptions(Collection<String> items);
  public List<String> getCliOptions();
  public String getCliOption(Integer index);
  public String getFirstCliOption();
  public String getLastCliOption();
  public String getMatchingCliOption(Predicate<String> predicate);
  public Boolean hasMatchingCliOption(Predicate<String> predicate);
  public A withCliOptions(List<String> cliOptions);
  public A withCliOptions(java.lang.String... cliOptions);
  public Boolean hasCliOptions();
  public A addToExtension(Integer index,MavenArtifact item);
  public A setToExtension(Integer index,MavenArtifact item);
  public A addToExtension(io.fabric8.camelk.v1.MavenArtifact... items);
  public A addAllToExtension(Collection<MavenArtifact> items);
  public A removeFromExtension(io.fabric8.camelk.v1.MavenArtifact... items);
  public A removeAllFromExtension(Collection<MavenArtifact> items);
  public A removeMatchingFromExtension(Predicate<MavenArtifactBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildExtension instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MavenArtifact> getExtension();
  public List<MavenArtifact> buildExtension();
  public MavenArtifact buildExtension(Integer index);
  public MavenArtifact buildFirstExtension();
  public MavenArtifact buildLastExtension();
  public MavenArtifact buildMatchingExtension(Predicate<MavenArtifactBuilder> predicate);
  public Boolean hasMatchingExtension(Predicate<MavenArtifactBuilder> predicate);
  public A withExtension(List<MavenArtifact> extension);
  public A withExtension(io.fabric8.camelk.v1.MavenArtifact... extension);
  public Boolean hasExtension();
  public A addNewExtension(String artifactId,String groupId,String version);
  public MavenSpecFluent.ExtensionNested<A> addNewExtension();
  public MavenSpecFluent.ExtensionNested<A> addNewExtensionLike(MavenArtifact item);
  public MavenSpecFluent.ExtensionNested<A> setNewExtensionLike(Integer index,MavenArtifact item);
  public MavenSpecFluent.ExtensionNested<A> editExtension(Integer index);
  public MavenSpecFluent.ExtensionNested<A> editFirstExtension();
  public MavenSpecFluent.ExtensionNested<A> editLastExtension();
  public MavenSpecFluent.ExtensionNested<A> editMatchingExtension(Predicate<MavenArtifactBuilder> predicate);
  public String getLocalRepository();
  public A withLocalRepository(String localRepository);
  public Boolean hasLocalRepository();
  public A addToProperties(String key,String value);
  public A addToProperties(Map<String,String> map);
  public A removeFromProperties(String key);
  public A removeFromProperties(Map<String,String> map);
  public Map<String,String> getProperties();
  public <K,V>A withProperties(Map<String,String> properties);
  public Boolean hasProperties();
  
  /**
   * This method has been deprecated, please use method buildSettings instead.
   * @return The buildable object.
   */
  @Deprecated
  public ValueSource getSettings();
  public ValueSource buildSettings();
  public A withSettings(ValueSource settings);
  public Boolean hasSettings();
  public MavenSpecFluent.SettingsNested<A> withNewSettings();
  public MavenSpecFluent.SettingsNested<A> withNewSettingsLike(ValueSource item);
  public MavenSpecFluent.SettingsNested<A> editSettings();
  public MavenSpecFluent.SettingsNested<A> editOrNewSettings();
  public MavenSpecFluent.SettingsNested<A> editOrNewSettingsLike(ValueSource item);
  public Duration getTimeout();
  public A withTimeout(Duration timeout);
  public Boolean hasTimeout();
  public interface ExtensionNested<N> extends Nested<N>,MavenArtifactFluent<MavenSpecFluent.ExtensionNested<N>>{
    public N and();
    public N endExtension();
    
  }
  public interface SettingsNested<N> extends Nested<N>,ValueSourceFluent<MavenSpecFluent.SettingsNested<N>>{
    public N and();
    public N endSettings();
    
  }
  
}