package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MavenBuildSpecBuilder extends MavenBuildSpecFluentImpl<MavenBuildSpecBuilder> implements VisitableBuilder<MavenBuildSpec,MavenBuildSpecBuilder>{
  public MavenBuildSpecBuilder() {
    this(false);
  }
  public MavenBuildSpecBuilder(Boolean validationEnabled) {
    this(new MavenBuildSpec(), validationEnabled);
  }
  public MavenBuildSpecBuilder(MavenBuildSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MavenBuildSpecBuilder(MavenBuildSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MavenBuildSpec(), validationEnabled);
  }
  public MavenBuildSpecBuilder(MavenBuildSpecFluent<?> fluent,MavenBuildSpec instance) {
    this(fluent, instance, false);
  }
  public MavenBuildSpecBuilder(MavenBuildSpecFluent<?> fluent,MavenBuildSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCaSecret(instance.getCaSecret()); 
    fluent.withCliOptions(instance.getCliOptions()); 
    fluent.withExtension(instance.getExtension()); 
    fluent.withLocalRepository(instance.getLocalRepository()); 
    fluent.withProperties(instance.getProperties()); 
    fluent.withRepositories(instance.getRepositories()); 
    fluent.withSettings(instance.getSettings()); 
    fluent.withTimeout(instance.getTimeout()); 
    this.validationEnabled = validationEnabled; 
  }
  public MavenBuildSpecBuilder(MavenBuildSpec instance) {
    this(instance,false);
  }
  public MavenBuildSpecBuilder(MavenBuildSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCaSecret(instance.getCaSecret()); 
    this.withCliOptions(instance.getCliOptions()); 
    this.withExtension(instance.getExtension()); 
    this.withLocalRepository(instance.getLocalRepository()); 
    this.withProperties(instance.getProperties()); 
    this.withRepositories(instance.getRepositories()); 
    this.withSettings(instance.getSettings()); 
    this.withTimeout(instance.getTimeout()); 
    this.validationEnabled = validationEnabled; 
  }
  MavenBuildSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MavenBuildSpec build() {
    MavenBuildSpec buildable = new MavenBuildSpec(fluent.getCaSecret(),fluent.getCliOptions(),fluent.getExtension(),fluent.getLocalRepository(),fluent.getProperties(),fluent.getRepositories(),fluent.getSettings(),fluent.getTimeout());
    return buildable;
  }
  
}