package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.util.Collection;

 /**
  * Generated
  */
public interface IntegrationStatusFluent<A extends IntegrationStatusFluent<A>> extends Fluent<A>{
  public A addToCapabilities(Integer index,String item);
  public A setToCapabilities(Integer index,String item);
  public A addToCapabilities(java.lang.String... items);
  public A addAllToCapabilities(Collection<String> items);
  public A removeFromCapabilities(java.lang.String... items);
  public A removeAllFromCapabilities(Collection<String> items);
  public List<String> getCapabilities();
  public String getCapability(Integer index);
  public String getFirstCapability();
  public String getLastCapability();
  public String getMatchingCapability(Predicate<String> predicate);
  public Boolean hasMatchingCapability(Predicate<String> predicate);
  public A withCapabilities(List<String> capabilities);
  public A withCapabilities(java.lang.String... capabilities);
  public Boolean hasCapabilities();
  public A addToConditions(Integer index,IntegrationCondition item);
  public A setToConditions(Integer index,IntegrationCondition item);
  public A addToConditions(io.fabric8.camelk.v1.IntegrationCondition... items);
  public A addAllToConditions(Collection<IntegrationCondition> items);
  public A removeFromConditions(io.fabric8.camelk.v1.IntegrationCondition... items);
  public A removeAllFromConditions(Collection<IntegrationCondition> items);
  public A removeMatchingFromConditions(Predicate<IntegrationConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IntegrationCondition> getConditions();
  public List<IntegrationCondition> buildConditions();
  public IntegrationCondition buildCondition(Integer index);
  public IntegrationCondition buildFirstCondition();
  public IntegrationCondition buildLastCondition();
  public IntegrationCondition buildMatchingCondition(Predicate<IntegrationConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<IntegrationConditionBuilder> predicate);
  public A withConditions(List<IntegrationCondition> conditions);
  public A withConditions(io.fabric8.camelk.v1.IntegrationCondition... conditions);
  public Boolean hasConditions();
  public IntegrationStatusFluent.ConditionsNested<A> addNewCondition();
  public IntegrationStatusFluent.ConditionsNested<A> addNewConditionLike(IntegrationCondition item);
  public IntegrationStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,IntegrationCondition item);
  public IntegrationStatusFluent.ConditionsNested<A> editCondition(Integer index);
  public IntegrationStatusFluent.ConditionsNested<A> editFirstCondition();
  public IntegrationStatusFluent.ConditionsNested<A> editLastCondition();
  public IntegrationStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IntegrationConditionBuilder> predicate);
  public A addToConfiguration(Integer index,ConfigurationSpec item);
  public A setToConfiguration(Integer index,ConfigurationSpec item);
  public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items);
  public A addAllToConfiguration(Collection<ConfigurationSpec> items);
  public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items);
  public A removeAllFromConfiguration(Collection<ConfigurationSpec> items);
  public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConfigurationSpec> getConfiguration();
  public List<ConfigurationSpec> buildConfiguration();
  public ConfigurationSpec buildConfiguration(Integer index);
  public ConfigurationSpec buildFirstConfiguration();
  public ConfigurationSpec buildLastConfiguration();
  public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
  public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
  public A withConfiguration(List<ConfigurationSpec> configuration);
  public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration);
  public Boolean hasConfiguration();
  public A addNewConfiguration(String resourceKey,String resourceMountPoint,String resourceType,String type,String value);
  public IntegrationStatusFluent.ConfigurationNested<A> addNewConfiguration();
  public IntegrationStatusFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item);
  public IntegrationStatusFluent.ConfigurationNested<A> setNewConfigurationLike(Integer index,ConfigurationSpec item);
  public IntegrationStatusFluent.ConfigurationNested<A> editConfiguration(Integer index);
  public IntegrationStatusFluent.ConfigurationNested<A> editFirstConfiguration();
  public IntegrationStatusFluent.ConfigurationNested<A> editLastConfiguration();
  public IntegrationStatusFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
  public A addToDependencies(Integer index,String item);
  public A setToDependencies(Integer index,String item);
  public A addToDependencies(java.lang.String... items);
  public A addAllToDependencies(Collection<String> items);
  public A removeFromDependencies(java.lang.String... items);
  public A removeAllFromDependencies(Collection<String> items);
  public List<String> getDependencies();
  public String getDependency(Integer index);
  public String getFirstDependency();
  public String getLastDependency();
  public String getMatchingDependency(Predicate<String> predicate);
  public Boolean hasMatchingDependency(Predicate<String> predicate);
  public A withDependencies(List<String> dependencies);
  public A withDependencies(java.lang.String... dependencies);
  public Boolean hasDependencies();
  public String getDigest();
  public A withDigest(String digest);
  public Boolean hasDigest();
  public A addToGeneratedResources(Integer index,ResourceSpec item);
  public A setToGeneratedResources(Integer index,ResourceSpec item);
  public A addToGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... items);
  public A addAllToGeneratedResources(Collection<ResourceSpec> items);
  public A removeFromGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... items);
  public A removeAllFromGeneratedResources(Collection<ResourceSpec> items);
  public A removeMatchingFromGeneratedResources(Predicate<ResourceSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildGeneratedResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceSpec> getGeneratedResources();
  public List<ResourceSpec> buildGeneratedResources();
  public ResourceSpec buildGeneratedResource(Integer index);
  public ResourceSpec buildFirstGeneratedResource();
  public ResourceSpec buildLastGeneratedResource();
  public ResourceSpec buildMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate);
  public Boolean hasMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate);
  public A withGeneratedResources(List<ResourceSpec> generatedResources);
  public A withGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... generatedResources);
  public Boolean hasGeneratedResources();
  public IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResource();
  public IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResourceLike(ResourceSpec item);
  public IntegrationStatusFluent.GeneratedResourcesNested<A> setNewGeneratedResourceLike(Integer index,ResourceSpec item);
  public IntegrationStatusFluent.GeneratedResourcesNested<A> editGeneratedResource(Integer index);
  public IntegrationStatusFluent.GeneratedResourcesNested<A> editFirstGeneratedResource();
  public IntegrationStatusFluent.GeneratedResourcesNested<A> editLastGeneratedResource();
  public IntegrationStatusFluent.GeneratedResourcesNested<A> editMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate);
  public A addToGeneratedSources(Integer index,SourceSpec item);
  public A setToGeneratedSources(Integer index,SourceSpec item);
  public A addToGeneratedSources(io.fabric8.camelk.v1.SourceSpec... items);
  public A addAllToGeneratedSources(Collection<SourceSpec> items);
  public A removeFromGeneratedSources(io.fabric8.camelk.v1.SourceSpec... items);
  public A removeAllFromGeneratedSources(Collection<SourceSpec> items);
  public A removeMatchingFromGeneratedSources(Predicate<SourceSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildGeneratedSources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SourceSpec> getGeneratedSources();
  public List<SourceSpec> buildGeneratedSources();
  public SourceSpec buildGeneratedSource(Integer index);
  public SourceSpec buildFirstGeneratedSource();
  public SourceSpec buildLastGeneratedSource();
  public SourceSpec buildMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate);
  public Boolean hasMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate);
  public A withGeneratedSources(List<SourceSpec> generatedSources);
  public A withGeneratedSources(io.fabric8.camelk.v1.SourceSpec... generatedSources);
  public Boolean hasGeneratedSources();
  public IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSource();
  public IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSourceLike(SourceSpec item);
  public IntegrationStatusFluent.GeneratedSourcesNested<A> setNewGeneratedSourceLike(Integer index,SourceSpec item);
  public IntegrationStatusFluent.GeneratedSourcesNested<A> editGeneratedSource(Integer index);
  public IntegrationStatusFluent.GeneratedSourcesNested<A> editFirstGeneratedSource();
  public IntegrationStatusFluent.GeneratedSourcesNested<A> editLastGeneratedSource();
  public IntegrationStatusFluent.GeneratedSourcesNested<A> editMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate);
  public String getImage();
  public A withImage(String image);
  public Boolean hasImage();
  
  /**
   * This method has been deprecated, please use method buildIntegrationKit instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIntegrationKit();
  public ObjectReference buildIntegrationKit();
  public A withIntegrationKit(ObjectReference integrationKit);
  public Boolean hasIntegrationKit();
  public IntegrationStatusFluent.IntegrationKitNested<A> withNewIntegrationKit();
  public IntegrationStatusFluent.IntegrationKitNested<A> withNewIntegrationKitLike(ObjectReference item);
  public IntegrationStatusFluent.IntegrationKitNested<A> editIntegrationKit();
  public IntegrationStatusFluent.IntegrationKitNested<A> editOrNewIntegrationKit();
  public IntegrationStatusFluent.IntegrationKitNested<A> editOrNewIntegrationKitLike(ObjectReference item);
  public String getKit();
  public A withKit(String kit);
  public Boolean hasKit();
  public String getLastInitTimestamp();
  public A withLastInitTimestamp(String lastInitTimestamp);
  public Boolean hasLastInitTimestamp();
  public String getPhase();
  public A withPhase(String phase);
  public Boolean hasPhase();
  public String getPlatform();
  public A withPlatform(String platform);
  public Boolean hasPlatform();
  public String getProfile();
  public A withProfile(String profile);
  public Boolean hasProfile();
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  public String getRuntimeProvider();
  public A withRuntimeProvider(String runtimeProvider);
  public Boolean hasRuntimeProvider();
  public String getRuntimeVersion();
  public A withRuntimeVersion(String runtimeVersion);
  public Boolean hasRuntimeVersion();
  public String getSelector();
  public A withSelector(String selector);
  public Boolean hasSelector();
  public String getVersion();
  public A withVersion(String version);
  public Boolean hasVersion();
  public interface ConditionsNested<N> extends Nested<N>,IntegrationConditionFluent<IntegrationStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface ConfigurationNested<N> extends Nested<N>,ConfigurationSpecFluent<IntegrationStatusFluent.ConfigurationNested<N>>{
    public N and();
    public N endConfiguration();
    
  }
  public interface GeneratedResourcesNested<N> extends Nested<N>,ResourceSpecFluent<IntegrationStatusFluent.GeneratedResourcesNested<N>>{
    public N and();
    public N endGeneratedResource();
    
  }
  public interface GeneratedSourcesNested<N> extends Nested<N>,SourceSpecFluent<IntegrationStatusFluent.GeneratedSourcesNested<N>>{
    public N and();
    public N endGeneratedSource();
    
  }
  public interface IntegrationKitNested<N> extends Nested<N>,ObjectReferenceFluent<IntegrationStatusFluent.IntegrationKitNested<N>>{
    public N and();
    public N endIntegrationKit();
    
  }
  
}