package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.util.Collection;
import java.util.Map;

 /**
  * Generated
  */
public interface IntegrationSpecFluent<A extends IntegrationSpecFluent<A>> extends Fluent<A>{
  public A addToConfiguration(Integer index,ConfigurationSpec item);
  public A setToConfiguration(Integer index,ConfigurationSpec item);
  public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items);
  public A addAllToConfiguration(Collection<ConfigurationSpec> items);
  public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items);
  public A removeAllFromConfiguration(Collection<ConfigurationSpec> items);
  public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConfigurationSpec> getConfiguration();
  public List<ConfigurationSpec> buildConfiguration();
  public ConfigurationSpec buildConfiguration(Integer index);
  public ConfigurationSpec buildFirstConfiguration();
  public ConfigurationSpec buildLastConfiguration();
  public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
  public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
  public A withConfiguration(List<ConfigurationSpec> configuration);
  public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration);
  public Boolean hasConfiguration();
  public A addNewConfiguration(String resourceKey,String resourceMountPoint,String resourceType,String type,String value);
  public IntegrationSpecFluent.ConfigurationNested<A> addNewConfiguration();
  public IntegrationSpecFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item);
  public IntegrationSpecFluent.ConfigurationNested<A> setNewConfigurationLike(Integer index,ConfigurationSpec item);
  public IntegrationSpecFluent.ConfigurationNested<A> editConfiguration(Integer index);
  public IntegrationSpecFluent.ConfigurationNested<A> editFirstConfiguration();
  public IntegrationSpecFluent.ConfigurationNested<A> editLastConfiguration();
  public IntegrationSpecFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
  public A addToDependencies(Integer index,String item);
  public A setToDependencies(Integer index,String item);
  public A addToDependencies(java.lang.String... items);
  public A addAllToDependencies(Collection<String> items);
  public A removeFromDependencies(java.lang.String... items);
  public A removeAllFromDependencies(Collection<String> items);
  public List<String> getDependencies();
  public String getDependency(Integer index);
  public String getFirstDependency();
  public String getLastDependency();
  public String getMatchingDependency(Predicate<String> predicate);
  public Boolean hasMatchingDependency(Predicate<String> predicate);
  public A withDependencies(List<String> dependencies);
  public A withDependencies(java.lang.String... dependencies);
  public Boolean hasDependencies();
  public A addToFlows(Integer index,JsonNode item);
  public A setToFlows(Integer index,JsonNode item);
  public A addToFlows(com.fasterxml.jackson.databind.JsonNode... items);
  public A addAllToFlows(Collection<JsonNode> items);
  public A removeFromFlows(com.fasterxml.jackson.databind.JsonNode... items);
  public A removeAllFromFlows(Collection<JsonNode> items);
  public List<JsonNode> getFlows();
  public JsonNode getFlow(Integer index);
  public JsonNode getFirstFlow();
  public JsonNode getLastFlow();
  public JsonNode getMatchingFlow(Predicate<JsonNode> predicate);
  public Boolean hasMatchingFlow(Predicate<JsonNode> predicate);
  public A withFlows(List<JsonNode> flows);
  public A withFlows(com.fasterxml.jackson.databind.JsonNode... flows);
  public Boolean hasFlows();
  
  /**
   * This method has been deprecated, please use method buildIntegrationKit instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIntegrationKit();
  public ObjectReference buildIntegrationKit();
  public A withIntegrationKit(ObjectReference integrationKit);
  public Boolean hasIntegrationKit();
  public IntegrationSpecFluent.IntegrationKitNested<A> withNewIntegrationKit();
  public IntegrationSpecFluent.IntegrationKitNested<A> withNewIntegrationKitLike(ObjectReference item);
  public IntegrationSpecFluent.IntegrationKitNested<A> editIntegrationKit();
  public IntegrationSpecFluent.IntegrationKitNested<A> editOrNewIntegrationKit();
  public IntegrationSpecFluent.IntegrationKitNested<A> editOrNewIntegrationKitLike(ObjectReference item);
  public String getKit();
  public A withKit(String kit);
  public Boolean hasKit();
  public String getProfile();
  public A withProfile(String profile);
  public Boolean hasProfile();
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  public A addToRepositories(Integer index,String item);
  public A setToRepositories(Integer index,String item);
  public A addToRepositories(java.lang.String... items);
  public A addAllToRepositories(Collection<String> items);
  public A removeFromRepositories(java.lang.String... items);
  public A removeAllFromRepositories(Collection<String> items);
  public List<String> getRepositories();
  public String getRepository(Integer index);
  public String getFirstRepository();
  public String getLastRepository();
  public String getMatchingRepository(Predicate<String> predicate);
  public Boolean hasMatchingRepository(Predicate<String> predicate);
  public A withRepositories(List<String> repositories);
  public A withRepositories(java.lang.String... repositories);
  public Boolean hasRepositories();
  public A addToResources(Integer index,ResourceSpec item);
  public A setToResources(Integer index,ResourceSpec item);
  public A addToResources(io.fabric8.camelk.v1.ResourceSpec... items);
  public A addAllToResources(Collection<ResourceSpec> items);
  public A removeFromResources(io.fabric8.camelk.v1.ResourceSpec... items);
  public A removeAllFromResources(Collection<ResourceSpec> items);
  public A removeMatchingFromResources(Predicate<ResourceSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceSpec> getResources();
  public List<ResourceSpec> buildResources();
  public ResourceSpec buildResource(Integer index);
  public ResourceSpec buildFirstResource();
  public ResourceSpec buildLastResource();
  public ResourceSpec buildMatchingResource(Predicate<ResourceSpecBuilder> predicate);
  public Boolean hasMatchingResource(Predicate<ResourceSpecBuilder> predicate);
  public A withResources(List<ResourceSpec> resources);
  public A withResources(io.fabric8.camelk.v1.ResourceSpec... resources);
  public Boolean hasResources();
  public IntegrationSpecFluent.ResourcesNested<A> addNewResource();
  public IntegrationSpecFluent.ResourcesNested<A> addNewResourceLike(ResourceSpec item);
  public IntegrationSpecFluent.ResourcesNested<A> setNewResourceLike(Integer index,ResourceSpec item);
  public IntegrationSpecFluent.ResourcesNested<A> editResource(Integer index);
  public IntegrationSpecFluent.ResourcesNested<A> editFirstResource();
  public IntegrationSpecFluent.ResourcesNested<A> editLastResource();
  public IntegrationSpecFluent.ResourcesNested<A> editMatchingResource(Predicate<ResourceSpecBuilder> predicate);
  public String getServiceAccountName();
  public A withServiceAccountName(String serviceAccountName);
  public Boolean hasServiceAccountName();
  public A addToSources(Integer index,SourceSpec item);
  public A setToSources(Integer index,SourceSpec item);
  public A addToSources(io.fabric8.camelk.v1.SourceSpec... items);
  public A addAllToSources(Collection<SourceSpec> items);
  public A removeFromSources(io.fabric8.camelk.v1.SourceSpec... items);
  public A removeAllFromSources(Collection<SourceSpec> items);
  public A removeMatchingFromSources(Predicate<SourceSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SourceSpec> getSources();
  public List<SourceSpec> buildSources();
  public SourceSpec buildSource(Integer index);
  public SourceSpec buildFirstSource();
  public SourceSpec buildLastSource();
  public SourceSpec buildMatchingSource(Predicate<SourceSpecBuilder> predicate);
  public Boolean hasMatchingSource(Predicate<SourceSpecBuilder> predicate);
  public A withSources(List<SourceSpec> sources);
  public A withSources(io.fabric8.camelk.v1.SourceSpec... sources);
  public Boolean hasSources();
  public IntegrationSpecFluent.SourcesNested<A> addNewSource();
  public IntegrationSpecFluent.SourcesNested<A> addNewSourceLike(SourceSpec item);
  public IntegrationSpecFluent.SourcesNested<A> setNewSourceLike(Integer index,SourceSpec item);
  public IntegrationSpecFluent.SourcesNested<A> editSource(Integer index);
  public IntegrationSpecFluent.SourcesNested<A> editFirstSource();
  public IntegrationSpecFluent.SourcesNested<A> editLastSource();
  public IntegrationSpecFluent.SourcesNested<A> editMatchingSource(Predicate<SourceSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSpecTemplate getTemplate();
  public PodSpecTemplate buildTemplate();
  public A withTemplate(PodSpecTemplate template);
  public Boolean hasTemplate();
  public IntegrationSpecFluent.TemplateNested<A> withNewTemplate();
  public IntegrationSpecFluent.TemplateNested<A> withNewTemplateLike(PodSpecTemplate item);
  public IntegrationSpecFluent.TemplateNested<A> editTemplate();
  public IntegrationSpecFluent.TemplateNested<A> editOrNewTemplate();
  public IntegrationSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodSpecTemplate item);
  public A addToTraits(String key,TraitSpec value);
  public A addToTraits(Map<String,TraitSpec> map);
  public A removeFromTraits(String key);
  public A removeFromTraits(Map<String,TraitSpec> map);
  public Map<String,TraitSpec> getTraits();
  public <K,V>A withTraits(Map<String,TraitSpec> traits);
  public Boolean hasTraits();
  public interface ConfigurationNested<N> extends Nested<N>,ConfigurationSpecFluent<IntegrationSpecFluent.ConfigurationNested<N>>{
    public N and();
    public N endConfiguration();
    
  }
  public interface IntegrationKitNested<N> extends Nested<N>,ObjectReferenceFluent<IntegrationSpecFluent.IntegrationKitNested<N>>{
    public N and();
    public N endIntegrationKit();
    
  }
  public interface ResourcesNested<N> extends Nested<N>,ResourceSpecFluent<IntegrationSpecFluent.ResourcesNested<N>>{
    public N and();
    public N endResource();
    
  }
  public interface SourcesNested<N> extends Nested<N>,SourceSpecFluent<IntegrationSpecFluent.SourcesNested<N>>{
    public N and();
    public N endSource();
    
  }
  public interface TemplateNested<N> extends Nested<N>,PodSpecTemplateFluent<IntegrationSpecFluent.TemplateNested<N>>{
    public N and();
    public N endTemplate();
    
  }
  
}