package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationPlatformConditionBuilder extends IntegrationPlatformConditionFluentImpl<IntegrationPlatformConditionBuilder> implements VisitableBuilder<IntegrationPlatformCondition,IntegrationPlatformConditionBuilder>{
  public IntegrationPlatformConditionBuilder() {
    this(false);
  }
  public IntegrationPlatformConditionBuilder(Boolean validationEnabled) {
    this(new IntegrationPlatformCondition(), validationEnabled);
  }
  public IntegrationPlatformConditionBuilder(IntegrationPlatformConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationPlatformConditionBuilder(IntegrationPlatformConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IntegrationPlatformCondition(), validationEnabled);
  }
  public IntegrationPlatformConditionBuilder(IntegrationPlatformConditionFluent<?> fluent,IntegrationPlatformCondition instance) {
    this(fluent, instance, false);
  }
  public IntegrationPlatformConditionBuilder(IntegrationPlatformConditionFluent<?> fluent,IntegrationPlatformCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationPlatformConditionBuilder(IntegrationPlatformCondition instance) {
    this(instance,false);
  }
  public IntegrationPlatformConditionBuilder(IntegrationPlatformCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withLastUpdateTime(instance.getLastUpdateTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  IntegrationPlatformConditionFluent<?> fluent;
  Boolean validationEnabled;
  public IntegrationPlatformCondition build() {
    IntegrationPlatformCondition buildable = new IntegrationPlatformCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}