package io.fabric8.camelk.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IntegrationPlatformBuildSpecFluentImpl<A extends IntegrationPlatformBuildSpecFluent<A>> extends BaseFluent<A> implements IntegrationPlatformBuildSpecFluent<A>{
  public IntegrationPlatformBuildSpecFluentImpl() {
  }
  public IntegrationPlatformBuildSpecFluentImpl(IntegrationPlatformBuildSpec instance) {
    this.withBaseImage(instance.getBaseImage()); 
    this.withBuildStrategy(instance.getBuildStrategy()); 
    this.withKanikoBuildCache(instance.getKanikoBuildCache()); 
    this.withMaven(instance.getMaven()); 
    this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
    this.withPublishStrategy(instance.getPublishStrategy()); 
    this.withRegistry(instance.getRegistry()); 
    this.withRuntimeProvider(instance.getRuntimeProvider()); 
    this.withRuntimeVersion(instance.getRuntimeVersion()); 
    this.withTimeout(instance.getTimeout()); 
  }
  private String baseImage;
  private String buildStrategy;
  private Boolean kanikoBuildCache;
  private MavenSpecBuilder maven;
  private String persistentVolumeClaim;
  private String publishStrategy;
  private RegistrySpecBuilder registry;
  private String runtimeProvider;
  private String runtimeVersion;
  private Duration timeout;
  public String getBaseImage() {
    return this.baseImage;
  }
  public A withBaseImage(String baseImage) {
    this.baseImage=baseImage; return (A) this;
  }
  public Boolean hasBaseImage() {
    return this.baseImage != null;
  }
  public String getBuildStrategy() {
    return this.buildStrategy;
  }
  public A withBuildStrategy(String buildStrategy) {
    this.buildStrategy=buildStrategy; return (A) this;
  }
  public Boolean hasBuildStrategy() {
    return this.buildStrategy != null;
  }
  public Boolean getKanikoBuildCache() {
    return this.kanikoBuildCache;
  }
  public A withKanikoBuildCache(Boolean kanikoBuildCache) {
    this.kanikoBuildCache=kanikoBuildCache; return (A) this;
  }
  public Boolean hasKanikoBuildCache() {
    return this.kanikoBuildCache != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMaven instead.
   * @return The buildable object.
   */
  @Deprecated
  public MavenSpec getMaven() {
    return this.maven!=null ?this.maven.build():null;
  }
  public MavenSpec buildMaven() {
    return this.maven!=null ?this.maven.build():null;
  }
  public A withMaven(MavenSpec maven) {
    _visitables.get("maven").remove(this.maven);
    if (maven!=null){ this.maven= new MavenSpecBuilder(maven); _visitables.get("maven").add(this.maven);} else { this.maven = null; _visitables.get("maven").remove(this.maven); } return (A) this;
  }
  public Boolean hasMaven() {
    return this.maven != null;
  }
  public IntegrationPlatformBuildSpecFluent.MavenNested<A> withNewMaven() {
    return new IntegrationPlatformBuildSpecFluentImpl.MavenNestedImpl();
  }
  public IntegrationPlatformBuildSpecFluent.MavenNested<A> withNewMavenLike(MavenSpec item) {
    return new IntegrationPlatformBuildSpecFluentImpl.MavenNestedImpl(item);
  }
  public IntegrationPlatformBuildSpecFluent.MavenNested<A> editMaven() {
    return withNewMavenLike(getMaven());
  }
  public IntegrationPlatformBuildSpecFluent.MavenNested<A> editOrNewMaven() {
    return withNewMavenLike(getMaven() != null ? getMaven(): new MavenSpecBuilder().build());
  }
  public IntegrationPlatformBuildSpecFluent.MavenNested<A> editOrNewMavenLike(MavenSpec item) {
    return withNewMavenLike(getMaven() != null ? getMaven(): item);
  }
  public String getPersistentVolumeClaim() {
    return this.persistentVolumeClaim;
  }
  public A withPersistentVolumeClaim(String persistentVolumeClaim) {
    this.persistentVolumeClaim=persistentVolumeClaim; return (A) this;
  }
  public Boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  public String getPublishStrategy() {
    return this.publishStrategy;
  }
  public A withPublishStrategy(String publishStrategy) {
    this.publishStrategy=publishStrategy; return (A) this;
  }
  public Boolean hasPublishStrategy() {
    return this.publishStrategy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRegistry instead.
   * @return The buildable object.
   */
  @Deprecated
  public RegistrySpec getRegistry() {
    return this.registry!=null ?this.registry.build():null;
  }
  public RegistrySpec buildRegistry() {
    return this.registry!=null ?this.registry.build():null;
  }
  public A withRegistry(RegistrySpec registry) {
    _visitables.get("registry").remove(this.registry);
    if (registry!=null){ this.registry= new RegistrySpecBuilder(registry); _visitables.get("registry").add(this.registry);} else { this.registry = null; _visitables.get("registry").remove(this.registry); } return (A) this;
  }
  public Boolean hasRegistry() {
    return this.registry != null;
  }
  public A withNewRegistry(String address,String ca,Boolean insecure,String organization,String secret) {
    return (A)withRegistry(new RegistrySpec(address, ca, insecure, organization, secret));
  }
  public IntegrationPlatformBuildSpecFluent.RegistryNested<A> withNewRegistry() {
    return new IntegrationPlatformBuildSpecFluentImpl.RegistryNestedImpl();
  }
  public IntegrationPlatformBuildSpecFluent.RegistryNested<A> withNewRegistryLike(RegistrySpec item) {
    return new IntegrationPlatformBuildSpecFluentImpl.RegistryNestedImpl(item);
  }
  public IntegrationPlatformBuildSpecFluent.RegistryNested<A> editRegistry() {
    return withNewRegistryLike(getRegistry());
  }
  public IntegrationPlatformBuildSpecFluent.RegistryNested<A> editOrNewRegistry() {
    return withNewRegistryLike(getRegistry() != null ? getRegistry(): new RegistrySpecBuilder().build());
  }
  public IntegrationPlatformBuildSpecFluent.RegistryNested<A> editOrNewRegistryLike(RegistrySpec item) {
    return withNewRegistryLike(getRegistry() != null ? getRegistry(): item);
  }
  public String getRuntimeProvider() {
    return this.runtimeProvider;
  }
  public A withRuntimeProvider(String runtimeProvider) {
    this.runtimeProvider=runtimeProvider; return (A) this;
  }
  public Boolean hasRuntimeProvider() {
    return this.runtimeProvider != null;
  }
  public String getRuntimeVersion() {
    return this.runtimeVersion;
  }
  public A withRuntimeVersion(String runtimeVersion) {
    this.runtimeVersion=runtimeVersion; return (A) this;
  }
  public Boolean hasRuntimeVersion() {
    return this.runtimeVersion != null;
  }
  public Duration getTimeout() {
    return this.timeout;
  }
  public A withTimeout(Duration timeout) {
    this.timeout=timeout; return (A) this;
  }
  public Boolean hasTimeout() {
    return this.timeout != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IntegrationPlatformBuildSpecFluentImpl that = (IntegrationPlatformBuildSpecFluentImpl) o;
    if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
    if (buildStrategy != null ? !buildStrategy.equals(that.buildStrategy) :that.buildStrategy != null) return false;
    if (kanikoBuildCache != null ? !kanikoBuildCache.equals(that.kanikoBuildCache) :that.kanikoBuildCache != null) return false;
    if (maven != null ? !maven.equals(that.maven) :that.maven != null) return false;
    if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
    if (publishStrategy != null ? !publishStrategy.equals(that.publishStrategy) :that.publishStrategy != null) return false;
    if (registry != null ? !registry.equals(that.registry) :that.registry != null) return false;
    if (runtimeProvider != null ? !runtimeProvider.equals(that.runtimeProvider) :that.runtimeProvider != null) return false;
    if (runtimeVersion != null ? !runtimeVersion.equals(that.runtimeVersion) :that.runtimeVersion != null) return false;
    if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(baseImage,  buildStrategy,  kanikoBuildCache,  maven,  persistentVolumeClaim,  publishStrategy,  registry,  runtimeProvider,  runtimeVersion,  timeout,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseImage != null) { sb.append("baseImage:"); sb.append(baseImage + ","); }
    if (buildStrategy != null) { sb.append("buildStrategy:"); sb.append(buildStrategy + ","); }
    if (kanikoBuildCache != null) { sb.append("kanikoBuildCache:"); sb.append(kanikoBuildCache + ","); }
    if (maven != null) { sb.append("maven:"); sb.append(maven + ","); }
    if (persistentVolumeClaim != null) { sb.append("persistentVolumeClaim:"); sb.append(persistentVolumeClaim + ","); }
    if (publishStrategy != null) { sb.append("publishStrategy:"); sb.append(publishStrategy + ","); }
    if (registry != null) { sb.append("registry:"); sb.append(registry + ","); }
    if (runtimeProvider != null) { sb.append("runtimeProvider:"); sb.append(runtimeProvider + ","); }
    if (runtimeVersion != null) { sb.append("runtimeVersion:"); sb.append(runtimeVersion + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout); }
    sb.append("}");
    return sb.toString();
  }
  public A withKanikoBuildCache() {
    return withKanikoBuildCache(true);
  }
  class MavenNestedImpl<N> extends MavenSpecFluentImpl<IntegrationPlatformBuildSpecFluent.MavenNested<N>> implements IntegrationPlatformBuildSpecFluent.MavenNested<N>,Nested<N>{
    MavenNestedImpl(MavenSpec item) {
      this.builder = new MavenSpecBuilder(this, item);
    }
    MavenNestedImpl() {
      this.builder = new MavenSpecBuilder(this);
    }
    MavenSpecBuilder builder;
    public N and() {
      return (N) IntegrationPlatformBuildSpecFluentImpl.this.withMaven(builder.build());
    }
    public N endMaven() {
      return and();
    }
    
  }
  class RegistryNestedImpl<N> extends RegistrySpecFluentImpl<IntegrationPlatformBuildSpecFluent.RegistryNested<N>> implements IntegrationPlatformBuildSpecFluent.RegistryNested<N>,Nested<N>{
    RegistryNestedImpl(RegistrySpec item) {
      this.builder = new RegistrySpecBuilder(this, item);
    }
    RegistryNestedImpl() {
      this.builder = new RegistrySpecBuilder(this);
    }
    RegistrySpecBuilder builder;
    public N and() {
      return (N) IntegrationPlatformBuildSpecFluentImpl.this.withRegistry(builder.build());
    }
    public N endRegistry() {
      return and();
    }
    
  }
  
}