package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationPlatformBuildSpecBuilder extends IntegrationPlatformBuildSpecFluentImpl<IntegrationPlatformBuildSpecBuilder> implements VisitableBuilder<IntegrationPlatformBuildSpec,IntegrationPlatformBuildSpecBuilder>{
  public IntegrationPlatformBuildSpecBuilder() {
    this(false);
  }
  public IntegrationPlatformBuildSpecBuilder(Boolean validationEnabled) {
    this(new IntegrationPlatformBuildSpec(), validationEnabled);
  }
  public IntegrationPlatformBuildSpecBuilder(IntegrationPlatformBuildSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationPlatformBuildSpecBuilder(IntegrationPlatformBuildSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IntegrationPlatformBuildSpec(), validationEnabled);
  }
  public IntegrationPlatformBuildSpecBuilder(IntegrationPlatformBuildSpecFluent<?> fluent,IntegrationPlatformBuildSpec instance) {
    this(fluent, instance, false);
  }
  public IntegrationPlatformBuildSpecBuilder(IntegrationPlatformBuildSpecFluent<?> fluent,IntegrationPlatformBuildSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBaseImage(instance.getBaseImage()); 
    fluent.withBuildStrategy(instance.getBuildStrategy()); 
    fluent.withKanikoBuildCache(instance.getKanikoBuildCache()); 
    fluent.withMaven(instance.getMaven()); 
    fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
    fluent.withPublishStrategy(instance.getPublishStrategy()); 
    fluent.withRegistry(instance.getRegistry()); 
    fluent.withRuntimeProvider(instance.getRuntimeProvider()); 
    fluent.withRuntimeVersion(instance.getRuntimeVersion()); 
    fluent.withTimeout(instance.getTimeout()); 
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationPlatformBuildSpecBuilder(IntegrationPlatformBuildSpec instance) {
    this(instance,false);
  }
  public IntegrationPlatformBuildSpecBuilder(IntegrationPlatformBuildSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBaseImage(instance.getBaseImage()); 
    this.withBuildStrategy(instance.getBuildStrategy()); 
    this.withKanikoBuildCache(instance.getKanikoBuildCache()); 
    this.withMaven(instance.getMaven()); 
    this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
    this.withPublishStrategy(instance.getPublishStrategy()); 
    this.withRegistry(instance.getRegistry()); 
    this.withRuntimeProvider(instance.getRuntimeProvider()); 
    this.withRuntimeVersion(instance.getRuntimeVersion()); 
    this.withTimeout(instance.getTimeout()); 
    this.validationEnabled = validationEnabled; 
  }
  IntegrationPlatformBuildSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IntegrationPlatformBuildSpec build() {
    IntegrationPlatformBuildSpec buildable = new IntegrationPlatformBuildSpec(fluent.getBaseImage(),fluent.getBuildStrategy(),fluent.getKanikoBuildCache(),fluent.getMaven(),fluent.getPersistentVolumeClaim(),fluent.getPublishStrategy(),fluent.getRegistry(),fluent.getRuntimeProvider(),fluent.getRuntimeVersion(),fluent.getTimeout());
    return buildable;
  }
  
}