package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FailureRecoveryBuilder extends FailureRecoveryFluentImpl<FailureRecoveryBuilder> implements VisitableBuilder<FailureRecovery,FailureRecoveryBuilder>{
  public FailureRecoveryBuilder() {
    this(false);
  }
  public FailureRecoveryBuilder(Boolean validationEnabled) {
    this(new FailureRecovery(), validationEnabled);
  }
  public FailureRecoveryBuilder(FailureRecoveryFluent<?> fluent) {
    this(fluent, false);
  }
  public FailureRecoveryBuilder(FailureRecoveryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FailureRecovery(), validationEnabled);
  }
  public FailureRecoveryBuilder(FailureRecoveryFluent<?> fluent,FailureRecovery instance) {
    this(fluent, instance, false);
  }
  public FailureRecoveryBuilder(FailureRecoveryFluent<?> fluent,FailureRecovery instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAttempt(instance.getAttempt()); 
    fluent.withAttemptMax(instance.getAttemptMax()); 
    fluent.withAttemptTime(instance.getAttemptTime()); 
    this.validationEnabled = validationEnabled; 
  }
  public FailureRecoveryBuilder(FailureRecovery instance) {
    this(instance,false);
  }
  public FailureRecoveryBuilder(FailureRecovery instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAttempt(instance.getAttempt()); 
    this.withAttemptMax(instance.getAttemptMax()); 
    this.withAttemptTime(instance.getAttemptTime()); 
    this.validationEnabled = validationEnabled; 
  }
  FailureRecoveryFluent<?> fluent;
  Boolean validationEnabled;
  public FailureRecovery build() {
    FailureRecovery buildable = new FailureRecovery(fluent.getAttempt(),fluent.getAttemptMax(),fluent.getAttemptTime());
    return buildable;
  }
  
}