package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CamelLoaderFluentImpl<A extends CamelLoaderFluent<A>> extends BaseFluent<A> implements CamelLoaderFluent<A>{
  public CamelLoaderFluentImpl() {
  }
  public CamelLoaderFluentImpl(CamelLoader instance) {
    this.withArtifactId(instance.getArtifactId()); 
    this.withDependencies(instance.getDependencies()); 
    this.withGroupId(instance.getGroupId()); 
    this.withLanguages(instance.getLanguages()); 
    this.withVersion(instance.getVersion()); 
  }
  private String artifactId;
  private ArrayList<MavenArtifactBuilder> dependencies = new ArrayList<MavenArtifactBuilder>();
  private String groupId;
  private List<String> languages = new ArrayList<String>();
  private String version;
  public String getArtifactId() {
    return this.artifactId;
  }
  public A withArtifactId(String artifactId) {
    this.artifactId=artifactId; return (A) this;
  }
  public Boolean hasArtifactId() {
    return this.artifactId != null;
  }
  public A addToDependencies(Integer index,MavenArtifact item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(index >= 0 ? index : _visitables.get("dependencies").size(), builder);this.dependencies.add(index >= 0 ? index : dependencies.size(), builder); return (A)this;
  }
  public A setToDependencies(Integer index,MavenArtifact item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
    if (index < 0 || index >= _visitables.get("dependencies").size()) { _visitables.get("dependencies").add(builder); } else { _visitables.get("dependencies").set(index, builder);}
    if (index < 0 || index >= dependencies.size()) { dependencies.add(builder); } else { dependencies.set(index, builder);}
     return (A)this;
  }
  public A addToDependencies(io.fabric8.camelk.v1.MavenArtifact... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A addAllToDependencies(Collection<MavenArtifact> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A removeFromDependencies(io.fabric8.camelk.v1.MavenArtifact... items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<MavenArtifact> items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDependencies(Predicate<MavenArtifactBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<MavenArtifactBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      MavenArtifactBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MavenArtifact> getDependencies() {
    return dependencies != null ? build(dependencies) : null;
  }
  public List<MavenArtifact> buildDependencies() {
    return dependencies != null ? build(dependencies) : null;
  }
  public MavenArtifact buildDependency(Integer index) {
    return this.dependencies.get(index).build();
  }
  public MavenArtifact buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  public MavenArtifact buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  public MavenArtifact buildMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(List<MavenArtifact> dependencies) {
    if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
    if (dependencies != null) {this.dependencies = new ArrayList(); for (MavenArtifact item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(io.fabric8.camelk.v1.MavenArtifact... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (MavenArtifact item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public A addNewDependency(String artifactId,String groupId,String version) {
    return (A)addToDependencies(new MavenArtifact(artifactId, groupId, version));
  }
  public CamelLoaderFluent.DependenciesNested<A> addNewDependency() {
    return new CamelLoaderFluentImpl.DependenciesNestedImpl();
  }
  public CamelLoaderFluent.DependenciesNested<A> addNewDependencyLike(MavenArtifact item) {
    return new CamelLoaderFluentImpl.DependenciesNestedImpl(-1, item);
  }
  public CamelLoaderFluent.DependenciesNested<A> setNewDependencyLike(Integer index,MavenArtifact item) {
    return new CamelLoaderFluentImpl.DependenciesNestedImpl(index, item);
  }
  public CamelLoaderFluent.DependenciesNested<A> editDependency(Integer index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public CamelLoaderFluent.DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  public CamelLoaderFluent.DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public CamelLoaderFluent.DependenciesNested<A> editMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public String getGroupId() {
    return this.groupId;
  }
  public A withGroupId(String groupId) {
    this.groupId=groupId; return (A) this;
  }
  public Boolean hasGroupId() {
    return this.groupId != null;
  }
  public A addToLanguages(Integer index,String item) {
    if (this.languages == null) {this.languages = new ArrayList<String>();}
    this.languages.add(index, item);
    return (A)this;
  }
  public A setToLanguages(Integer index,String item) {
    if (this.languages == null) {this.languages = new ArrayList<String>();}
    this.languages.set(index, item); return (A)this;
  }
  public A addToLanguages(java.lang.String... items) {
    if (this.languages == null) {this.languages = new ArrayList<String>();}
    for (String item : items) {this.languages.add(item);} return (A)this;
  }
  public A addAllToLanguages(Collection<String> items) {
    if (this.languages == null) {this.languages = new ArrayList<String>();}
    for (String item : items) {this.languages.add(item);} return (A)this;
  }
  public A removeFromLanguages(java.lang.String... items) {
    for (String item : items) {if (this.languages!= null){ this.languages.remove(item);}} return (A)this;
  }
  public A removeAllFromLanguages(Collection<String> items) {
    for (String item : items) {if (this.languages!= null){ this.languages.remove(item);}} return (A)this;
  }
  public List<String> getLanguages() {
    return this.languages;
  }
  public String getLanguage(Integer index) {
    return this.languages.get(index);
  }
  public String getFirstLanguage() {
    return this.languages.get(0);
  }
  public String getLastLanguage() {
    return this.languages.get(languages.size() - 1);
  }
  public String getMatchingLanguage(Predicate<String> predicate) {
    for (String item: languages) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingLanguage(Predicate<String> predicate) {
    for (String item: languages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLanguages(List<String> languages) {
    if (languages != null) {this.languages = new ArrayList(); for (String item : languages){this.addToLanguages(item);}} else { this.languages = null;} return (A) this;
  }
  public A withLanguages(java.lang.String... languages) {
    if (this.languages != null) {this.languages.clear();}
    if (languages != null) {for (String item :languages){ this.addToLanguages(item);}} return (A) this;
  }
  public Boolean hasLanguages() {
    return languages != null && !languages.isEmpty();
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CamelLoaderFluentImpl that = (CamelLoaderFluentImpl) o;
    if (artifactId != null ? !artifactId.equals(that.artifactId) :that.artifactId != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (groupId != null ? !groupId.equals(that.groupId) :that.groupId != null) return false;
    if (languages != null ? !languages.equals(that.languages) :that.languages != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(artifactId,  dependencies,  groupId,  languages,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (artifactId != null) { sb.append("artifactId:"); sb.append(artifactId + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (groupId != null) { sb.append("groupId:"); sb.append(groupId + ","); }
    if (languages != null && !languages.isEmpty()) { sb.append("languages:"); sb.append(languages + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class DependenciesNestedImpl<N> extends MavenArtifactFluentImpl<CamelLoaderFluent.DependenciesNested<N>> implements CamelLoaderFluent.DependenciesNested<N>,Nested<N>{
    DependenciesNestedImpl(Integer index,MavenArtifact item) {
      this.index = index;
      this.builder = new MavenArtifactBuilder(this, item);
    }
    DependenciesNestedImpl() {
      this.index = -1;
      this.builder = new MavenArtifactBuilder(this);
    }
    MavenArtifactBuilder builder;
    Integer index;
    public N and() {
      return (N) CamelLoaderFluentImpl.this.setToDependencies(index,builder.build());
    }
    public N endDependency() {
      return and();
    }
    
  }
  
}