package io.fabric8.camelk.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CamelCatalogSpecFluentImpl<A extends CamelCatalogSpecFluent<A>> extends BaseFluent<A> implements CamelCatalogSpecFluent<A>{
  public CamelCatalogSpecFluentImpl() {
  }
  public CamelCatalogSpecFluentImpl(CamelCatalogSpec instance) {
    this.withArtifacts(instance.getArtifacts()); 
    this.withLoaders(instance.getLoaders()); 
    this.withRuntime(instance.getRuntime()); 
  }
  private Map<String,CamelArtifact> artifacts;
  private Map<String,CamelLoader> loaders;
  private RuntimeSpecBuilder runtime;
  public A addToArtifacts(String key,CamelArtifact value) {
    if(this.artifacts == null && key != null && value != null) { this.artifacts = new LinkedHashMap(); }
    if(key != null && value != null) {this.artifacts.put(key, value);} return (A)this;
  }
  public A addToArtifacts(Map<String,CamelArtifact> map) {
    if(this.artifacts == null && map != null) { this.artifacts = new LinkedHashMap(); }
    if(map != null) { this.artifacts.putAll(map);} return (A)this;
  }
  public A removeFromArtifacts(String key) {
    if(this.artifacts == null) { return (A) this; }
    if(key != null && this.artifacts != null) {this.artifacts.remove(key);} return (A)this;
  }
  public A removeFromArtifacts(Map<String,CamelArtifact> map) {
    if(this.artifacts == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.artifacts != null){this.artifacts.remove(key);}}} return (A)this;
  }
  public Map<String,CamelArtifact> getArtifacts() {
    return this.artifacts;
  }
  public <K,V>A withArtifacts(Map<String,CamelArtifact> artifacts) {
    if (artifacts == null) { this.artifacts =  null;} else {this.artifacts = new LinkedHashMap(artifacts);} return (A) this;
  }
  public Boolean hasArtifacts() {
    return this.artifacts != null;
  }
  public A addToLoaders(String key,CamelLoader value) {
    if(this.loaders == null && key != null && value != null) { this.loaders = new LinkedHashMap(); }
    if(key != null && value != null) {this.loaders.put(key, value);} return (A)this;
  }
  public A addToLoaders(Map<String,CamelLoader> map) {
    if(this.loaders == null && map != null) { this.loaders = new LinkedHashMap(); }
    if(map != null) { this.loaders.putAll(map);} return (A)this;
  }
  public A removeFromLoaders(String key) {
    if(this.loaders == null) { return (A) this; }
    if(key != null && this.loaders != null) {this.loaders.remove(key);} return (A)this;
  }
  public A removeFromLoaders(Map<String,CamelLoader> map) {
    if(this.loaders == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.loaders != null){this.loaders.remove(key);}}} return (A)this;
  }
  public Map<String,CamelLoader> getLoaders() {
    return this.loaders;
  }
  public <K,V>A withLoaders(Map<String,CamelLoader> loaders) {
    if (loaders == null) { this.loaders =  null;} else {this.loaders = new LinkedHashMap(loaders);} return (A) this;
  }
  public Boolean hasLoaders() {
    return this.loaders != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRuntime instead.
   * @return The buildable object.
   */
  @Deprecated
  public RuntimeSpec getRuntime() {
    return this.runtime!=null ?this.runtime.build():null;
  }
  public RuntimeSpec buildRuntime() {
    return this.runtime!=null ?this.runtime.build():null;
  }
  public A withRuntime(RuntimeSpec runtime) {
    _visitables.get("runtime").remove(this.runtime);
    if (runtime!=null){ this.runtime= new RuntimeSpecBuilder(runtime); _visitables.get("runtime").add(this.runtime);} else { this.runtime = null; _visitables.get("runtime").remove(this.runtime); } return (A) this;
  }
  public Boolean hasRuntime() {
    return this.runtime != null;
  }
  public CamelCatalogSpecFluent.RuntimeNested<A> withNewRuntime() {
    return new CamelCatalogSpecFluentImpl.RuntimeNestedImpl();
  }
  public CamelCatalogSpecFluent.RuntimeNested<A> withNewRuntimeLike(RuntimeSpec item) {
    return new CamelCatalogSpecFluentImpl.RuntimeNestedImpl(item);
  }
  public CamelCatalogSpecFluent.RuntimeNested<A> editRuntime() {
    return withNewRuntimeLike(getRuntime());
  }
  public CamelCatalogSpecFluent.RuntimeNested<A> editOrNewRuntime() {
    return withNewRuntimeLike(getRuntime() != null ? getRuntime(): new RuntimeSpecBuilder().build());
  }
  public CamelCatalogSpecFluent.RuntimeNested<A> editOrNewRuntimeLike(RuntimeSpec item) {
    return withNewRuntimeLike(getRuntime() != null ? getRuntime(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CamelCatalogSpecFluentImpl that = (CamelCatalogSpecFluentImpl) o;
    if (artifacts != null ? !artifacts.equals(that.artifacts) :that.artifacts != null) return false;
    if (loaders != null ? !loaders.equals(that.loaders) :that.loaders != null) return false;
    if (runtime != null ? !runtime.equals(that.runtime) :that.runtime != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(artifacts,  loaders,  runtime,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (artifacts != null && !artifacts.isEmpty()) { sb.append("artifacts:"); sb.append(artifacts + ","); }
    if (loaders != null && !loaders.isEmpty()) { sb.append("loaders:"); sb.append(loaders + ","); }
    if (runtime != null) { sb.append("runtime:"); sb.append(runtime); }
    sb.append("}");
    return sb.toString();
  }
  class RuntimeNestedImpl<N> extends RuntimeSpecFluentImpl<CamelCatalogSpecFluent.RuntimeNested<N>> implements CamelCatalogSpecFluent.RuntimeNested<N>,Nested<N>{
    RuntimeNestedImpl(RuntimeSpec item) {
      this.builder = new RuntimeSpecBuilder(this, item);
    }
    RuntimeNestedImpl() {
      this.builder = new RuntimeSpecBuilder(this);
    }
    RuntimeSpecBuilder builder;
    public N and() {
      return (N) CamelCatalogSpecFluentImpl.this.withRuntime(builder.build());
    }
    public N endRuntime() {
      return and();
    }
    
  }
  
}