package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CamelArtifactDependencyFluentImpl<A extends CamelArtifactDependencyFluent<A>> extends BaseFluent<A> implements CamelArtifactDependencyFluent<A>{
  public CamelArtifactDependencyFluentImpl() {
  }
  public CamelArtifactDependencyFluentImpl(CamelArtifactDependency instance) {
    this.withArtifactId(instance.getArtifactId()); 
    this.withExclusions(instance.getExclusions()); 
    this.withGroupId(instance.getGroupId()); 
    this.withVersion(instance.getVersion()); 
  }
  private String artifactId;
  private ArrayList<CamelArtifactExclusionBuilder> exclusions = new ArrayList<CamelArtifactExclusionBuilder>();
  private String groupId;
  private String version;
  public String getArtifactId() {
    return this.artifactId;
  }
  public A withArtifactId(String artifactId) {
    this.artifactId=artifactId; return (A) this;
  }
  public Boolean hasArtifactId() {
    return this.artifactId != null;
  }
  public A addToExclusions(Integer index,CamelArtifactExclusion item) {
    if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
    CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(index >= 0 ? index : _visitables.get("exclusions").size(), builder);this.exclusions.add(index >= 0 ? index : exclusions.size(), builder); return (A)this;
  }
  public A setToExclusions(Integer index,CamelArtifactExclusion item) {
    if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
    CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);
    if (index < 0 || index >= _visitables.get("exclusions").size()) { _visitables.get("exclusions").add(builder); } else { _visitables.get("exclusions").set(index, builder);}
    if (index < 0 || index >= exclusions.size()) { exclusions.add(builder); } else { exclusions.set(index, builder);}
     return (A)this;
  }
  public A addToExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items) {
    if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
    for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(builder);this.exclusions.add(builder);} return (A)this;
  }
  public A addAllToExclusions(Collection<CamelArtifactExclusion> items) {
    if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
    for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(builder);this.exclusions.add(builder);} return (A)this;
  }
  public A removeFromExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items) {
    for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").remove(builder);if (this.exclusions != null) {this.exclusions.remove(builder);}} return (A)this;
  }
  public A removeAllFromExclusions(Collection<CamelArtifactExclusion> items) {
    for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").remove(builder);if (this.exclusions != null) {this.exclusions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExclusions(Predicate<CamelArtifactExclusionBuilder> predicate) {
    if (exclusions == null) return (A) this;
    final Iterator<CamelArtifactExclusionBuilder> each = exclusions.iterator();
    final List visitables = _visitables.get("exclusions");
    while (each.hasNext()) {
      CamelArtifactExclusionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExclusions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CamelArtifactExclusion> getExclusions() {
    return exclusions != null ? build(exclusions) : null;
  }
  public List<CamelArtifactExclusion> buildExclusions() {
    return exclusions != null ? build(exclusions) : null;
  }
  public CamelArtifactExclusion buildExclusion(Integer index) {
    return this.exclusions.get(index).build();
  }
  public CamelArtifactExclusion buildFirstExclusion() {
    return this.exclusions.get(0).build();
  }
  public CamelArtifactExclusion buildLastExclusion() {
    return this.exclusions.get(exclusions.size() - 1).build();
  }
  public CamelArtifactExclusion buildMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
    for (CamelArtifactExclusionBuilder item: exclusions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
    for (CamelArtifactExclusionBuilder item: exclusions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExclusions(List<CamelArtifactExclusion> exclusions) {
    if (this.exclusions != null) { _visitables.get("exclusions").removeAll(this.exclusions);}
    if (exclusions != null) {this.exclusions = new ArrayList(); for (CamelArtifactExclusion item : exclusions){this.addToExclusions(item);}} else { this.exclusions = null;} return (A) this;
  }
  public A withExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... exclusions) {
    if (this.exclusions != null) {this.exclusions.clear();}
    if (exclusions != null) {for (CamelArtifactExclusion item :exclusions){ this.addToExclusions(item);}} return (A) this;
  }
  public Boolean hasExclusions() {
    return exclusions != null && !exclusions.isEmpty();
  }
  public A addNewExclusion(String artifactId,String groupId) {
    return (A)addToExclusions(new CamelArtifactExclusion(artifactId, groupId));
  }
  public CamelArtifactDependencyFluent.ExclusionsNested<A> addNewExclusion() {
    return new CamelArtifactDependencyFluentImpl.ExclusionsNestedImpl();
  }
  public CamelArtifactDependencyFluent.ExclusionsNested<A> addNewExclusionLike(CamelArtifactExclusion item) {
    return new CamelArtifactDependencyFluentImpl.ExclusionsNestedImpl(-1, item);
  }
  public CamelArtifactDependencyFluent.ExclusionsNested<A> setNewExclusionLike(Integer index,CamelArtifactExclusion item) {
    return new CamelArtifactDependencyFluentImpl.ExclusionsNestedImpl(index, item);
  }
  public CamelArtifactDependencyFluent.ExclusionsNested<A> editExclusion(Integer index) {
    if (exclusions.size() <= index) throw new RuntimeException("Can't edit exclusions. Index exceeds size.");
    return setNewExclusionLike(index, buildExclusion(index));
  }
  public CamelArtifactDependencyFluent.ExclusionsNested<A> editFirstExclusion() {
    if (exclusions.size() == 0) throw new RuntimeException("Can't edit first exclusions. The list is empty.");
    return setNewExclusionLike(0, buildExclusion(0));
  }
  public CamelArtifactDependencyFluent.ExclusionsNested<A> editLastExclusion() {
    int index = exclusions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last exclusions. The list is empty.");
    return setNewExclusionLike(index, buildExclusion(index));
  }
  public CamelArtifactDependencyFluent.ExclusionsNested<A> editMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<exclusions.size();i++) { 
    if (predicate.test(exclusions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching exclusions. No match found.");
    return setNewExclusionLike(index, buildExclusion(index));
  }
  public String getGroupId() {
    return this.groupId;
  }
  public A withGroupId(String groupId) {
    this.groupId=groupId; return (A) this;
  }
  public Boolean hasGroupId() {
    return this.groupId != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CamelArtifactDependencyFluentImpl that = (CamelArtifactDependencyFluentImpl) o;
    if (artifactId != null ? !artifactId.equals(that.artifactId) :that.artifactId != null) return false;
    if (exclusions != null ? !exclusions.equals(that.exclusions) :that.exclusions != null) return false;
    if (groupId != null ? !groupId.equals(that.groupId) :that.groupId != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(artifactId,  exclusions,  groupId,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (artifactId != null) { sb.append("artifactId:"); sb.append(artifactId + ","); }
    if (exclusions != null && !exclusions.isEmpty()) { sb.append("exclusions:"); sb.append(exclusions + ","); }
    if (groupId != null) { sb.append("groupId:"); sb.append(groupId + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class ExclusionsNestedImpl<N> extends CamelArtifactExclusionFluentImpl<CamelArtifactDependencyFluent.ExclusionsNested<N>> implements CamelArtifactDependencyFluent.ExclusionsNested<N>,Nested<N>{
    ExclusionsNestedImpl(Integer index,CamelArtifactExclusion item) {
      this.index = index;
      this.builder = new CamelArtifactExclusionBuilder(this, item);
    }
    ExclusionsNestedImpl() {
      this.index = -1;
      this.builder = new CamelArtifactExclusionBuilder(this);
    }
    CamelArtifactExclusionBuilder builder;
    Integer index;
    public N and() {
      return (N) CamelArtifactDependencyFluentImpl.this.setToExclusions(index,builder.build());
    }
    public N endExclusion() {
      return and();
    }
    
  }
  
}