package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskBuilder extends TaskFluentImpl<TaskBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.Task,io.fabric8.camelk.v1.TaskBuilder>{
  public TaskBuilder() {
    this(false);
  }
  public TaskBuilder(Boolean validationEnabled) {
    this(new Task(), validationEnabled);
  }
  public TaskBuilder(TaskFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskBuilder(io.fabric8.camelk.v1.TaskFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Task(), validationEnabled);
  }
  public TaskBuilder(io.fabric8.camelk.v1.TaskFluent<?> fluent,io.fabric8.camelk.v1.Task instance) {
    this(fluent, instance, false);
  }
  public TaskBuilder(io.fabric8.camelk.v1.TaskFluent<?> fluent,io.fabric8.camelk.v1.Task instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBuildah(instance.getBuildah()); 
    fluent.withBuilder(instance.getBuilder()); 
    fluent.withKaniko(instance.getKaniko()); 
    fluent.withS2i(instance.getS2i()); 
    fluent.withSpectrum(instance.getSpectrum()); 
    this.validationEnabled = validationEnabled; 
  }
  public TaskBuilder(io.fabric8.camelk.v1.Task instance) {
    this(instance,false);
  }
  public TaskBuilder(io.fabric8.camelk.v1.Task instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBuildah(instance.getBuildah()); 
    this.withBuilder(instance.getBuilder()); 
    this.withKaniko(instance.getKaniko()); 
    this.withS2i(instance.getS2i()); 
    this.withSpectrum(instance.getSpectrum()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.TaskFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.Task build() {
    Task buildable = new Task(fluent.getBuildah(),fluent.getBuilder(),fluent.getKaniko(),fluent.getS2i(),fluent.getSpectrum());
    return buildable;
  }
  
}