package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SpectrumTaskBuilder extends SpectrumTaskFluentImpl<SpectrumTaskBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.SpectrumTask,io.fabric8.camelk.v1.SpectrumTaskBuilder>{
  public SpectrumTaskBuilder() {
    this(false);
  }
  public SpectrumTaskBuilder(Boolean validationEnabled) {
    this(new SpectrumTask(), validationEnabled);
  }
  public SpectrumTaskBuilder(SpectrumTaskFluent<?> fluent) {
    this(fluent, false);
  }
  public SpectrumTaskBuilder(io.fabric8.camelk.v1.SpectrumTaskFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SpectrumTask(), validationEnabled);
  }
  public SpectrumTaskBuilder(io.fabric8.camelk.v1.SpectrumTaskFluent<?> fluent,io.fabric8.camelk.v1.SpectrumTask instance) {
    this(fluent, instance, false);
  }
  public SpectrumTaskBuilder(io.fabric8.camelk.v1.SpectrumTaskFluent<?> fluent,io.fabric8.camelk.v1.SpectrumTask instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBaseImage(instance.getBaseImage()); 
    fluent.withContextDir(instance.getContextDir()); 
    fluent.withImage(instance.getImage()); 
    fluent.withName(instance.getName()); 
    fluent.withRegistry(instance.getRegistry()); 
    this.validationEnabled = validationEnabled; 
  }
  public SpectrumTaskBuilder(io.fabric8.camelk.v1.SpectrumTask instance) {
    this(instance,false);
  }
  public SpectrumTaskBuilder(io.fabric8.camelk.v1.SpectrumTask instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBaseImage(instance.getBaseImage()); 
    this.withContextDir(instance.getContextDir()); 
    this.withImage(instance.getImage()); 
    this.withName(instance.getName()); 
    this.withRegistry(instance.getRegistry()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.SpectrumTaskFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.SpectrumTask build() {
    SpectrumTask buildable = new SpectrumTask(fluent.getBaseImage(),fluent.getContextDir(),fluent.getImage(),fluent.getName(),fluent.getRegistry());
    return buildable;
  }
  
}