package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceSpecBuilder extends SourceSpecFluentImpl<SourceSpecBuilder> implements VisitableBuilder<SourceSpec,io.fabric8.camelk.v1.SourceSpecBuilder>{
  public SourceSpecBuilder() {
    this(false);
  }
  public SourceSpecBuilder(Boolean validationEnabled) {
    this(new SourceSpec(), validationEnabled);
  }
  public SourceSpecBuilder(SourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceSpecBuilder(io.fabric8.camelk.v1.SourceSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SourceSpec(), validationEnabled);
  }
  public SourceSpecBuilder(io.fabric8.camelk.v1.SourceSpecFluent<?> fluent,io.fabric8.camelk.v1.SourceSpec instance) {
    this(fluent, instance, false);
  }
  public SourceSpecBuilder(io.fabric8.camelk.v1.SourceSpecFluent<?> fluent,io.fabric8.camelk.v1.SourceSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCompression(instance.getCompression()); 
    fluent.withContent(instance.getContent()); 
    fluent.withContentKey(instance.getContentKey()); 
    fluent.withContentRef(instance.getContentRef()); 
    fluent.withContentType(instance.getContentType()); 
    fluent.withInterceptors(instance.getInterceptors()); 
    fluent.withLanguage(instance.getLanguage()); 
    fluent.withLoader(instance.getLoader()); 
    fluent.withName(instance.getName()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPropertyNames(instance.getPropertyNames()); 
    fluent.withRawContent(instance.getRawContent()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public SourceSpecBuilder(io.fabric8.camelk.v1.SourceSpec instance) {
    this(instance,false);
  }
  public SourceSpecBuilder(io.fabric8.camelk.v1.SourceSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCompression(instance.getCompression()); 
    this.withContent(instance.getContent()); 
    this.withContentKey(instance.getContentKey()); 
    this.withContentRef(instance.getContentRef()); 
    this.withContentType(instance.getContentType()); 
    this.withInterceptors(instance.getInterceptors()); 
    this.withLanguage(instance.getLanguage()); 
    this.withLoader(instance.getLoader()); 
    this.withName(instance.getName()); 
    this.withPath(instance.getPath()); 
    this.withPropertyNames(instance.getPropertyNames()); 
    this.withRawContent(instance.getRawContent()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.SourceSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.SourceSpec build() {
    SourceSpec buildable = new SourceSpec(fluent.getCompression(),fluent.getContent(),fluent.getContentKey(),fluent.getContentRef(),fluent.getContentType(),fluent.getInterceptors(),fluent.getLanguage(),fluent.getLoader(),fluent.getName(),fluent.getPath(),fluent.getPropertyNames(),fluent.getRawContent(),fluent.getType());
    return buildable;
  }
  
}