package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RuntimeSpecFluentImpl<A extends RuntimeSpecFluent<A>> extends BaseFluent<A> implements RuntimeSpecFluent<A>{
  public RuntimeSpecFluentImpl() {
  }
  public RuntimeSpecFluentImpl(io.fabric8.camelk.v1.RuntimeSpec instance) {
    this.withApplicationClass(instance.getApplicationClass()); 
    this.withCapabilities(instance.getCapabilities()); 
    this.withDependencies(instance.getDependencies()); 
    this.withMetadata(instance.getMetadata()); 
    this.withProvider(instance.getProvider()); 
    this.withVersion(instance.getVersion()); 
  }
  private String applicationClass;
  private Map<java.lang.String,Capability> capabilities;
  private ArrayList<MavenArtifactBuilder> dependencies = new java.util.ArrayList<MavenArtifactBuilder>();
  private java.util.Map<java.lang.String,java.lang.String> metadata;
  private java.lang.String provider;
  private java.lang.String version;
  public java.lang.String getApplicationClass() {
    return this.applicationClass;
  }
  public A withApplicationClass(java.lang.String applicationClass) {
    this.applicationClass=applicationClass; return (A) this;
  }
  public Boolean hasApplicationClass() {
    return this.applicationClass != null;
  }
  public A addToCapabilities(java.lang.String key,io.fabric8.camelk.v1.Capability value) {
    if(this.capabilities == null && key != null && value != null) { this.capabilities = new LinkedHashMap(); }
    if(key != null && value != null) {this.capabilities.put(key, value);} return (A)this;
  }
  public A addToCapabilities(java.util.Map<java.lang.String,io.fabric8.camelk.v1.Capability> map) {
    if(this.capabilities == null && map != null) { this.capabilities = new java.util.LinkedHashMap(); }
    if(map != null) { this.capabilities.putAll(map);} return (A)this;
  }
  public A removeFromCapabilities(java.lang.String key) {
    if(this.capabilities == null) { return (A) this; }
    if(key != null && this.capabilities != null) {this.capabilities.remove(key);} return (A)this;
  }
  public A removeFromCapabilities(java.util.Map<java.lang.String,io.fabric8.camelk.v1.Capability> map) {
    if(this.capabilities == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capabilities != null){this.capabilities.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.camelk.v1.Capability> getCapabilities() {
    return this.capabilities;
  }
  public <K,V>A withCapabilities(java.util.Map<java.lang.String,io.fabric8.camelk.v1.Capability> capabilities) {
    if (capabilities == null) { this.capabilities =  null;} else {this.capabilities = new java.util.LinkedHashMap(capabilities);} return (A) this;
  }
  public java.lang.Boolean hasCapabilities() {
    return this.capabilities != null;
  }
  public A addToDependencies(Integer index,io.fabric8.camelk.v1.MavenArtifact item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.fabric8.camelk.v1.MavenArtifactBuilder>();}
    io.fabric8.camelk.v1.MavenArtifactBuilder builder = new io.fabric8.camelk.v1.MavenArtifactBuilder(item);_visitables.get("dependencies").add(index >= 0 ? index : _visitables.get("dependencies").size(), builder);this.dependencies.add(index >= 0 ? index : dependencies.size(), builder); return (A)this;
  }
  public A setToDependencies(java.lang.Integer index,io.fabric8.camelk.v1.MavenArtifact item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.fabric8.camelk.v1.MavenArtifactBuilder>();}
    io.fabric8.camelk.v1.MavenArtifactBuilder builder = new io.fabric8.camelk.v1.MavenArtifactBuilder(item);
    if (index < 0 || index >= _visitables.get("dependencies").size()) { _visitables.get("dependencies").add(builder); } else { _visitables.get("dependencies").set(index, builder);}
    if (index < 0 || index >= dependencies.size()) { dependencies.add(builder); } else { dependencies.set(index, builder);}
     return (A)this;
  }
  public A addToDependencies(io.fabric8.camelk.v1.MavenArtifact... items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.fabric8.camelk.v1.MavenArtifactBuilder>();}
    for (io.fabric8.camelk.v1.MavenArtifact item : items) {io.fabric8.camelk.v1.MavenArtifactBuilder builder = new io.fabric8.camelk.v1.MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A addAllToDependencies(Collection<io.fabric8.camelk.v1.MavenArtifact> items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.fabric8.camelk.v1.MavenArtifactBuilder>();}
    for (io.fabric8.camelk.v1.MavenArtifact item : items) {io.fabric8.camelk.v1.MavenArtifactBuilder builder = new io.fabric8.camelk.v1.MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A removeFromDependencies(io.fabric8.camelk.v1.MavenArtifact... items) {
    for (io.fabric8.camelk.v1.MavenArtifact item : items) {io.fabric8.camelk.v1.MavenArtifactBuilder builder = new io.fabric8.camelk.v1.MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeAllFromDependencies(java.util.Collection<io.fabric8.camelk.v1.MavenArtifact> items) {
    for (io.fabric8.camelk.v1.MavenArtifact item : items) {io.fabric8.camelk.v1.MavenArtifactBuilder builder = new io.fabric8.camelk.v1.MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDependencies(Predicate<io.fabric8.camelk.v1.MavenArtifactBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.MavenArtifactBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.MavenArtifactBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.camelk.v1.MavenArtifact> getDependencies() {
    return dependencies != null ? build(dependencies) : null;
  }
  public java.util.List<io.fabric8.camelk.v1.MavenArtifact> buildDependencies() {
    return dependencies != null ? build(dependencies) : null;
  }
  public io.fabric8.camelk.v1.MavenArtifact buildDependency(java.lang.Integer index) {
    return this.dependencies.get(index).build();
  }
  public io.fabric8.camelk.v1.MavenArtifact buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  public io.fabric8.camelk.v1.MavenArtifact buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  public io.fabric8.camelk.v1.MavenArtifact buildMatchingDependency(java.util.function.Predicate<io.fabric8.camelk.v1.MavenArtifactBuilder> predicate) {
    for (io.fabric8.camelk.v1.MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingDependency(java.util.function.Predicate<io.fabric8.camelk.v1.MavenArtifactBuilder> predicate) {
    for (io.fabric8.camelk.v1.MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(java.util.List<io.fabric8.camelk.v1.MavenArtifact> dependencies) {
    if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
    if (dependencies != null) {this.dependencies = new java.util.ArrayList(); for (io.fabric8.camelk.v1.MavenArtifact item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(io.fabric8.camelk.v1.MavenArtifact... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (io.fabric8.camelk.v1.MavenArtifact item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public java.lang.Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public A addNewDependency(java.lang.String artifactId,java.lang.String groupId,java.lang.String version) {
    return (A)addToDependencies(new MavenArtifact(artifactId, groupId, version));
  }
  public RuntimeSpecFluent.DependenciesNested<A> addNewDependency() {
    return new RuntimeSpecFluentImpl.DependenciesNestedImpl();
  }
  public io.fabric8.camelk.v1.RuntimeSpecFluent.DependenciesNested<A> addNewDependencyLike(io.fabric8.camelk.v1.MavenArtifact item) {
    return new RuntimeSpecFluentImpl.DependenciesNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.RuntimeSpecFluent.DependenciesNested<A> setNewDependencyLike(java.lang.Integer index,io.fabric8.camelk.v1.MavenArtifact item) {
    return new io.fabric8.camelk.v1.RuntimeSpecFluentImpl.DependenciesNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.RuntimeSpecFluent.DependenciesNested<A> editDependency(java.lang.Integer index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public io.fabric8.camelk.v1.RuntimeSpecFluent.DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  public io.fabric8.camelk.v1.RuntimeSpecFluent.DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public io.fabric8.camelk.v1.RuntimeSpecFluent.DependenciesNested<A> editMatchingDependency(java.util.function.Predicate<io.fabric8.camelk.v1.MavenArtifactBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public A addToMetadata(java.lang.String key,java.lang.String value) {
    if(this.metadata == null && key != null && value != null) { this.metadata = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.metadata.put(key, value);} return (A)this;
  }
  public A addToMetadata(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.metadata == null && map != null) { this.metadata = new java.util.LinkedHashMap(); }
    if(map != null) { this.metadata.putAll(map);} return (A)this;
  }
  public A removeFromMetadata(java.lang.String key) {
    if(this.metadata == null) { return (A) this; }
    if(key != null && this.metadata != null) {this.metadata.remove(key);} return (A)this;
  }
  public A removeFromMetadata(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.metadata == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.metadata != null){this.metadata.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getMetadata() {
    return this.metadata;
  }
  public <K,V>A withMetadata(java.util.Map<java.lang.String,java.lang.String> metadata) {
    if (metadata == null) { this.metadata =  null;} else {this.metadata = new java.util.LinkedHashMap(metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public java.lang.String getProvider() {
    return this.provider;
  }
  public A withProvider(java.lang.String provider) {
    this.provider=provider; return (A) this;
  }
  public java.lang.Boolean hasProvider() {
    return this.provider != null;
  }
  public java.lang.String getVersion() {
    return this.version;
  }
  public A withVersion(java.lang.String version) {
    this.version=version; return (A) this;
  }
  public java.lang.Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RuntimeSpecFluentImpl that = (RuntimeSpecFluentImpl) o;
    if (applicationClass != null ? !applicationClass.equals(that.applicationClass) :that.applicationClass != null) return false;
    if (capabilities != null ? !capabilities.equals(that.capabilities) :that.capabilities != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (provider != null ? !provider.equals(that.provider) :that.provider != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(applicationClass,  capabilities,  dependencies,  metadata,  provider,  version,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (applicationClass != null) { sb.append("applicationClass:"); sb.append(applicationClass + ","); }
    if (capabilities != null && !capabilities.isEmpty()) { sb.append("capabilities:"); sb.append(capabilities + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (metadata != null && !metadata.isEmpty()) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (provider != null) { sb.append("provider:"); sb.append(provider + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class DependenciesNestedImpl<N> extends MavenArtifactFluentImpl<RuntimeSpecFluent.DependenciesNested<N>> implements io.fabric8.camelk.v1.RuntimeSpecFluent.DependenciesNested<N>,Nested<N>{
    DependenciesNestedImpl(java.lang.Integer index,MavenArtifact item) {
      this.index = index;
      this.builder = new MavenArtifactBuilder(this, item);
    }
    DependenciesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.MavenArtifactBuilder(this);
    }
    io.fabric8.camelk.v1.MavenArtifactBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) RuntimeSpecFluentImpl.this.setToDependencies(index,builder.build());
    }
    public N endDependency() {
      return and();
    }
    
  }
  
}