package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RepositoryBuilder extends RepositoryFluentImpl<RepositoryBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.Repository,io.fabric8.camelk.v1.RepositoryBuilder>{
  public RepositoryBuilder() {
    this(false);
  }
  public RepositoryBuilder(Boolean validationEnabled) {
    this(new Repository(), validationEnabled);
  }
  public RepositoryBuilder(RepositoryFluent<?> fluent) {
    this(fluent, false);
  }
  public RepositoryBuilder(io.fabric8.camelk.v1.RepositoryFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Repository(), validationEnabled);
  }
  public RepositoryBuilder(io.fabric8.camelk.v1.RepositoryFluent<?> fluent,io.fabric8.camelk.v1.Repository instance) {
    this(fluent, instance, false);
  }
  public RepositoryBuilder(io.fabric8.camelk.v1.RepositoryFluent<?> fluent,io.fabric8.camelk.v1.Repository instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withId(instance.getId()); 
    fluent.withName(instance.getName()); 
    fluent.withReleases(instance.getReleases()); 
    fluent.withSnapshots(instance.getSnapshots()); 
    fluent.withUrl(instance.getUrl()); 
    this.validationEnabled = validationEnabled; 
  }
  public RepositoryBuilder(io.fabric8.camelk.v1.Repository instance) {
    this(instance,false);
  }
  public RepositoryBuilder(io.fabric8.camelk.v1.Repository instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withId(instance.getId()); 
    this.withName(instance.getName()); 
    this.withReleases(instance.getReleases()); 
    this.withSnapshots(instance.getSnapshots()); 
    this.withUrl(instance.getUrl()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.RepositoryFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.Repository build() {
    Repository buildable = new Repository(fluent.getId(),fluent.getName(),fluent.getReleases(),fluent.getSnapshots(),fluent.getUrl());
    return buildable;
  }
  
}