package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RegistrySpecBuilder extends RegistrySpecFluentImpl<RegistrySpecBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.RegistrySpec,io.fabric8.camelk.v1.RegistrySpecBuilder>{
  public RegistrySpecBuilder() {
    this(false);
  }
  public RegistrySpecBuilder(Boolean validationEnabled) {
    this(new RegistrySpec(), validationEnabled);
  }
  public RegistrySpecBuilder(RegistrySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RegistrySpecBuilder(io.fabric8.camelk.v1.RegistrySpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RegistrySpec(), validationEnabled);
  }
  public RegistrySpecBuilder(io.fabric8.camelk.v1.RegistrySpecFluent<?> fluent,io.fabric8.camelk.v1.RegistrySpec instance) {
    this(fluent, instance, false);
  }
  public RegistrySpecBuilder(io.fabric8.camelk.v1.RegistrySpecFluent<?> fluent,io.fabric8.camelk.v1.RegistrySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddress(instance.getAddress()); 
    fluent.withCa(instance.getCa()); 
    fluent.withInsecure(instance.getInsecure()); 
    fluent.withOrganization(instance.getOrganization()); 
    fluent.withSecret(instance.getSecret()); 
    this.validationEnabled = validationEnabled; 
  }
  public RegistrySpecBuilder(io.fabric8.camelk.v1.RegistrySpec instance) {
    this(instance,false);
  }
  public RegistrySpecBuilder(io.fabric8.camelk.v1.RegistrySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddress(instance.getAddress()); 
    this.withCa(instance.getCa()); 
    this.withInsecure(instance.getInsecure()); 
    this.withOrganization(instance.getOrganization()); 
    this.withSecret(instance.getSecret()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.RegistrySpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.RegistrySpec build() {
    RegistrySpec buildable = new RegistrySpec(fluent.getAddress(),fluent.getCa(),fluent.getInsecure(),fluent.getOrganization(),fluent.getSecret());
    return buildable;
  }
  
}