package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.Volume;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodSpecFluentImpl<A extends PodSpecFluent<A>> extends BaseFluent<A> implements PodSpecFluent<A>{
  public PodSpecFluentImpl() {
  }
  public PodSpecFluentImpl(io.fabric8.camelk.v1.PodSpec instance) {
    this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    this.withContainers(instance.getContainers()); 
    this.withDnsPolicy(instance.getDnsPolicy()); 
    this.withEphemeralContainers(instance.getEphemeralContainers()); 
    this.withInitContainers(instance.getInitContainers()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withRestartPolicy(instance.getRestartPolicy()); 
    this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
    this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints()); 
    this.withVolumes(instance.getVolumes()); 
  }
  private Long activeDeadlineSeconds;
  private ArrayList<ContainerBuilder> containers = new java.util.ArrayList<ContainerBuilder>();
  private String dnsPolicy;
  private List<EphemeralContainer> ephemeralContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EphemeralContainer>();
  private java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder> initContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();
  private Map<java.lang.String,java.lang.String> nodeSelector;
  private java.lang.String restartPolicy;
  private java.lang.Long terminationGracePeriodSeconds;
  private java.util.List<TopologySpreadConstraint> topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();
  private java.util.ArrayList<VolumeBuilder> volumes = new java.util.ArrayList<VolumeBuilder>();
  public java.lang.Long getActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds;
  }
  public A withActiveDeadlineSeconds(java.lang.Long activeDeadlineSeconds) {
    this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
  }
  public Boolean hasActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds != null;
  }
  public A addToContainers(Integer index,io.fabric8.kubernetes.api.model.Container item) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("containers").add(index >= 0 ? index : _visitables.get("containers").size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
  }
  public A setToContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("containers").size()) { _visitables.get("containers").add(builder); } else { _visitables.get("containers").set(index, builder);}
    if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
     return (A)this;
  }
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A addAllToContainers(Collection<io.fabric8.kubernetes.api.model.Container> items) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainers(java.util.Collection<io.fabric8.kubernetes.api.model.Container> items) {
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainers(Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    if (containers == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ContainerBuilder> each = containers.iterator();
    final List visitables = _visitables.get("containers");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.Container> getContainers() {
    return containers != null ? build(containers) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Container> buildContainers() {
    return containers != null ? build(containers) : null;
  }
  public io.fabric8.kubernetes.api.model.Container buildContainer(java.lang.Integer index) {
    return this.containers.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildFirstContainer() {
    return this.containers.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildLastContainer() {
    return this.containers.get(containers.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerBuilder item: containers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerBuilder item: containers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainers(java.util.List<io.fabric8.kubernetes.api.model.Container> containers) {
    if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
    if (containers != null) {this.containers = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
  }
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers) {
    if (this.containers != null) {this.containers.clear();}
    if (containers != null) {for (io.fabric8.kubernetes.api.model.Container item :containers){ this.addToContainers(item);}} return (A) this;
  }
  public java.lang.Boolean hasContainers() {
    return containers != null && !containers.isEmpty();
  }
  public PodSpecFluent.ContainersNested<A> addNewContainer() {
    return new PodSpecFluentImpl.ContainersNestedImpl();
  }
  public io.fabric8.camelk.v1.PodSpecFluent.ContainersNested<A> addNewContainerLike(io.fabric8.kubernetes.api.model.Container item) {
    return new PodSpecFluentImpl.ContainersNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.PodSpecFluent.ContainersNested<A> setNewContainerLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
    return new io.fabric8.camelk.v1.PodSpecFluentImpl.ContainersNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.PodSpecFluent.ContainersNested<A> editContainer(java.lang.Integer index) {
    if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public io.fabric8.camelk.v1.PodSpecFluent.ContainersNested<A> editFirstContainer() {
    if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
    return setNewContainerLike(0, buildContainer(0));
  }
  public io.fabric8.camelk.v1.PodSpecFluent.ContainersNested<A> editLastContainer() {
    int index = containers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public io.fabric8.camelk.v1.PodSpecFluent.ContainersNested<A> editMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containers.size();i++) { 
    if (predicate.test(containers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public java.lang.String getDnsPolicy() {
    return this.dnsPolicy;
  }
  public A withDnsPolicy(java.lang.String dnsPolicy) {
    this.dnsPolicy=dnsPolicy; return (A) this;
  }
  public java.lang.Boolean hasDnsPolicy() {
    return this.dnsPolicy != null;
  }
  public A addToEphemeralContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.EphemeralContainer item) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EphemeralContainer>();}
    this.ephemeralContainers.add(index, item);
    return (A)this;
  }
  public A setToEphemeralContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.EphemeralContainer item) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EphemeralContainer>();}
    this.ephemeralContainers.set(index, item); return (A)this;
  }
  public A addToEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EphemeralContainer>();}
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item : items) {this.ephemeralContainers.add(item);} return (A)this;
  }
  public A addAllToEphemeralContainers(java.util.Collection<io.fabric8.kubernetes.api.model.EphemeralContainer> items) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EphemeralContainer>();}
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item : items) {this.ephemeralContainers.add(item);} return (A)this;
  }
  public A removeFromEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items) {
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item : items) {if (this.ephemeralContainers!= null){ this.ephemeralContainers.remove(item);}} return (A)this;
  }
  public A removeAllFromEphemeralContainers(java.util.Collection<io.fabric8.kubernetes.api.model.EphemeralContainer> items) {
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item : items) {if (this.ephemeralContainers!= null){ this.ephemeralContainers.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EphemeralContainer> getEphemeralContainers() {
    return this.ephemeralContainers;
  }
  public io.fabric8.kubernetes.api.model.EphemeralContainer getEphemeralContainer(java.lang.Integer index) {
    return this.ephemeralContainers.get(index);
  }
  public io.fabric8.kubernetes.api.model.EphemeralContainer getFirstEphemeralContainer() {
    return this.ephemeralContainers.get(0);
  }
  public io.fabric8.kubernetes.api.model.EphemeralContainer getLastEphemeralContainer() {
    return this.ephemeralContainers.get(ephemeralContainers.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.EphemeralContainer getMatchingEphemeralContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EphemeralContainer> predicate) {
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item: ephemeralContainers) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingEphemeralContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EphemeralContainer> predicate) {
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item: ephemeralContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEphemeralContainers(java.util.List<io.fabric8.kubernetes.api.model.EphemeralContainer> ephemeralContainers) {
    if (ephemeralContainers != null) {this.ephemeralContainers = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.EphemeralContainer item : ephemeralContainers){this.addToEphemeralContainers(item);}} else { this.ephemeralContainers = null;} return (A) this;
  }
  public A withEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... ephemeralContainers) {
    if (this.ephemeralContainers != null) {this.ephemeralContainers.clear();}
    if (ephemeralContainers != null) {for (io.fabric8.kubernetes.api.model.EphemeralContainer item :ephemeralContainers){ this.addToEphemeralContainers(item);}} return (A) this;
  }
  public java.lang.Boolean hasEphemeralContainers() {
    return ephemeralContainers != null && !ephemeralContainers.isEmpty();
  }
  public A addToInitContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
  }
  public A setToInitContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
    if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
     return (A)this;
  }
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A addAllToInitContainers(java.util.Collection<io.fabric8.kubernetes.api.model.Container> items) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainers(java.util.Collection<io.fabric8.kubernetes.api.model.Container> items) {
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainers(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.Container> getInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Container> buildInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public io.fabric8.kubernetes.api.model.Container buildInitContainer(java.lang.Integer index) {
    return this.initContainers.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildMatchingInitContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingInitContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInitContainers(java.util.List<io.fabric8.kubernetes.api.model.Container> initContainers) {
    if (this.initContainers != null) { _visitables.get("initContainers").removeAll(this.initContainers);}
    if (initContainers != null) {this.initContainers = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
  }
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers) {
    if (this.initContainers != null) {this.initContainers.clear();}
    if (initContainers != null) {for (io.fabric8.kubernetes.api.model.Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
  }
  public java.lang.Boolean hasInitContainers() {
    return initContainers != null && !initContainers.isEmpty();
  }
  public PodSpecFluent.InitContainersNested<A> addNewInitContainer() {
    return new PodSpecFluentImpl.InitContainersNestedImpl();
  }
  public io.fabric8.camelk.v1.PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(io.fabric8.kubernetes.api.model.Container item) {
    return new io.fabric8.camelk.v1.PodSpecFluentImpl.InitContainersNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
    return new io.fabric8.camelk.v1.PodSpecFluentImpl.InitContainersNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.PodSpecFluent.InitContainersNested<A> editInitContainer(java.lang.Integer index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public io.fabric8.camelk.v1.PodSpecFluent.InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  public io.fabric8.camelk.v1.PodSpecFluent.InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public io.fabric8.camelk.v1.PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public A addToNodeSelector(java.lang.String key,java.lang.String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new java.util.LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(java.lang.String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(java.util.Map<java.lang.String,java.lang.String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new java.util.LinkedHashMap(nodeSelector);} return (A) this;
  }
  public java.lang.Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public java.lang.String getRestartPolicy() {
    return this.restartPolicy;
  }
  public A withRestartPolicy(java.lang.String restartPolicy) {
    this.restartPolicy=restartPolicy; return (A) this;
  }
  public java.lang.Boolean hasRestartPolicy() {
    return this.restartPolicy != null;
  }
  public java.lang.Long getTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds;
  }
  public A withTerminationGracePeriodSeconds(java.lang.Long terminationGracePeriodSeconds) {
    this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
  }
  public java.lang.Boolean hasTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds != null;
  }
  public A addToTopologySpreadConstraints(java.lang.Integer index,io.fabric8.kubernetes.api.model.TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
    this.topologySpreadConstraints.add(index, item);
    return (A)this;
  }
  public A setToTopologySpreadConstraints(java.lang.Integer index,io.fabric8.kubernetes.api.model.TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
    this.topologySpreadConstraints.set(index, item); return (A)this;
  }
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A addAllToTopologySpreadConstraints(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public A removeAllFromTopologySpreadConstraints(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> items) {
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> getTopologySpreadConstraints() {
    return this.topologySpreadConstraints;
  }
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getTopologySpreadConstraint(java.lang.Integer index) {
    return this.topologySpreadConstraints.get(index);
  }
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getFirstTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(0);
  }
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getLastTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getMatchingTopologySpreadConstraint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> predicate) {
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingTopologySpreadConstraint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> predicate) {
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopologySpreadConstraints(java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> topologySpreadConstraints) {
    if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
  }
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints) {
    if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear();}
    if (topologySpreadConstraints != null) {for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
  }
  public java.lang.Boolean hasTopologySpreadConstraints() {
    return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
  }
  public A addToVolumes(java.lang.Integer index,io.fabric8.kubernetes.api.model.Volume item) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
    io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
  }
  public A setToVolumes(java.lang.Integer index,io.fabric8.kubernetes.api.model.Volume item) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
    io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
    if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
     return (A)this;
  }
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
    for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A addAllToVolumes(java.util.Collection<io.fabric8.kubernetes.api.model.Volume> items) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
    for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumes(java.util.Collection<io.fabric8.kubernetes.api.model.Volume> items) {
    for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumes(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.VolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.VolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.Volume> getVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Volume> buildVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public io.fabric8.kubernetes.api.model.Volume buildVolume(java.lang.Integer index) {
    return this.volumes.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.Volume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.Volume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.Volume buildMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.VolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.VolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(java.util.List<io.fabric8.kubernetes.api.model.Volume> volumes) {
    if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
    if (volumes != null) {this.volumes = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {this.volumes.clear();}
    if (volumes != null) {for (io.fabric8.kubernetes.api.model.Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public java.lang.Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public PodSpecFluent.VolumesNested<A> addNewVolume() {
    return new PodSpecFluentImpl.VolumesNestedImpl();
  }
  public io.fabric8.camelk.v1.PodSpecFluent.VolumesNested<A> addNewVolumeLike(io.fabric8.kubernetes.api.model.Volume item) {
    return new io.fabric8.camelk.v1.PodSpecFluentImpl.VolumesNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.PodSpecFluent.VolumesNested<A> setNewVolumeLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Volume item) {
    return new io.fabric8.camelk.v1.PodSpecFluentImpl.VolumesNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.PodSpecFluent.VolumesNested<A> editVolume(java.lang.Integer index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public io.fabric8.camelk.v1.PodSpecFluent.VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  public io.fabric8.camelk.v1.PodSpecFluent.VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public io.fabric8.camelk.v1.PodSpecFluent.VolumesNested<A> editMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodSpecFluentImpl that = (PodSpecFluentImpl) o;
    if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
    if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
    if (dnsPolicy != null ? !dnsPolicy.equals(that.dnsPolicy) :that.dnsPolicy != null) return false;
    if (ephemeralContainers != null ? !ephemeralContainers.equals(that.ephemeralContainers) :that.ephemeralContainers != null) return false;
    if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
    if (terminationGracePeriodSeconds != null ? !terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) :that.terminationGracePeriodSeconds != null) return false;
    if (topologySpreadConstraints != null ? !topologySpreadConstraints.equals(that.topologySpreadConstraints) :that.topologySpreadConstraints != null) return false;
    if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(activeDeadlineSeconds,  containers,  dnsPolicy,  ephemeralContainers,  initContainers,  nodeSelector,  restartPolicy,  terminationGracePeriodSeconds,  topologySpreadConstraints,  volumes,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (activeDeadlineSeconds != null) { sb.append("activeDeadlineSeconds:"); sb.append(activeDeadlineSeconds + ","); }
    if (containers != null && !containers.isEmpty()) { sb.append("containers:"); sb.append(containers + ","); }
    if (dnsPolicy != null) { sb.append("dnsPolicy:"); sb.append(dnsPolicy + ","); }
    if (ephemeralContainers != null && !ephemeralContainers.isEmpty()) { sb.append("ephemeralContainers:"); sb.append(ephemeralContainers + ","); }
    if (initContainers != null && !initContainers.isEmpty()) { sb.append("initContainers:"); sb.append(initContainers + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (restartPolicy != null) { sb.append("restartPolicy:"); sb.append(restartPolicy + ","); }
    if (terminationGracePeriodSeconds != null) { sb.append("terminationGracePeriodSeconds:"); sb.append(terminationGracePeriodSeconds + ","); }
    if (topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty()) { sb.append("topologySpreadConstraints:"); sb.append(topologySpreadConstraints + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes); }
    sb.append("}");
    return sb.toString();
  }
  class ContainersNestedImpl<N> extends ContainerFluentImpl<PodSpecFluent.ContainersNested<N>> implements io.fabric8.camelk.v1.PodSpecFluent.ContainersNested<N>,Nested<N>{
    ContainersNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(this, item);
    }
    ContainersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToContainers(index,builder.build());
    }
    public N endContainer() {
      return and();
    }
    
  }
  class InitContainersNestedImpl<N> extends io.fabric8.kubernetes.api.model.ContainerFluentImpl<PodSpecFluent.InitContainersNested<N>> implements io.fabric8.camelk.v1.PodSpecFluent.InitContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    InitContainersNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(this, item);
    }
    InitContainersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToInitContainers(index,builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  class VolumesNestedImpl<N> extends VolumeFluentImpl<PodSpecFluent.VolumesNested<N>> implements io.fabric8.camelk.v1.PodSpecFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VolumesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Volume item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(this, item);
    }
    VolumesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(this);
    }
    io.fabric8.kubernetes.api.model.VolumeBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToVolumes(index,builder.build());
    }
    public N endVolume() {
      return and();
    }
    
  }
  
}