package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSpecBuilder extends PodSpecFluentImpl<PodSpecBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.PodSpec,io.fabric8.camelk.v1.PodSpecBuilder>{
  public PodSpecBuilder() {
    this(false);
  }
  public PodSpecBuilder(Boolean validationEnabled) {
    this(new PodSpec(), validationEnabled);
  }
  public PodSpecBuilder(PodSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSpecBuilder(io.fabric8.camelk.v1.PodSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodSpec(), validationEnabled);
  }
  public PodSpecBuilder(io.fabric8.camelk.v1.PodSpecFluent<?> fluent,io.fabric8.camelk.v1.PodSpec instance) {
    this(fluent, instance, false);
  }
  public PodSpecBuilder(io.fabric8.camelk.v1.PodSpecFluent<?> fluent,io.fabric8.camelk.v1.PodSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    fluent.withContainers(instance.getContainers()); 
    fluent.withDnsPolicy(instance.getDnsPolicy()); 
    fluent.withEphemeralContainers(instance.getEphemeralContainers()); 
    fluent.withInitContainers(instance.getInitContainers()); 
    fluent.withNodeSelector(instance.getNodeSelector()); 
    fluent.withRestartPolicy(instance.getRestartPolicy()); 
    fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
    fluent.withTopologySpreadConstraints(instance.getTopologySpreadConstraints()); 
    fluent.withVolumes(instance.getVolumes()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodSpecBuilder(io.fabric8.camelk.v1.PodSpec instance) {
    this(instance,false);
  }
  public PodSpecBuilder(io.fabric8.camelk.v1.PodSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    this.withContainers(instance.getContainers()); 
    this.withDnsPolicy(instance.getDnsPolicy()); 
    this.withEphemeralContainers(instance.getEphemeralContainers()); 
    this.withInitContainers(instance.getInitContainers()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withRestartPolicy(instance.getRestartPolicy()); 
    this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
    this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints()); 
    this.withVolumes(instance.getVolumes()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.PodSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.PodSpec build() {
    PodSpec buildable = new PodSpec(fluent.getActiveDeadlineSeconds(),fluent.getContainers(),fluent.getDnsPolicy(),fluent.getEphemeralContainers(),fluent.getInitContainers(),fluent.getNodeSelector(),fluent.getRestartPolicy(),fluent.getTerminationGracePeriodSeconds(),fluent.getTopologySpreadConstraints(),fluent.getVolumes());
    return buildable;
  }
  
}