package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MavenSpecBuilder extends MavenSpecFluentImpl<MavenSpecBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.MavenSpec,io.fabric8.camelk.v1.MavenSpecBuilder>{
  public MavenSpecBuilder() {
    this(false);
  }
  public MavenSpecBuilder(Boolean validationEnabled) {
    this(new MavenSpec(), validationEnabled);
  }
  public MavenSpecBuilder(MavenSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MavenSpecBuilder(io.fabric8.camelk.v1.MavenSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MavenSpec(), validationEnabled);
  }
  public MavenSpecBuilder(io.fabric8.camelk.v1.MavenSpecFluent<?> fluent,io.fabric8.camelk.v1.MavenSpec instance) {
    this(fluent, instance, false);
  }
  public MavenSpecBuilder(io.fabric8.camelk.v1.MavenSpecFluent<?> fluent,io.fabric8.camelk.v1.MavenSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCaSecret(instance.getCaSecret()); 
    fluent.withCliOptions(instance.getCliOptions()); 
    fluent.withExtension(instance.getExtension()); 
    fluent.withLocalRepository(instance.getLocalRepository()); 
    fluent.withProperties(instance.getProperties()); 
    fluent.withSettings(instance.getSettings()); 
    fluent.withTimeout(instance.getTimeout()); 
    this.validationEnabled = validationEnabled; 
  }
  public MavenSpecBuilder(io.fabric8.camelk.v1.MavenSpec instance) {
    this(instance,false);
  }
  public MavenSpecBuilder(io.fabric8.camelk.v1.MavenSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCaSecret(instance.getCaSecret()); 
    this.withCliOptions(instance.getCliOptions()); 
    this.withExtension(instance.getExtension()); 
    this.withLocalRepository(instance.getLocalRepository()); 
    this.withProperties(instance.getProperties()); 
    this.withSettings(instance.getSettings()); 
    this.withTimeout(instance.getTimeout()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.MavenSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.MavenSpec build() {
    MavenSpec buildable = new MavenSpec(fluent.getCaSecret(),fluent.getCliOptions(),fluent.getExtension(),fluent.getLocalRepository(),fluent.getProperties(),fluent.getSettings(),fluent.getTimeout());
    return buildable;
  }
  
}