package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MavenArtifactBuilder extends MavenArtifactFluentImpl<MavenArtifactBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.MavenArtifact,MavenArtifactBuilder>{
  public MavenArtifactBuilder() {
    this(false);
  }
  public MavenArtifactBuilder(Boolean validationEnabled) {
    this(new MavenArtifact(), validationEnabled);
  }
  public MavenArtifactBuilder(io.fabric8.camelk.v1.MavenArtifactFluent<?> fluent) {
    this(fluent, false);
  }
  public MavenArtifactBuilder(io.fabric8.camelk.v1.MavenArtifactFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MavenArtifact(), validationEnabled);
  }
  public MavenArtifactBuilder(io.fabric8.camelk.v1.MavenArtifactFluent<?> fluent,io.fabric8.camelk.v1.MavenArtifact instance) {
    this(fluent, instance, false);
  }
  public MavenArtifactBuilder(io.fabric8.camelk.v1.MavenArtifactFluent<?> fluent,io.fabric8.camelk.v1.MavenArtifact instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withArtifactId(instance.getArtifactId()); 
    fluent.withGroupId(instance.getGroupId()); 
    fluent.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  public MavenArtifactBuilder(io.fabric8.camelk.v1.MavenArtifact instance) {
    this(instance,false);
  }
  public MavenArtifactBuilder(io.fabric8.camelk.v1.MavenArtifact instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withArtifactId(instance.getArtifactId()); 
    this.withGroupId(instance.getGroupId()); 
    this.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.MavenArtifactFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.MavenArtifact build() {
    MavenArtifact buildable = new MavenArtifact(fluent.getArtifactId(),fluent.getGroupId(),fluent.getVersion());
    return buildable;
  }
  
}