package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KanikoTaskCacheBuilder extends KanikoTaskCacheFluentImpl<KanikoTaskCacheBuilder> implements VisitableBuilder<KanikoTaskCache,io.fabric8.camelk.v1.KanikoTaskCacheBuilder>{
  public KanikoTaskCacheBuilder() {
    this(false);
  }
  public KanikoTaskCacheBuilder(Boolean validationEnabled) {
    this(new KanikoTaskCache(), validationEnabled);
  }
  public KanikoTaskCacheBuilder(io.fabric8.camelk.v1.KanikoTaskCacheFluent<?> fluent) {
    this(fluent, false);
  }
  public KanikoTaskCacheBuilder(io.fabric8.camelk.v1.KanikoTaskCacheFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new KanikoTaskCache(), validationEnabled);
  }
  public KanikoTaskCacheBuilder(io.fabric8.camelk.v1.KanikoTaskCacheFluent<?> fluent,io.fabric8.camelk.v1.KanikoTaskCache instance) {
    this(fluent, instance, false);
  }
  public KanikoTaskCacheBuilder(io.fabric8.camelk.v1.KanikoTaskCacheFluent<?> fluent,io.fabric8.camelk.v1.KanikoTaskCache instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEnabled(instance.getEnabled()); 
    fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
    this.validationEnabled = validationEnabled; 
  }
  public KanikoTaskCacheBuilder(io.fabric8.camelk.v1.KanikoTaskCache instance) {
    this(instance,false);
  }
  public KanikoTaskCacheBuilder(io.fabric8.camelk.v1.KanikoTaskCache instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEnabled(instance.getEnabled()); 
    this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.KanikoTaskCacheFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.KanikoTaskCache build() {
    KanikoTaskCache buildable = new KanikoTaskCache(fluent.getEnabled(),fluent.getPersistentVolumeClaim());
    return buildable;
  }
  
}