package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IntegrationStatusFluentImpl<A extends IntegrationStatusFluent<A>> extends BaseFluent<A> implements IntegrationStatusFluent<A>{
  public IntegrationStatusFluentImpl() {
  }
  public IntegrationStatusFluentImpl(io.fabric8.camelk.v1.IntegrationStatus instance) {
    this.withCapabilities(instance.getCapabilities()); 
    this.withConditions(instance.getConditions()); 
    this.withConfiguration(instance.getConfiguration()); 
    this.withDependencies(instance.getDependencies()); 
    this.withDigest(instance.getDigest()); 
    this.withGeneratedResources(instance.getGeneratedResources()); 
    this.withGeneratedSources(instance.getGeneratedSources()); 
    this.withImage(instance.getImage()); 
    this.withIntegrationKit(instance.getIntegrationKit()); 
    this.withKit(instance.getKit()); 
    this.withLastInitTimestamp(instance.getLastInitTimestamp()); 
    this.withPhase(instance.getPhase()); 
    this.withPlatform(instance.getPlatform()); 
    this.withProfile(instance.getProfile()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRuntimeProvider(instance.getRuntimeProvider()); 
    this.withRuntimeVersion(instance.getRuntimeVersion()); 
    this.withSelector(instance.getSelector()); 
    this.withVersion(instance.getVersion()); 
  }
  private List<String> capabilities = new ArrayList<java.lang.String>();
  private java.util.ArrayList<IntegrationConditionBuilder> conditions = new java.util.ArrayList<IntegrationConditionBuilder>();
  private java.util.ArrayList<ConfigurationSpecBuilder> configuration = new java.util.ArrayList<ConfigurationSpecBuilder>();
  private java.util.List<java.lang.String> dependencies = new java.util.ArrayList<java.lang.String>();
  private java.lang.String digest;
  private java.util.ArrayList<ResourceSpecBuilder> generatedResources = new java.util.ArrayList<ResourceSpecBuilder>();
  private java.util.ArrayList<SourceSpecBuilder> generatedSources = new java.util.ArrayList<SourceSpecBuilder>();
  private java.lang.String image;
  private ObjectReferenceBuilder integrationKit;
  private java.lang.String kit;
  private java.lang.String lastInitTimestamp;
  private java.lang.String phase;
  private java.lang.String platform;
  private java.lang.String profile;
  private Integer replicas;
  private java.lang.String runtimeProvider;
  private java.lang.String runtimeVersion;
  private java.lang.String selector;
  private java.lang.String version;
  public A addToCapabilities(java.lang.Integer index,java.lang.String item) {
    if (this.capabilities == null) {this.capabilities = new java.util.ArrayList<java.lang.String>();}
    this.capabilities.add(index, item);
    return (A)this;
  }
  public A setToCapabilities(java.lang.Integer index,java.lang.String item) {
    if (this.capabilities == null) {this.capabilities = new java.util.ArrayList<java.lang.String>();}
    this.capabilities.set(index, item); return (A)this;
  }
  public A addToCapabilities(java.lang.String... items) {
    if (this.capabilities == null) {this.capabilities = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.capabilities.add(item);} return (A)this;
  }
  public A addAllToCapabilities(Collection<java.lang.String> items) {
    if (this.capabilities == null) {this.capabilities = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.capabilities.add(item);} return (A)this;
  }
  public A removeFromCapabilities(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.capabilities!= null){ this.capabilities.remove(item);}} return (A)this;
  }
  public A removeAllFromCapabilities(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.capabilities!= null){ this.capabilities.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getCapabilities() {
    return this.capabilities;
  }
  public java.lang.String getCapability(java.lang.Integer index) {
    return this.capabilities.get(index);
  }
  public java.lang.String getFirstCapability() {
    return this.capabilities.get(0);
  }
  public java.lang.String getLastCapability() {
    return this.capabilities.get(capabilities.size() - 1);
  }
  public java.lang.String getMatchingCapability(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: capabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCapability(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: capabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCapabilities(java.util.List<java.lang.String> capabilities) {
    if (capabilities != null) {this.capabilities = new java.util.ArrayList(); for (java.lang.String item : capabilities){this.addToCapabilities(item);}} else { this.capabilities = null;} return (A) this;
  }
  public A withCapabilities(java.lang.String... capabilities) {
    if (this.capabilities != null) {this.capabilities.clear();}
    if (capabilities != null) {for (java.lang.String item :capabilities){ this.addToCapabilities(item);}} return (A) this;
  }
  public java.lang.Boolean hasCapabilities() {
    return capabilities != null && !capabilities.isEmpty();
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.camelk.v1.IntegrationCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationConditionBuilder>();}
    io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.camelk.v1.IntegrationCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationConditionBuilder>();}
    io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.camelk.v1.IntegrationCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationConditionBuilder>();}
    for (io.fabric8.camelk.v1.IntegrationCondition item : items) {io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.camelk.v1.IntegrationCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationConditionBuilder>();}
    for (io.fabric8.camelk.v1.IntegrationCondition item : items) {io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.camelk.v1.IntegrationCondition... items) {
    for (io.fabric8.camelk.v1.IntegrationCondition item : items) {io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.camelk.v1.IntegrationCondition> items) {
    for (io.fabric8.camelk.v1.IntegrationCondition item : items) {io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.IntegrationConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.IntegrationConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public java.util.List<io.fabric8.camelk.v1.IntegrationCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public java.util.List<io.fabric8.camelk.v1.IntegrationCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public io.fabric8.camelk.v1.IntegrationCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.camelk.v1.IntegrationCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.camelk.v1.IntegrationCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.camelk.v1.IntegrationCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationConditionBuilder> predicate) {
    for (io.fabric8.camelk.v1.IntegrationConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationConditionBuilder> predicate) {
    for (io.fabric8.camelk.v1.IntegrationConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.camelk.v1.IntegrationCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.camelk.v1.IntegrationCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.camelk.v1.IntegrationCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.camelk.v1.IntegrationCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public IntegrationStatusFluent.ConditionsNested<A> addNewCondition() {
    return new IntegrationStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.camelk.v1.IntegrationCondition item) {
    return new IntegrationStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.camelk.v1.IntegrationCondition item) {
    return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToConfiguration(java.lang.Integer index,io.fabric8.camelk.v1.ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(index >= 0 ? index : _visitables.get("configuration").size(), builder);this.configuration.add(index >= 0 ? index : configuration.size(), builder); return (A)this;
  }
  public A setToConfiguration(java.lang.Integer index,io.fabric8.camelk.v1.ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("configuration").size()) { _visitables.get("configuration").add(builder); } else { _visitables.get("configuration").set(index, builder);}
    if (index < 0 || index >= configuration.size()) { configuration.add(builder); } else { configuration.set(index, builder);}
     return (A)this;
  }
  public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A addAllToConfiguration(java.util.Collection<io.fabric8.camelk.v1.ConfigurationSpec> items) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfiguration(java.util.Collection<io.fabric8.camelk.v1.ConfigurationSpec> items) {
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    if (configuration == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.ConfigurationSpecBuilder> each = configuration.iterator();
    final List visitables = _visitables.get("configuration");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> getConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> buildConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildConfiguration(java.lang.Integer index) {
    return this.configuration.get(index).build();
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildFirstConfiguration() {
    return this.configuration.get(0).build();
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildLastConfiguration() {
    return this.configuration.get(configuration.size() - 1).build();
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfiguration(java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> configuration) {
    if (this.configuration != null) { _visitables.get("configuration").removeAll(this.configuration);}
    if (configuration != null) {this.configuration = new java.util.ArrayList(); for (io.fabric8.camelk.v1.ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
  }
  public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration) {
    if (this.configuration != null) {this.configuration.clear();}
    if (configuration != null) {for (io.fabric8.camelk.v1.ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
  }
  public java.lang.Boolean hasConfiguration() {
    return configuration != null && !configuration.isEmpty();
  }
  public A addNewConfiguration(java.lang.String resourceKey,java.lang.String resourceMountPoint,java.lang.String resourceType,java.lang.String type,java.lang.String value) {
    return (A)addToConfiguration(new ConfigurationSpec(resourceKey, resourceMountPoint, resourceType, type, value));
  }
  public IntegrationStatusFluent.ConfigurationNested<A> addNewConfiguration() {
    return new IntegrationStatusFluentImpl.ConfigurationNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> addNewConfigurationLike(io.fabric8.camelk.v1.ConfigurationSpec item) {
    return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.ConfigurationNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> setNewConfigurationLike(java.lang.Integer index,io.fabric8.camelk.v1.ConfigurationSpec item) {
    return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.ConfigurationNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editConfiguration(java.lang.Integer index) {
    if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editFirstConfiguration() {
    if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
    return setNewConfigurationLike(0, buildConfiguration(0));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editLastConfiguration() {
    int index = configuration.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configuration.size();i++) { 
    if (predicate.test(configuration.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public A addToDependencies(java.lang.Integer index,java.lang.String item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    this.dependencies.add(index, item);
    return (A)this;
  }
  public A setToDependencies(java.lang.Integer index,java.lang.String item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    this.dependencies.set(index, item); return (A)this;
  }
  public A addToDependencies(java.lang.String... items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A addAllToDependencies(java.util.Collection<java.lang.String> items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A removeFromDependencies(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public A removeAllFromDependencies(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getDependencies() {
    return this.dependencies;
  }
  public java.lang.String getDependency(java.lang.Integer index) {
    return this.dependencies.get(index);
  }
  public java.lang.String getFirstDependency() {
    return this.dependencies.get(0);
  }
  public java.lang.String getLastDependency() {
    return this.dependencies.get(dependencies.size() - 1);
  }
  public java.lang.String getMatchingDependency(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingDependency(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(java.util.List<java.lang.String> dependencies) {
    if (dependencies != null) {this.dependencies = new java.util.ArrayList(); for (java.lang.String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(java.lang.String... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (java.lang.String item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public java.lang.Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public java.lang.String getDigest() {
    return this.digest;
  }
  public A withDigest(java.lang.String digest) {
    this.digest=digest; return (A) this;
  }
  public java.lang.Boolean hasDigest() {
    return this.digest != null;
  }
  public A addToGeneratedResources(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
    if (this.generatedResources == null) {this.generatedResources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("generatedResources").add(index >= 0 ? index : _visitables.get("generatedResources").size(), builder);this.generatedResources.add(index >= 0 ? index : generatedResources.size(), builder); return (A)this;
  }
  public A setToGeneratedResources(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
    if (this.generatedResources == null) {this.generatedResources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("generatedResources").size()) { _visitables.get("generatedResources").add(builder); } else { _visitables.get("generatedResources").set(index, builder);}
    if (index < 0 || index >= generatedResources.size()) { generatedResources.add(builder); } else { generatedResources.set(index, builder);}
     return (A)this;
  }
  public A addToGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    if (this.generatedResources == null) {this.generatedResources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("generatedResources").add(builder);this.generatedResources.add(builder);} return (A)this;
  }
  public A addAllToGeneratedResources(java.util.Collection<io.fabric8.camelk.v1.ResourceSpec> items) {
    if (this.generatedResources == null) {this.generatedResources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("generatedResources").add(builder);this.generatedResources.add(builder);} return (A)this;
  }
  public A removeFromGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("generatedResources").remove(builder);if (this.generatedResources != null) {this.generatedResources.remove(builder);}} return (A)this;
  }
  public A removeAllFromGeneratedResources(java.util.Collection<io.fabric8.camelk.v1.ResourceSpec> items) {
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("generatedResources").remove(builder);if (this.generatedResources != null) {this.generatedResources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGeneratedResources(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    if (generatedResources == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.ResourceSpecBuilder> each = generatedResources.iterator();
    final List visitables = _visitables.get("generatedResources");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.ResourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildGeneratedResources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.camelk.v1.ResourceSpec> getGeneratedResources() {
    return generatedResources != null ? build(generatedResources) : null;
  }
  public java.util.List<io.fabric8.camelk.v1.ResourceSpec> buildGeneratedResources() {
    return generatedResources != null ? build(generatedResources) : null;
  }
  public io.fabric8.camelk.v1.ResourceSpec buildGeneratedResource(java.lang.Integer index) {
    return this.generatedResources.get(index).build();
  }
  public io.fabric8.camelk.v1.ResourceSpec buildFirstGeneratedResource() {
    return this.generatedResources.get(0).build();
  }
  public io.fabric8.camelk.v1.ResourceSpec buildLastGeneratedResource() {
    return this.generatedResources.get(generatedResources.size() - 1).build();
  }
  public io.fabric8.camelk.v1.ResourceSpec buildMatchingGeneratedResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ResourceSpecBuilder item: generatedResources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingGeneratedResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ResourceSpecBuilder item: generatedResources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGeneratedResources(java.util.List<io.fabric8.camelk.v1.ResourceSpec> generatedResources) {
    if (this.generatedResources != null) { _visitables.get("generatedResources").removeAll(this.generatedResources);}
    if (generatedResources != null) {this.generatedResources = new java.util.ArrayList(); for (io.fabric8.camelk.v1.ResourceSpec item : generatedResources){this.addToGeneratedResources(item);}} else { this.generatedResources = null;} return (A) this;
  }
  public A withGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... generatedResources) {
    if (this.generatedResources != null) {this.generatedResources.clear();}
    if (generatedResources != null) {for (io.fabric8.camelk.v1.ResourceSpec item :generatedResources){ this.addToGeneratedResources(item);}} return (A) this;
  }
  public java.lang.Boolean hasGeneratedResources() {
    return generatedResources != null && !generatedResources.isEmpty();
  }
  public IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResource() {
    return new IntegrationStatusFluentImpl.GeneratedResourcesNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResourceLike(io.fabric8.camelk.v1.ResourceSpec item) {
    return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.GeneratedResourcesNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> setNewGeneratedResourceLike(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
    return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.GeneratedResourcesNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editGeneratedResource(java.lang.Integer index) {
    if (generatedResources.size() <= index) throw new RuntimeException("Can't edit generatedResources. Index exceeds size.");
    return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editFirstGeneratedResource() {
    if (generatedResources.size() == 0) throw new RuntimeException("Can't edit first generatedResources. The list is empty.");
    return setNewGeneratedResourceLike(0, buildGeneratedResource(0));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editLastGeneratedResource() {
    int index = generatedResources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last generatedResources. The list is empty.");
    return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editMatchingGeneratedResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<generatedResources.size();i++) { 
    if (predicate.test(generatedResources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching generatedResources. No match found.");
    return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
  }
  public A addToGeneratedSources(java.lang.Integer index,io.fabric8.camelk.v1.SourceSpec item) {
    if (this.generatedSources == null) {this.generatedSources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("generatedSources").add(index >= 0 ? index : _visitables.get("generatedSources").size(), builder);this.generatedSources.add(index >= 0 ? index : generatedSources.size(), builder); return (A)this;
  }
  public A setToGeneratedSources(java.lang.Integer index,io.fabric8.camelk.v1.SourceSpec item) {
    if (this.generatedSources == null) {this.generatedSources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("generatedSources").size()) { _visitables.get("generatedSources").add(builder); } else { _visitables.get("generatedSources").set(index, builder);}
    if (index < 0 || index >= generatedSources.size()) { generatedSources.add(builder); } else { generatedSources.set(index, builder);}
     return (A)this;
  }
  public A addToGeneratedSources(io.fabric8.camelk.v1.SourceSpec... items) {
    if (this.generatedSources == null) {this.generatedSources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("generatedSources").add(builder);this.generatedSources.add(builder);} return (A)this;
  }
  public A addAllToGeneratedSources(java.util.Collection<io.fabric8.camelk.v1.SourceSpec> items) {
    if (this.generatedSources == null) {this.generatedSources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("generatedSources").add(builder);this.generatedSources.add(builder);} return (A)this;
  }
  public A removeFromGeneratedSources(io.fabric8.camelk.v1.SourceSpec... items) {
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("generatedSources").remove(builder);if (this.generatedSources != null) {this.generatedSources.remove(builder);}} return (A)this;
  }
  public A removeAllFromGeneratedSources(java.util.Collection<io.fabric8.camelk.v1.SourceSpec> items) {
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("generatedSources").remove(builder);if (this.generatedSources != null) {this.generatedSources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGeneratedSources(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    if (generatedSources == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.SourceSpecBuilder> each = generatedSources.iterator();
    final List visitables = _visitables.get("generatedSources");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.SourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildGeneratedSources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.camelk.v1.SourceSpec> getGeneratedSources() {
    return generatedSources != null ? build(generatedSources) : null;
  }
  public java.util.List<io.fabric8.camelk.v1.SourceSpec> buildGeneratedSources() {
    return generatedSources != null ? build(generatedSources) : null;
  }
  public io.fabric8.camelk.v1.SourceSpec buildGeneratedSource(java.lang.Integer index) {
    return this.generatedSources.get(index).build();
  }
  public io.fabric8.camelk.v1.SourceSpec buildFirstGeneratedSource() {
    return this.generatedSources.get(0).build();
  }
  public io.fabric8.camelk.v1.SourceSpec buildLastGeneratedSource() {
    return this.generatedSources.get(generatedSources.size() - 1).build();
  }
  public io.fabric8.camelk.v1.SourceSpec buildMatchingGeneratedSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.SourceSpecBuilder item: generatedSources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingGeneratedSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.SourceSpecBuilder item: generatedSources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGeneratedSources(java.util.List<io.fabric8.camelk.v1.SourceSpec> generatedSources) {
    if (this.generatedSources != null) { _visitables.get("generatedSources").removeAll(this.generatedSources);}
    if (generatedSources != null) {this.generatedSources = new java.util.ArrayList(); for (io.fabric8.camelk.v1.SourceSpec item : generatedSources){this.addToGeneratedSources(item);}} else { this.generatedSources = null;} return (A) this;
  }
  public A withGeneratedSources(io.fabric8.camelk.v1.SourceSpec... generatedSources) {
    if (this.generatedSources != null) {this.generatedSources.clear();}
    if (generatedSources != null) {for (io.fabric8.camelk.v1.SourceSpec item :generatedSources){ this.addToGeneratedSources(item);}} return (A) this;
  }
  public java.lang.Boolean hasGeneratedSources() {
    return generatedSources != null && !generatedSources.isEmpty();
  }
  public IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSource() {
    return new IntegrationStatusFluentImpl.GeneratedSourcesNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSourceLike(io.fabric8.camelk.v1.SourceSpec item) {
    return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.GeneratedSourcesNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> setNewGeneratedSourceLike(java.lang.Integer index,io.fabric8.camelk.v1.SourceSpec item) {
    return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.GeneratedSourcesNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editGeneratedSource(java.lang.Integer index) {
    if (generatedSources.size() <= index) throw new RuntimeException("Can't edit generatedSources. Index exceeds size.");
    return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editFirstGeneratedSource() {
    if (generatedSources.size() == 0) throw new RuntimeException("Can't edit first generatedSources. The list is empty.");
    return setNewGeneratedSourceLike(0, buildGeneratedSource(0));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editLastGeneratedSource() {
    int index = generatedSources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last generatedSources. The list is empty.");
    return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editMatchingGeneratedSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<generatedSources.size();i++) { 
    if (predicate.test(generatedSources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching generatedSources. No match found.");
    return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
  }
  public java.lang.String getImage() {
    return this.image;
  }
  public A withImage(java.lang.String image) {
    this.image=image; return (A) this;
  }
  public java.lang.Boolean hasImage() {
    return this.image != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIntegrationKit instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getIntegrationKit() {
    return this.integrationKit!=null ?this.integrationKit.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildIntegrationKit() {
    return this.integrationKit!=null ?this.integrationKit.build():null;
  }
  public A withIntegrationKit(io.fabric8.kubernetes.api.model.ObjectReference integrationKit) {
    _visitables.get("integrationKit").remove(this.integrationKit);
    if (integrationKit!=null){ this.integrationKit= new ObjectReferenceBuilder(integrationKit); _visitables.get("integrationKit").add(this.integrationKit);} return (A) this;
  }
  public java.lang.Boolean hasIntegrationKit() {
    return this.integrationKit != null;
  }
  public IntegrationStatusFluent.IntegrationKitNested<A> withNewIntegrationKit() {
    return new IntegrationStatusFluentImpl.IntegrationKitNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.IntegrationKitNested<A> withNewIntegrationKitLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.IntegrationKitNestedImpl(item);
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.IntegrationKitNested<A> editIntegrationKit() {
    return withNewIntegrationKitLike(getIntegrationKit());
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.IntegrationKitNested<A> editOrNewIntegrationKit() {
    return withNewIntegrationKitLike(getIntegrationKit() != null ? getIntegrationKit(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.camelk.v1.IntegrationStatusFluent.IntegrationKitNested<A> editOrNewIntegrationKitLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewIntegrationKitLike(getIntegrationKit() != null ? getIntegrationKit(): item);
  }
  public java.lang.String getKit() {
    return this.kit;
  }
  public A withKit(java.lang.String kit) {
    this.kit=kit; return (A) this;
  }
  public java.lang.Boolean hasKit() {
    return this.kit != null;
  }
  public java.lang.String getLastInitTimestamp() {
    return this.lastInitTimestamp;
  }
  public A withLastInitTimestamp(java.lang.String lastInitTimestamp) {
    this.lastInitTimestamp=lastInitTimestamp; return (A) this;
  }
  public java.lang.Boolean hasLastInitTimestamp() {
    return this.lastInitTimestamp != null;
  }
  public java.lang.String getPhase() {
    return this.phase;
  }
  public A withPhase(java.lang.String phase) {
    this.phase=phase; return (A) this;
  }
  public java.lang.Boolean hasPhase() {
    return this.phase != null;
  }
  public java.lang.String getPlatform() {
    return this.platform;
  }
  public A withPlatform(java.lang.String platform) {
    this.platform=platform; return (A) this;
  }
  public java.lang.Boolean hasPlatform() {
    return this.platform != null;
  }
  public java.lang.String getProfile() {
    return this.profile;
  }
  public A withProfile(java.lang.String profile) {
    this.profile=profile; return (A) this;
  }
  public java.lang.Boolean hasProfile() {
    return this.profile != null;
  }
  public java.lang.Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(java.lang.Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public java.lang.Boolean hasReplicas() {
    return this.replicas != null;
  }
  public java.lang.String getRuntimeProvider() {
    return this.runtimeProvider;
  }
  public A withRuntimeProvider(java.lang.String runtimeProvider) {
    this.runtimeProvider=runtimeProvider; return (A) this;
  }
  public java.lang.Boolean hasRuntimeProvider() {
    return this.runtimeProvider != null;
  }
  public java.lang.String getRuntimeVersion() {
    return this.runtimeVersion;
  }
  public A withRuntimeVersion(java.lang.String runtimeVersion) {
    this.runtimeVersion=runtimeVersion; return (A) this;
  }
  public java.lang.Boolean hasRuntimeVersion() {
    return this.runtimeVersion != null;
  }
  public java.lang.String getSelector() {
    return this.selector;
  }
  public A withSelector(java.lang.String selector) {
    this.selector=selector; return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  public java.lang.String getVersion() {
    return this.version;
  }
  public A withVersion(java.lang.String version) {
    this.version=version; return (A) this;
  }
  public java.lang.Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IntegrationStatusFluentImpl that = (IntegrationStatusFluentImpl) o;
    if (capabilities != null ? !capabilities.equals(that.capabilities) :that.capabilities != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (digest != null ? !digest.equals(that.digest) :that.digest != null) return false;
    if (generatedResources != null ? !generatedResources.equals(that.generatedResources) :that.generatedResources != null) return false;
    if (generatedSources != null ? !generatedSources.equals(that.generatedSources) :that.generatedSources != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (integrationKit != null ? !integrationKit.equals(that.integrationKit) :that.integrationKit != null) return false;
    if (kit != null ? !kit.equals(that.kit) :that.kit != null) return false;
    if (lastInitTimestamp != null ? !lastInitTimestamp.equals(that.lastInitTimestamp) :that.lastInitTimestamp != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
    if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (runtimeProvider != null ? !runtimeProvider.equals(that.runtimeProvider) :that.runtimeProvider != null) return false;
    if (runtimeVersion != null ? !runtimeVersion.equals(that.runtimeVersion) :that.runtimeVersion != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(capabilities,  conditions,  configuration,  dependencies,  digest,  generatedResources,  generatedSources,  image,  integrationKit,  kit,  lastInitTimestamp,  phase,  platform,  profile,  replicas,  runtimeProvider,  runtimeVersion,  selector,  version,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (capabilities != null && !capabilities.isEmpty()) { sb.append("capabilities:"); sb.append(capabilities + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (configuration != null && !configuration.isEmpty()) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (digest != null) { sb.append("digest:"); sb.append(digest + ","); }
    if (generatedResources != null && !generatedResources.isEmpty()) { sb.append("generatedResources:"); sb.append(generatedResources + ","); }
    if (generatedSources != null && !generatedSources.isEmpty()) { sb.append("generatedSources:"); sb.append(generatedSources + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (integrationKit != null) { sb.append("integrationKit:"); sb.append(integrationKit + ","); }
    if (kit != null) { sb.append("kit:"); sb.append(kit + ","); }
    if (lastInitTimestamp != null) { sb.append("lastInitTimestamp:"); sb.append(lastInitTimestamp + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (runtimeProvider != null) { sb.append("runtimeProvider:"); sb.append(runtimeProvider + ","); }
    if (runtimeVersion != null) { sb.append("runtimeVersion:"); sb.append(runtimeVersion + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends IntegrationConditionFluentImpl<IntegrationStatusFluent.ConditionsNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,IntegrationCondition item) {
      this.index = index;
      this.builder = new IntegrationConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(this);
    }
    io.fabric8.camelk.v1.IntegrationConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) IntegrationStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ConfigurationNestedImpl<N> extends ConfigurationSpecFluentImpl<IntegrationStatusFluent.ConfigurationNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigurationNestedImpl(java.lang.Integer index,ConfigurationSpec item) {
      this.index = index;
      this.builder = new ConfigurationSpecBuilder(this, item);
    }
    ConfigurationNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(this);
    }
    io.fabric8.camelk.v1.ConfigurationSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) IntegrationStatusFluentImpl.this.setToConfiguration(index,builder.build());
    }
    public N endConfiguration() {
      return and();
    }
    
  }
  class GeneratedResourcesNestedImpl<N> extends ResourceSpecFluentImpl<IntegrationStatusFluent.GeneratedResourcesNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GeneratedResourcesNestedImpl(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
      this.index = index;
      this.builder = new ResourceSpecBuilder(this, item);
    }
    GeneratedResourcesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(this);
    }
    io.fabric8.camelk.v1.ResourceSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) IntegrationStatusFluentImpl.this.setToGeneratedResources(index,builder.build());
    }
    public N endGeneratedResource() {
      return and();
    }
    
  }
  class GeneratedSourcesNestedImpl<N> extends SourceSpecFluentImpl<IntegrationStatusFluent.GeneratedSourcesNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GeneratedSourcesNestedImpl(java.lang.Integer index,SourceSpec item) {
      this.index = index;
      this.builder = new SourceSpecBuilder(this, item);
    }
    GeneratedSourcesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.SourceSpecBuilder(this);
    }
    io.fabric8.camelk.v1.SourceSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) IntegrationStatusFluentImpl.this.setToGeneratedSources(index,builder.build());
    }
    public N endGeneratedSource() {
      return and();
    }
    
  }
  class IntegrationKitNestedImpl<N> extends ObjectReferenceFluentImpl<IntegrationStatusFluent.IntegrationKitNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.IntegrationKitNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IntegrationKitNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    IntegrationKitNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) IntegrationStatusFluentImpl.this.withIntegrationKit(builder.build());
    }
    public N endIntegrationKit() {
      return and();
    }
    
  }
  
}