package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationSpecBuilder extends IntegrationSpecFluentImpl<IntegrationSpecBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.IntegrationSpec,io.fabric8.camelk.v1.IntegrationSpecBuilder>{
  public IntegrationSpecBuilder() {
    this(false);
  }
  public IntegrationSpecBuilder(Boolean validationEnabled) {
    this(new IntegrationSpec(), validationEnabled);
  }
  public IntegrationSpecBuilder(IntegrationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationSpecBuilder(io.fabric8.camelk.v1.IntegrationSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IntegrationSpec(), validationEnabled);
  }
  public IntegrationSpecBuilder(io.fabric8.camelk.v1.IntegrationSpecFluent<?> fluent,io.fabric8.camelk.v1.IntegrationSpec instance) {
    this(fluent, instance, false);
  }
  public IntegrationSpecBuilder(io.fabric8.camelk.v1.IntegrationSpecFluent<?> fluent,io.fabric8.camelk.v1.IntegrationSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfiguration(instance.getConfiguration()); 
    fluent.withDependencies(instance.getDependencies()); 
    fluent.withFlows(instance.getFlows()); 
    fluent.withIntegrationKit(instance.getIntegrationKit()); 
    fluent.withKit(instance.getKit()); 
    fluent.withProfile(instance.getProfile()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withRepositories(instance.getRepositories()); 
    fluent.withResources(instance.getResources()); 
    fluent.withServiceAccountName(instance.getServiceAccountName()); 
    fluent.withSources(instance.getSources()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withTraits(instance.getTraits()); 
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationSpecBuilder(io.fabric8.camelk.v1.IntegrationSpec instance) {
    this(instance,false);
  }
  public IntegrationSpecBuilder(io.fabric8.camelk.v1.IntegrationSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfiguration(instance.getConfiguration()); 
    this.withDependencies(instance.getDependencies()); 
    this.withFlows(instance.getFlows()); 
    this.withIntegrationKit(instance.getIntegrationKit()); 
    this.withKit(instance.getKit()); 
    this.withProfile(instance.getProfile()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRepositories(instance.getRepositories()); 
    this.withResources(instance.getResources()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withSources(instance.getSources()); 
    this.withTemplate(instance.getTemplate()); 
    this.withTraits(instance.getTraits()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.IntegrationSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.IntegrationSpec build() {
    IntegrationSpec buildable = new IntegrationSpec(fluent.getConfiguration(),fluent.getDependencies(),fluent.getFlows(),fluent.getIntegrationKit(),fluent.getKit(),fluent.getProfile(),fluent.getReplicas(),fluent.getRepositories(),fluent.getResources(),fluent.getServiceAccountName(),fluent.getSources(),fluent.getTemplate(),fluent.getTraits());
    return buildable;
  }
  
}