package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IntegrationPlatformSpecFluentImpl<A extends IntegrationPlatformSpecFluent<A>> extends BaseFluent<A> implements IntegrationPlatformSpecFluent<A>{
  public IntegrationPlatformSpecFluentImpl() {
  }
  public IntegrationPlatformSpecFluentImpl(io.fabric8.camelk.v1.IntegrationPlatformSpec instance) {
    this.withBuild(instance.getBuild()); 
    this.withCluster(instance.getCluster()); 
    this.withConfiguration(instance.getConfiguration()); 
    this.withKamelet(instance.getKamelet()); 
    this.withProfile(instance.getProfile()); 
    this.withResources(instance.getResources()); 
    this.withTraits(instance.getTraits()); 
  }
  private IntegrationPlatformBuildSpecBuilder build;
  private String cluster;
  private ArrayList<ConfigurationSpecBuilder> configuration = new java.util.ArrayList<ConfigurationSpecBuilder>();
  private IntegrationPlatformKameletSpecBuilder kamelet;
  private java.lang.String profile;
  private IntegrationPlatformResourcesSpecBuilder resources;
  private Map<java.lang.String,TraitSpec> traits;
  
  /**
   * This method has been deprecated, please use method buildBuild instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntegrationPlatformBuildSpec getBuild() {
    return this.build!=null ?this.build.build():null;
  }
  public io.fabric8.camelk.v1.IntegrationPlatformBuildSpec buildBuild() {
    return this.build!=null ?this.build.build():null;
  }
  public A withBuild(io.fabric8.camelk.v1.IntegrationPlatformBuildSpec build) {
    _visitables.get("build").remove(this.build);
    if (build!=null){ this.build= new io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder(build); _visitables.get("build").add(this.build);} return (A) this;
  }
  public Boolean hasBuild() {
    return this.build != null;
  }
  public IntegrationPlatformSpecFluent.BuildNested<A> withNewBuild() {
    return new IntegrationPlatformSpecFluentImpl.BuildNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<A> withNewBuildLike(io.fabric8.camelk.v1.IntegrationPlatformBuildSpec item) {
    return new IntegrationPlatformSpecFluentImpl.BuildNestedImpl(item);
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<A> editBuild() {
    return withNewBuildLike(getBuild());
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<A> editOrNewBuild() {
    return withNewBuildLike(getBuild() != null ? getBuild(): new io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder().build());
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<A> editOrNewBuildLike(io.fabric8.camelk.v1.IntegrationPlatformBuildSpec item) {
    return withNewBuildLike(getBuild() != null ? getBuild(): item);
  }
  public java.lang.String getCluster() {
    return this.cluster;
  }
  public A withCluster(java.lang.String cluster) {
    this.cluster=cluster; return (A) this;
  }
  public java.lang.Boolean hasCluster() {
    return this.cluster != null;
  }
  public A addToConfiguration(Integer index,io.fabric8.camelk.v1.ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(index >= 0 ? index : _visitables.get("configuration").size(), builder);this.configuration.add(index >= 0 ? index : configuration.size(), builder); return (A)this;
  }
  public A setToConfiguration(java.lang.Integer index,io.fabric8.camelk.v1.ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("configuration").size()) { _visitables.get("configuration").add(builder); } else { _visitables.get("configuration").set(index, builder);}
    if (index < 0 || index >= configuration.size()) { configuration.add(builder); } else { configuration.set(index, builder);}
     return (A)this;
  }
  public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A addAllToConfiguration(Collection<io.fabric8.camelk.v1.ConfigurationSpec> items) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfiguration(java.util.Collection<io.fabric8.camelk.v1.ConfigurationSpec> items) {
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfiguration(Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    if (configuration == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.ConfigurationSpecBuilder> each = configuration.iterator();
    final List visitables = _visitables.get("configuration");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public List<io.fabric8.camelk.v1.ConfigurationSpec> getConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> buildConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildConfiguration(java.lang.Integer index) {
    return this.configuration.get(index).build();
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildFirstConfiguration() {
    return this.configuration.get(0).build();
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildLastConfiguration() {
    return this.configuration.get(configuration.size() - 1).build();
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfiguration(java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> configuration) {
    if (this.configuration != null) { _visitables.get("configuration").removeAll(this.configuration);}
    if (configuration != null) {this.configuration = new java.util.ArrayList(); for (io.fabric8.camelk.v1.ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
  }
  public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration) {
    if (this.configuration != null) {this.configuration.clear();}
    if (configuration != null) {for (io.fabric8.camelk.v1.ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
  }
  public java.lang.Boolean hasConfiguration() {
    return configuration != null && !configuration.isEmpty();
  }
  public A addNewConfiguration(java.lang.String resourceKey,java.lang.String resourceMountPoint,java.lang.String resourceType,java.lang.String type,java.lang.String value) {
    return (A)addToConfiguration(new ConfigurationSpec(resourceKey, resourceMountPoint, resourceType, type, value));
  }
  public IntegrationPlatformSpecFluent.ConfigurationNested<A> addNewConfiguration() {
    return new IntegrationPlatformSpecFluentImpl.ConfigurationNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> addNewConfigurationLike(io.fabric8.camelk.v1.ConfigurationSpec item) {
    return new io.fabric8.camelk.v1.IntegrationPlatformSpecFluentImpl.ConfigurationNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> setNewConfigurationLike(java.lang.Integer index,io.fabric8.camelk.v1.ConfigurationSpec item) {
    return new io.fabric8.camelk.v1.IntegrationPlatformSpecFluentImpl.ConfigurationNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> editConfiguration(java.lang.Integer index) {
    if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> editFirstConfiguration() {
    if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
    return setNewConfigurationLike(0, buildConfiguration(0));
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> editLastConfiguration() {
    int index = configuration.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> editMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configuration.size();i++) { 
    if (predicate.test(configuration.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  
  /**
   * This method has been deprecated, please use method buildKamelet instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.camelk.v1.IntegrationPlatformKameletSpec getKamelet() {
    return this.kamelet!=null ?this.kamelet.build():null;
  }
  public io.fabric8.camelk.v1.IntegrationPlatformKameletSpec buildKamelet() {
    return this.kamelet!=null ?this.kamelet.build():null;
  }
  public A withKamelet(io.fabric8.camelk.v1.IntegrationPlatformKameletSpec kamelet) {
    _visitables.get("kamelet").remove(this.kamelet);
    if (kamelet!=null){ this.kamelet= new IntegrationPlatformKameletSpecBuilder(kamelet); _visitables.get("kamelet").add(this.kamelet);} return (A) this;
  }
  public java.lang.Boolean hasKamelet() {
    return this.kamelet != null;
  }
  public IntegrationPlatformSpecFluent.KameletNested<A> withNewKamelet() {
    return new IntegrationPlatformSpecFluentImpl.KameletNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<A> withNewKameletLike(io.fabric8.camelk.v1.IntegrationPlatformKameletSpec item) {
    return new io.fabric8.camelk.v1.IntegrationPlatformSpecFluentImpl.KameletNestedImpl(item);
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<A> editKamelet() {
    return withNewKameletLike(getKamelet());
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<A> editOrNewKamelet() {
    return withNewKameletLike(getKamelet() != null ? getKamelet(): new io.fabric8.camelk.v1.IntegrationPlatformKameletSpecBuilder().build());
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<A> editOrNewKameletLike(io.fabric8.camelk.v1.IntegrationPlatformKameletSpec item) {
    return withNewKameletLike(getKamelet() != null ? getKamelet(): item);
  }
  public java.lang.String getProfile() {
    return this.profile;
  }
  public A withProfile(java.lang.String profile) {
    this.profile=profile; return (A) this;
  }
  public java.lang.Boolean hasProfile() {
    return this.profile != null;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.camelk.v1.IntegrationPlatformResourcesSpec getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public io.fabric8.camelk.v1.IntegrationPlatformResourcesSpec buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(io.fabric8.camelk.v1.IntegrationPlatformResourcesSpec resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new IntegrationPlatformResourcesSpecBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
  }
  public java.lang.Boolean hasResources() {
    return this.resources != null;
  }
  public IntegrationPlatformSpecFluent.ResourcesNested<A> withNewResources() {
    return new IntegrationPlatformSpecFluentImpl.ResourcesNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<A> withNewResourcesLike(io.fabric8.camelk.v1.IntegrationPlatformResourcesSpec item) {
    return new io.fabric8.camelk.v1.IntegrationPlatformSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new io.fabric8.camelk.v1.IntegrationPlatformResourcesSpecBuilder().build());
  }
  public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<A> editOrNewResourcesLike(io.fabric8.camelk.v1.IntegrationPlatformResourcesSpec item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public A addToTraits(java.lang.String key,io.fabric8.camelk.v1.TraitSpec value) {
    if(this.traits == null && key != null && value != null) { this.traits = new LinkedHashMap(); }
    if(key != null && value != null) {this.traits.put(key, value);} return (A)this;
  }
  public A addToTraits(java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> map) {
    if(this.traits == null && map != null) { this.traits = new java.util.LinkedHashMap(); }
    if(map != null) { this.traits.putAll(map);} return (A)this;
  }
  public A removeFromTraits(java.lang.String key) {
    if(this.traits == null) { return (A) this; }
    if(key != null && this.traits != null) {this.traits.remove(key);} return (A)this;
  }
  public A removeFromTraits(java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> map) {
    if(this.traits == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.traits != null){this.traits.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> getTraits() {
    return this.traits;
  }
  public <K,V>A withTraits(java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> traits) {
    if (traits == null) { this.traits =  null;} else {this.traits = new java.util.LinkedHashMap(traits);} return (A) this;
  }
  public java.lang.Boolean hasTraits() {
    return this.traits != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IntegrationPlatformSpecFluentImpl that = (IntegrationPlatformSpecFluentImpl) o;
    if (build != null ? !build.equals(that.build) :that.build != null) return false;
    if (cluster != null ? !cluster.equals(that.cluster) :that.cluster != null) return false;
    if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
    if (kamelet != null ? !kamelet.equals(that.kamelet) :that.kamelet != null) return false;
    if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (traits != null ? !traits.equals(that.traits) :that.traits != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(build,  cluster,  configuration,  kamelet,  profile,  resources,  traits,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (build != null) { sb.append("build:"); sb.append(build + ","); }
    if (cluster != null) { sb.append("cluster:"); sb.append(cluster + ","); }
    if (configuration != null && !configuration.isEmpty()) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (kamelet != null) { sb.append("kamelet:"); sb.append(kamelet + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (traits != null && !traits.isEmpty()) { sb.append("traits:"); sb.append(traits); }
    sb.append("}");
    return sb.toString();
  }
  class BuildNestedImpl<N> extends IntegrationPlatformBuildSpecFluentImpl<IntegrationPlatformSpecFluent.BuildNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<N>,Nested<N>{
    BuildNestedImpl(io.fabric8.camelk.v1.IntegrationPlatformBuildSpec item) {
      this.builder = new IntegrationPlatformBuildSpecBuilder(this, item);
    }
    BuildNestedImpl() {
      this.builder = new io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder(this);
    }
    io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder builder;
    public N and() {
      return (N) IntegrationPlatformSpecFluentImpl.this.withBuild(builder.build());
    }
    public N endBuild() {
      return and();
    }
    
  }
  class ConfigurationNestedImpl<N> extends ConfigurationSpecFluentImpl<IntegrationPlatformSpecFluent.ConfigurationNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigurationNestedImpl(java.lang.Integer index,ConfigurationSpec item) {
      this.index = index;
      this.builder = new ConfigurationSpecBuilder(this, item);
    }
    ConfigurationNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(this);
    }
    io.fabric8.camelk.v1.ConfigurationSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) IntegrationPlatformSpecFluentImpl.this.setToConfiguration(index,builder.build());
    }
    public N endConfiguration() {
      return and();
    }
    
  }
  class KameletNestedImpl<N> extends IntegrationPlatformKameletSpecFluentImpl<IntegrationPlatformSpecFluent.KameletNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KameletNestedImpl(io.fabric8.camelk.v1.IntegrationPlatformKameletSpec item) {
      this.builder = new IntegrationPlatformKameletSpecBuilder(this, item);
    }
    KameletNestedImpl() {
      this.builder = new io.fabric8.camelk.v1.IntegrationPlatformKameletSpecBuilder(this);
    }
    io.fabric8.camelk.v1.IntegrationPlatformKameletSpecBuilder builder;
    public N and() {
      return (N) IntegrationPlatformSpecFluentImpl.this.withKamelet(builder.build());
    }
    public N endKamelet() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends IntegrationPlatformResourcesSpecFluentImpl<IntegrationPlatformSpecFluent.ResourcesNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourcesNestedImpl(IntegrationPlatformResourcesSpec item) {
      this.builder = new IntegrationPlatformResourcesSpecBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new io.fabric8.camelk.v1.IntegrationPlatformResourcesSpecBuilder(this);
    }
    io.fabric8.camelk.v1.IntegrationPlatformResourcesSpecBuilder builder;
    public N and() {
      return (N) IntegrationPlatformSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  
}