package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationPlatformConditionBuilder extends IntegrationPlatformConditionFluentImpl<IntegrationPlatformConditionBuilder> implements VisitableBuilder<IntegrationPlatformCondition,io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder>{
  public IntegrationPlatformConditionBuilder() {
    this(false);
  }
  public IntegrationPlatformConditionBuilder(Boolean validationEnabled) {
    this(new IntegrationPlatformCondition(), validationEnabled);
  }
  public IntegrationPlatformConditionBuilder(io.fabric8.camelk.v1.IntegrationPlatformConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationPlatformConditionBuilder(io.fabric8.camelk.v1.IntegrationPlatformConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IntegrationPlatformCondition(), validationEnabled);
  }
  public IntegrationPlatformConditionBuilder(io.fabric8.camelk.v1.IntegrationPlatformConditionFluent<?> fluent,io.fabric8.camelk.v1.IntegrationPlatformCondition instance) {
    this(fluent, instance, false);
  }
  public IntegrationPlatformConditionBuilder(io.fabric8.camelk.v1.IntegrationPlatformConditionFluent<?> fluent,io.fabric8.camelk.v1.IntegrationPlatformCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationPlatformConditionBuilder(io.fabric8.camelk.v1.IntegrationPlatformCondition instance) {
    this(instance,false);
  }
  public IntegrationPlatformConditionBuilder(io.fabric8.camelk.v1.IntegrationPlatformCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withLastUpdateTime(instance.getLastUpdateTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.IntegrationPlatformConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.IntegrationPlatformCondition build() {
    IntegrationPlatformCondition buildable = new IntegrationPlatformCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}