package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationPlatformBuilder extends IntegrationPlatformFluentImpl<IntegrationPlatformBuilder> implements VisitableBuilder<IntegrationPlatform,io.fabric8.camelk.v1.IntegrationPlatformBuilder>{
  public IntegrationPlatformBuilder() {
    this(false);
  }
  public IntegrationPlatformBuilder(Boolean validationEnabled) {
    this(new IntegrationPlatform(), validationEnabled);
  }
  public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatformFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IntegrationPlatform(), validationEnabled);
  }
  public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatformFluent<?> fluent,io.fabric8.camelk.v1.IntegrationPlatform instance) {
    this(fluent, instance, false);
  }
  public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatformFluent<?> fluent,io.fabric8.camelk.v1.IntegrationPlatform instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatform instance) {
    this(instance,false);
  }
  public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatform instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.IntegrationPlatformFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.IntegrationPlatform build() {
    IntegrationPlatform buildable = new IntegrationPlatform(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}