package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationListBuilder extends IntegrationListFluentImpl<IntegrationListBuilder> implements VisitableBuilder<IntegrationList,io.fabric8.camelk.v1.IntegrationListBuilder>{
  public IntegrationListBuilder() {
    this(false);
  }
  public IntegrationListBuilder(Boolean validationEnabled) {
    this(new IntegrationList(), validationEnabled);
  }
  public IntegrationListBuilder(io.fabric8.camelk.v1.IntegrationListFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationListBuilder(io.fabric8.camelk.v1.IntegrationListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IntegrationList(), validationEnabled);
  }
  public IntegrationListBuilder(io.fabric8.camelk.v1.IntegrationListFluent<?> fluent,io.fabric8.camelk.v1.IntegrationList instance) {
    this(fluent, instance, false);
  }
  public IntegrationListBuilder(io.fabric8.camelk.v1.IntegrationListFluent<?> fluent,io.fabric8.camelk.v1.IntegrationList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationListBuilder(io.fabric8.camelk.v1.IntegrationList instance) {
    this(instance,false);
  }
  public IntegrationListBuilder(io.fabric8.camelk.v1.IntegrationList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.IntegrationListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.IntegrationList build() {
    IntegrationList buildable = new IntegrationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}