package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationKitListBuilder extends IntegrationKitListFluentImpl<IntegrationKitListBuilder> implements VisitableBuilder<IntegrationKitList,io.fabric8.camelk.v1.IntegrationKitListBuilder>{
  public IntegrationKitListBuilder() {
    this(false);
  }
  public IntegrationKitListBuilder(Boolean validationEnabled) {
    this(new IntegrationKitList(), validationEnabled);
  }
  public IntegrationKitListBuilder(IntegrationKitListFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationKitListBuilder(io.fabric8.camelk.v1.IntegrationKitListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IntegrationKitList(), validationEnabled);
  }
  public IntegrationKitListBuilder(io.fabric8.camelk.v1.IntegrationKitListFluent<?> fluent,io.fabric8.camelk.v1.IntegrationKitList instance) {
    this(fluent, instance, false);
  }
  public IntegrationKitListBuilder(io.fabric8.camelk.v1.IntegrationKitListFluent<?> fluent,io.fabric8.camelk.v1.IntegrationKitList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationKitListBuilder(io.fabric8.camelk.v1.IntegrationKitList instance) {
    this(instance,false);
  }
  public IntegrationKitListBuilder(io.fabric8.camelk.v1.IntegrationKitList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.IntegrationKitListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.IntegrationKitList build() {
    IntegrationKitList buildable = new IntegrationKitList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}