package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationKitBuilder extends IntegrationKitFluentImpl<IntegrationKitBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.IntegrationKit,io.fabric8.camelk.v1.IntegrationKitBuilder>{
  public IntegrationKitBuilder() {
    this(false);
  }
  public IntegrationKitBuilder(Boolean validationEnabled) {
    this(new IntegrationKit(), validationEnabled);
  }
  public IntegrationKitBuilder(IntegrationKitFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationKitBuilder(io.fabric8.camelk.v1.IntegrationKitFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IntegrationKit(), validationEnabled);
  }
  public IntegrationKitBuilder(io.fabric8.camelk.v1.IntegrationKitFluent<?> fluent,io.fabric8.camelk.v1.IntegrationKit instance) {
    this(fluent, instance, false);
  }
  public IntegrationKitBuilder(io.fabric8.camelk.v1.IntegrationKitFluent<?> fluent,io.fabric8.camelk.v1.IntegrationKit instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationKitBuilder(io.fabric8.camelk.v1.IntegrationKit instance) {
    this(instance,false);
  }
  public IntegrationKitBuilder(io.fabric8.camelk.v1.IntegrationKit instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.IntegrationKitFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.IntegrationKit build() {
    IntegrationKit buildable = new IntegrationKit(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}